/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.puzzles;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.BlockHopper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.lwjgl.opengl.GL11;

@RegisterEvents
public class SilverFishSolver {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final List<Point> steps = new ArrayList<Point>();
    private static BlockPos silverfishChestPos;
    private static EnumFacing roomFacing;
    private static int[][] grid;
    private static EntitySilverfish silverfish;
    private static Point silverfishPos;
    private int ticks = 0;
    private boolean prevInSilverfishRoom = false;
    private boolean inSilverfishRoom = false;

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START || !TablistParser.currentLocation.isDungeon() || SilverFishSolver.mc.field_71439_g == null || SilverFishSolver.mc.field_71441_e == null) {
            return;
        }
        if (!Config.feature.dungeons.dungeonsSilverfishSolver) {
            return;
        }
        List silverfishes = SilverFishSolver.mc.field_71441_e.func_175644_a(EntitySilverfish.class, s -> SilverFishSolver.mc.field_71439_g.func_70032_d((Entity)s) < 20.0f);
        if (!silverfishes.isEmpty()) {
            silverfish = (EntitySilverfish)silverfishes.get(0);
            if (silverfishChestPos == null || roomFacing == null) {
                if (this.ticks % 20 == 0) {
                    new Thread(() -> {
                        this.prevInSilverfishRoom = this.inSilverfishRoom;
                        double x = SilverFishSolver.mc.field_71439_g.field_70165_t;
                        double z = SilverFishSolver.mc.field_71439_g.field_70161_v;
                        AxisAlignedBB entityScan = new AxisAlignedBB(x - 25.0, 67.0, z - 25.0, x + 25.0, 68.0, z + 25.0);
                        List silverfishList = SilverFishSolver.mc.field_71441_e.func_72872_a(EntitySilverfish.class, entityScan);
                        List items = SilverFishSolver.mc.field_71441_e.func_72872_a(EntityItem.class, entityScan);
                        if (!silverfishList.isEmpty() && !items.isEmpty()) {
                            double silverfishX = ((EntitySilverfish)silverfishList.get((int)0)).field_70165_t;
                            double silverfishZ = ((EntitySilverfish)silverfishList.get((int)0)).field_70161_v;
                            block0: for (EntityItem item : items) {
                                if (Item.func_150891_b((Item)item.func_92059_d().func_77973_b()) != 46 || !(Math.abs(item.field_70165_t - silverfishX) < 1.0) || !(Math.abs(item.field_70161_v - silverfishZ) < 1.0)) continue;
                                Iterable blocks = BlockPos.func_177980_a((BlockPos)new BlockPos(SilverFishSolver.mc.field_71439_g.field_70165_t - 27.0, 66.0, SilverFishSolver.mc.field_71439_g.field_70161_v - 27.0), (BlockPos)new BlockPos(SilverFishSolver.mc.field_71439_g.field_70165_t + 27.0, 66.0, SilverFishSolver.mc.field_71439_g.field_70161_v + 27.0));
                                for (BlockPos blockPos : blocks) {
                                    if (SilverFishSolver.mc.field_71441_e.func_180495_p(blockPos).func_177230_c() != Blocks.field_150403_cj || SilverFishSolver.mc.field_71441_e.func_180495_p(blockPos.func_177982_a(0, 3, 0)).func_177230_c() != Blocks.field_150438_bZ) continue;
                                    this.inSilverfishRoom = true;
                                    if (this.prevInSilverfishRoom) continue block0;
                                    silverfishChestPos = blockPos.func_177982_a(0, 1, 0);
                                    TileEntity hopper = SilverFishSolver.mc.field_71441_e.func_175625_s(blockPos.func_177982_a(0, 3, 0));
                                    roomFacing = BlockHopper.func_176428_b((int)hopper.func_145832_p());
                                    System.out.printf("Silverfish chest is at %s and is facing %s%n", silverfishChestPos, roomFacing);
                                    continue block0;
                                }
                            }
                        }
                    }, "Ice-Path-Detection").start();
                    this.ticks = 0;
                }
            } else if (grid == null) {
                grid = this.getLayout();
                silverfishPos = this.getGridPointFromPos(silverfish.func_180425_c());
                steps.clear();
                if (silverfishPos != null) {
                    steps.addAll(this.solve(grid, SilverFishSolver.silverfishPos.x, SilverFishSolver.silverfishPos.y, 9, 0));
                }
            }
        }
        if (silverfish != null && grid != null) {
            Point silverfishGridPos = this.getGridPointFromPos(silverfish.func_180425_c());
            if (silverfish.func_70089_S() && !Objects.equals(silverfishGridPos, silverfishPos) && (silverfishPos = silverfishGridPos) != null) {
                steps.clear();
                steps.addAll(this.solve(grid, SilverFishSolver.silverfishPos.x, SilverFishSolver.silverfishPos.y, 9, 0));
            }
        }
        ++this.ticks;
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        if (!Config.feature.dungeons.dungeonsSilverfishSolver) {
            return;
        }
        if (silverfishChestPos != null && roomFacing != null && grid != null && silverfish.func_70089_S()) {
            for (int i = 0; i < steps.size() - 1; ++i) {
                Point point = steps.get(i);
                Point point2 = steps.get(i + 1);
                Vec3 pos = this.getVec3RelativeToGrid(point.x, point.y);
                Vec3 pos2 = this.getVec3RelativeToGrid(point2.x, point2.y);
                GlStateManager.func_179129_p();
                assert (pos != null);
                assert (pos2 != null);
                SilverFishSolver.draw3DLine(pos.func_72441_c(0.5, 0.5, 0.5), pos2.func_72441_c(0.5, 0.5, 0.5), 5, new Color(255, 0, 0), event.partialTicks);
                GlStateManager.func_179089_o();
            }
        }
    }

    @SubscribeEvent
    public void onWorldChange(WorldEvent.Load event) {
        silverfishChestPos = null;
        roomFacing = null;
        grid = null;
        steps.clear();
        silverfish = null;
        silverfishPos = null;
    }

    public static void draw3DLine(Vec3 pos1, Vec3 pos2, int width, Color color, float partialTicks) {
        Entity render = Minecraft.func_71410_x().func_175606_aa();
        WorldRenderer worldRenderer = Tessellator.func_178181_a().func_178180_c();
        double realX = render.field_70142_S + (render.field_70165_t - render.field_70142_S) * (double)partialTicks;
        double realY = render.field_70137_T + (render.field_70163_u - render.field_70137_T) * (double)partialTicks;
        double realZ = render.field_70136_U + (render.field_70161_v - render.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-realX), (double)(-realY), (double)(-realZ));
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glLineWidth((float)width);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        worldRenderer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(pos1.field_72450_a, pos1.field_72448_b, pos1.field_72449_c).func_181675_d();
        worldRenderer.func_181662_b(pos2.field_72450_a, pos2.field_72448_b, pos2.field_72449_c).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179137_b((double)realX, (double)realY, (double)realZ);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static Iterable<BlockPos> getBlocksWithinRangeAtSameY(BlockPos center, int radius, int y) {
        BlockPos corner1 = new BlockPos(center.func_177958_n() - radius, y, center.func_177952_p() - radius);
        BlockPos corner2 = new BlockPos(center.func_177958_n() + radius, y, center.func_177952_p() + radius);
        return BlockPos.func_177980_a((BlockPos)corner1, (BlockPos)corner2);
    }

    private Vec3 getVec3RelativeToGrid(int column, int row) {
        if (silverfishChestPos == null || roomFacing == null) {
            return null;
        }
        return new Vec3((Vec3i)silverfishChestPos.func_177967_a(roomFacing.func_176734_d(), 4).func_177967_a(roomFacing.func_176735_f(), 8).func_177967_a(roomFacing.func_176746_e(), column).func_177967_a(roomFacing.func_176734_d(), row));
    }

    private Point getGridPointFromPos(BlockPos pos) {
        if (silverfishChestPos == null || roomFacing == null) {
            return null;
        }
        for (int row = 0; row < 17; ++row) {
            for (int column = 0; column < 17; ++column) {
                Vec3 vec = this.getVec3RelativeToGrid(column, row);
                if (vec == null || !new BlockPos(vec).equals((Object)pos)) continue;
                return new Point(column, row);
            }
        }
        return null;
    }

    private int[][] getLayout() {
        if (silverfishChestPos == null || roomFacing == null) {
            return null;
        }
        int[][] grid = new int[17][17];
        for (int row = 0; row < 17; ++row) {
            for (int column = 0; column < 17; ++column) {
                Vec3 vec = this.getVec3RelativeToGrid(column, row);
                if (vec == null) continue;
                grid[row][column] = SilverFishSolver.mc.field_71441_e.func_180495_p(new BlockPos(vec)).func_177230_c() != Blocks.field_150350_a ? 1 : 0;
            }
            if (row != 16) continue;
            return grid;
        }
        return null;
    }

    private ArrayList<Point> solve(int[][] iceCave, int startX, int startY, int endX, int endY) {
        Point startPoint = new Point(startX, startY);
        LinkedList<Point> queue = new LinkedList<Point>();
        Point[][] iceCaveColors = new Point[iceCave.length][iceCave[0].length];
        queue.addLast(new Point(startX, startY));
        iceCaveColors[startY][startX] = startPoint;
        while (!queue.isEmpty()) {
            Point currPos = (Point)queue.pollFirst();
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                Point nextPos = this.move(iceCave, iceCaveColors, currPos, dir);
                if (nextPos == null) continue;
                queue.addLast(nextPos);
                iceCaveColors[(int)nextPos.getY()][(int)nextPos.getX()] = new Point((int)currPos.getX(), (int)currPos.getY());
                if (nextPos.getY() != (double)endY || nextPos.getX() != (double)endX) continue;
                ArrayList<Point> steps = new ArrayList<Point>();
                Point tmp = currPos;
                int count = 0;
                steps.add(nextPos);
                steps.add(currPos);
                while (tmp != startPoint) {
                    ++count;
                    tmp = iceCaveColors[(int)tmp.getY()][(int)tmp.getX()];
                    steps.add(tmp);
                }
                return steps;
            }
        }
        return Lists.newArrayList();
    }

    private Point move(int[][] iceCave, Point[][] iceCaveColors, Point currPos, EnumFacing dir) {
        int x = (int)currPos.getX();
        int y = (int)currPos.getY();
        int diffX = dir.func_176730_m().func_177958_n();
        int diffY = dir.func_176730_m().func_177952_p();
        int i = 1;
        while (x + i * diffX >= 0 && x + i * diffX < iceCave[0].length && y + i * diffY >= 0 && y + i * diffY < iceCave.length && iceCave[y + i * diffY][x + i * diffX] != 1) {
            ++i;
        }
        if (iceCaveColors[y + --i * diffY][x + i * diffX] != null) {
            return null;
        }
        return new Point(x + i * diffX, y + i * diffY);
    }

    static {
        grid = null;
        silverfish = null;
        silverfishPos = null;
    }
}

