/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.puzzles;

import java.awt.Color;
import java.util.HashSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.TablistParser;

@RegisterEvents
public class TeleportMazeSolver {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final HashSet<BlockPos> steppedPads = new HashSet();
    private static BlockPos lastTpPos;

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!Config.feature.dungeons.dungeonsTeleportMaze || !TablistParser.currentLocation.isDungeon()) {
            return;
        }
        if (TeleportMazeSolver.mc.field_71439_g == null || TeleportMazeSolver.mc.field_71441_e == null) {
            return;
        }
        BlockPos groundBlock = new BlockPos(TeleportMazeSolver.mc.field_71439_g.field_70165_t, 69.0, TeleportMazeSolver.mc.field_71439_g.field_70161_v);
        IBlockState state = TeleportMazeSolver.mc.field_71441_e.func_180495_p(groundBlock);
        if (state.func_177230_c() == Blocks.field_150333_U) {
            if (lastTpPos != null) {
                boolean inNewCell = false;
                for (BlockPos routeTrace : BlockPos.func_177980_a((BlockPos)lastTpPos, (BlockPos)groundBlock)) {
                    if (TeleportMazeSolver.mc.field_71441_e.func_180495_p(routeTrace).func_177230_c() != Blocks.field_150411_aY) continue;
                    inNewCell = true;
                    break;
                }
                if (inNewCell) {
                    for (BlockPos pad : TeleportMazeSolver.getBlocksWithinRangeAtSameY(lastTpPos, 1, 69)) {
                        if (TeleportMazeSolver.mc.field_71441_e.func_180495_p(pad).func_177230_c() != Blocks.field_150378_br) continue;
                        steppedPads.add(pad);
                        break;
                    }
                    for (BlockPos pad : TeleportMazeSolver.getBlocksWithinRangeAtSameY(groundBlock, 1, 69)) {
                        if (TeleportMazeSolver.mc.field_71441_e.func_180495_p(pad).func_177230_c() != Blocks.field_150378_br) continue;
                        steppedPads.add(pad);
                        break;
                    }
                }
            }
            lastTpPos = groundBlock;
        }
    }

    public static Iterable<BlockPos> getBlocksWithinRangeAtSameY(BlockPos center, int radius, int y) {
        BlockPos corner1 = new BlockPos(center.func_177958_n() - radius, y, center.func_177952_p() - radius);
        BlockPos corner2 = new BlockPos(center.func_177958_n() + radius, y, center.func_177952_p() + radius);
        return BlockPos.func_177980_a((BlockPos)corner1, (BlockPos)corner2);
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        if (!Config.feature.dungeons.dungeonsTeleportMaze) {
            return;
        }
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)event.partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)event.partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)event.partialTicks;
        for (BlockPos pos : steppedPads) {
            double x = (double)pos.func_177958_n() - viewerX;
            double y = (double)pos.func_177956_o() - viewerY;
            double z = (double)pos.func_177952_p() - viewerZ;
            GlStateManager.func_179129_p();
            TeleportMazeSolver.drawFilledBoundingBox(new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_72314_b(0.01, 0.01, 0.01), new Color(255, 0, 0), 1.0f);
            GlStateManager.func_179089_o();
        }
    }

    @SubscribeEvent
    public void onWorldChange(WorldEvent.Load event) {
        steppedPads.clear();
        lastTpPos = null;
    }

    public static void drawFilledBoundingBox(AxisAlignedBB aabb, Color c, float alphaMultiplier) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)((float)c.getAlpha() / 255.0f * alphaMultiplier));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f * 0.8f), (float)((float)c.getGreen() / 255.0f * 0.8f), (float)((float)c.getBlue() / 255.0f * 0.8f), (float)((float)c.getAlpha() / 255.0f * alphaMultiplier));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f * 0.9f), (float)((float)c.getGreen() / 255.0f * 0.9f), (float)((float)c.getBlue() / 255.0f * 0.9f), (float)((float)c.getAlpha() / 255.0f * alphaMultiplier));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }
}

