/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.puzzles;

import java.awt.Color;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.lwjgl.opengl.GL11;

@RegisterEvents
public class ThreeWeirdos {
    private static final String[] answers = new String[]{"The reward is not in my chest!", "At least one of them is lying, and the reward is not in ", "My chest doesn't have the reward we are all telling the truth.", "My chest has the reward and I'm telling the truth!", "The reward isn't in any of our chests.", "Both of them are telling the truth. Also, "};
    private static final Pattern threeWeirdosPattern = Pattern.compile("(\u00a7r\u00a7e\\[NPC] \u00a7r\u00a7c)(.+)(\u00a7r\u00a7f:)(.+)");
    private static final Pattern threeWeirdosSolved = Pattern.compile("\u00a7r\u00a7a\u00a7lPUZZLE SOLVED! (?<player>.+) \u00a7r\u00a7ewasn't fooled by three weirdos!(.+)");
    private final Minecraft mc = Minecraft.func_71410_x();
    private boolean foundResponse = false;
    private String correctName = "";
    private BlockPos riddleChest = null;

    @SubscribeEvent
    public void onChatReceive(ClientChatReceivedEvent e) {
        if (!Config.feature.dungeons.dungeonsThreeWeirdos) {
            return;
        }
        if (this.mc.field_71439_g == null) {
            return;
        }
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (!TablistParser.currentLocation.isDungeon()) {
            return;
        }
        if (e.message.func_150254_d().startsWith("\u00a7c")) {
            return;
        }
        Matcher matcher = threeWeirdosPattern.matcher(e.message.func_150254_d());
        if (matcher.find()) {
            String name = matcher.group(2);
            String message = matcher.group(4);
            for (String answer : answers) {
                if (!message.contains(answer)) continue;
                this.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a7a[Riddle Solver] \u00a7r\u00a7c" + name + "\u00a7r\u00a7f has the blessing!"));
                e.setCanceled(true);
                this.foundResponse = true;
                this.correctName = name;
                SoundUtils.playSound(this.mc.field_71439_g.func_180425_c(), "note.pling", 4.0f, 1.0f);
                this.findRiddleChest(name);
                return;
            }
        } else if (threeWeirdosSolved.matcher(e.message.func_150254_d()).matches()) {
            this.foundResponse = false;
            this.correctName = "";
        }
    }

    private void findRiddleChest(String npcName) {
        if (this.riddleChest == null) {
            List entities = this.mc.field_71441_e.field_72996_f;
            for (Entity entity : entities) {
                if (entity == null || !entity.func_145818_k_() || !entity.func_95999_t().contains(npcName)) continue;
                BlockPos npcLocation = new BlockPos(entity.field_70165_t, 69.0, entity.field_70161_v);
                this.riddleChest = this.checkAdjacentForChest(npcLocation);
                if (this.riddleChest != null) break;
                System.out.print("Could not find correct riddle chest.");
                break;
            }
        }
    }

    private BlockPos checkAdjacentForChest(BlockPos npcLocation) {
        if (this.mc.field_71441_e.func_180495_p(npcLocation.func_177978_c()).func_177230_c() == Blocks.field_150486_ae) {
            return npcLocation.func_177978_c();
        }
        if (this.mc.field_71441_e.func_180495_p(npcLocation.func_177974_f()).func_177230_c() == Blocks.field_150486_ae) {
            return npcLocation.func_177974_f();
        }
        if (this.mc.field_71441_e.func_180495_p(npcLocation.func_177968_d()).func_177230_c() == Blocks.field_150486_ae) {
            return npcLocation.func_177968_d();
        }
        if (this.mc.field_71441_e.func_180495_p(npcLocation.func_177976_e()).func_177230_c() == Blocks.field_150486_ae) {
            return npcLocation.func_177976_e();
        }
        return null;
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (!Config.feature.dungeons.dungeonsThreeWeirdos) {
            return;
        }
        if (this.mc.field_71441_e == null) {
            return;
        }
        if (!this.foundResponse) {
            return;
        }
        if (this.correctName.isEmpty()) {
            return;
        }
        if (this.riddleChest != null) {
            ThreeWeirdos.drawFilled3DBox(new AxisAlignedBB((double)this.riddleChest.func_177958_n() - 0.05, (double)this.riddleChest.func_177956_o(), (double)this.riddleChest.func_177952_p() - 0.05, (double)this.riddleChest.func_177958_n() + 1.05, (double)(this.riddleChest.func_177956_o() + 1), (double)this.riddleChest.func_177952_p() + 1.05), 65280, true, true, event.partialTicks);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.correctName = "";
        this.foundResponse = false;
        this.riddleChest = null;
    }

    @SubscribeEvent
    public void onWorldChange(WorldEvent.Load event) {
        this.riddleChest = null;
    }

    public static void drawFilled3DBox(AxisAlignedBB aabb, int colourInt, boolean translucent, boolean depth, float partialTicks) {
        Entity render = Minecraft.func_71410_x().func_175606_aa();
        WorldRenderer worldRenderer = Tessellator.func_178181_a().func_178180_c();
        Color colour = new Color(colourInt);
        double realX = render.field_70142_S + (render.field_70165_t - render.field_70142_S) * (double)partialTicks;
        double realY = render.field_70137_T + (render.field_70163_u - render.field_70137_T) * (double)partialTicks;
        double realZ = render.field_70136_U + (render.field_70161_v - render.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179137_b((double)(-realX), (double)(-realY), (double)(-realZ));
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179129_p();
        if (!depth) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
        }
        GL11.glEnable((int)32823);
        GL11.glPolygonOffset((float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getAlpha() / 255.0f));
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glDisable((int)32823);
        if (!depth) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }
}

