/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.puzzles;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.ginafro.notenoughfakepixel.utils.Logger;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;

@RegisterEvents
public class WaterSolver {
    private Minecraft mc = Minecraft.func_71410_x();
    private EntityPlayerSP player;
    private World world;
    private static final List<EnumDyeColor> WOOL_ORDER = Arrays.asList(EnumDyeColor.LIME, EnumDyeColor.BLUE, EnumDyeColor.RED, EnumDyeColor.PURPLE, EnumDyeColor.ORANGE);
    private boolean inWaterRoom;
    private int tickCounter;
    private Set<EnumDyeColor> woolBlocks;
    private Map<String, BlockPos> leversPositions;
    private ArrayList<boolean[]> correctLevers;
    private BlockPos waterLeverPos;

    public WaterSolver() {
        this.player = this.mc.field_71439_g;
        this.world = this.mc.field_71441_e;
        this.inWaterRoom = false;
        this.tickCounter = 0;
        this.woolBlocks = new LinkedHashSet<EnumDyeColor>();
        this.leversPositions = new HashMap<String, BlockPos>();
        this.correctLevers = new ArrayList();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (!Config.feature.dungeons.dungeonsWaterSolver) {
            return;
        }
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 20 != 0) {
            return;
        }
        this.mc = Minecraft.func_71410_x();
        this.player = this.mc.field_71439_g;
        this.world = this.mc.field_71441_e;
        if (this.player == null || this.world == null) {
            return;
        }
        boolean waterLeverPowered = false;
        if (this.waterLeverPos != null && this.world.func_180495_p(this.waterLeverPos).func_177230_c() == Blocks.field_150442_at) {
            waterLeverPowered = (Boolean)this.world.func_180495_p(this.waterLeverPos).func_177229_b((IProperty)BlockLever.field_176359_b);
        }
        new Thread(this::detectWaterRoom).start();
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        if (!Config.feature.dungeons.dungeonsWaterSolver) {
            return;
        }
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        if (!this.inWaterRoom || this.woolBlocks == null || this.woolBlocks.isEmpty()) {
            return;
        }
        if (!this.woolBlocks.iterator().hasNext()) {
            return;
        }
        ArrayList<EnumDyeColor> woolList = new ArrayList<EnumDyeColor>(this.woolBlocks);
        for (int i = 0; i < woolList.size(); ++i) {
            int[] colorSolutions = WOOL_SOLUTIONS.getArraySolutions(((EnumDyeColor)woolList.get(i)).func_176610_l());
            this.drawFeatures(colorSolutions, i, event.partialTicks);
        }
    }

    private void drawFeatures(int[] colorSolutions, float offsetY, float partialTicks) {
        if (this.correctLevers == null || this.correctLevers.isEmpty()) {
            return;
        }
        int solutionNumber = (int)offsetY;
        ArrayList<BlockPos> boundingBoxPositions = new ArrayList<BlockPos>();
        for (int i = 0; i < colorSolutions.length; ++i) {
            int solution = colorSolutions[i];
            this.correctLevers.get((int)solutionNumber)[i] = true;
            BlockPos position = null;
            switch (i) {
                case 0: {
                    position = this.leversPositions.get("minecraft:quartz_block");
                    break;
                }
                case 1: {
                    position = this.leversPositions.get("minecraft:diamond_block");
                    break;
                }
                case 2: {
                    position = this.leversPositions.get("minecraft:gold_block");
                    break;
                }
                case 3: {
                    position = this.leversPositions.get("minecraft:emerald_block");
                    break;
                }
                case 4: {
                    position = this.leversPositions.get("minecraft:coal_block");
                    break;
                }
                case 5: {
                    position = this.leversPositions.get("minecraft:hardened_clay");
                }
            }
            if (position == null || this.world.func_180495_p(position).func_177230_c() != Blocks.field_150442_at) continue;
            boolean isLeverActive = (Boolean)this.world.func_180495_p(position).func_177229_b((IProperty)BlockLever.field_176359_b);
            if (solution == -1 || solution == 0 && !isLeverActive || solution == 1 && isLeverActive) continue;
            if (offsetY == 0.0f) {
                RenderUtils.draw3DLine(new Vec3((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p()), this.player.func_174824_e(partialTicks), Color.green, 4, true, partialTicks, false, true, (BlockLever.EnumOrientation)this.world.func_180495_p(position).func_177229_b((IProperty)BlockLever.field_176360_a));
            }
            this.correctLevers.get((int)solutionNumber)[i] = false;
            boundingBoxPositions.add(position);
        }
        if (offsetY == 0.0f && WaterSolver.allTrue(this.correctLevers.get(solutionNumber)) && this.waterLeverPos != null) {
            if (this.world.func_180495_p(this.waterLeverPos).func_177230_c() != null && this.world.func_180495_p(this.waterLeverPos).func_177230_c() == Blocks.field_150442_at) {
                RenderUtils.draw3DLine(new Vec3((double)this.waterLeverPos.func_177958_n(), (double)this.waterLeverPos.func_177956_o(), (double)this.waterLeverPos.func_177952_p()), this.player.func_174824_e(partialTicks), Color.green, 4, true, partialTicks, false, true, (BlockLever.EnumOrientation)this.world.func_180495_p(this.waterLeverPos).func_177229_b((IProperty)BlockLever.field_176360_a));
            } else {
                Logger.log("Crash avoided: waterLeverPos is null");
            }
        }
        Color color = Color.green;
        if (offsetY != 0.0f) {
            color = Color.yellow;
        }
        for (BlockPos position : boundingBoxPositions) {
            if (this.world.func_180495_p(position).func_177230_c() != Blocks.field_150442_at) continue;
            RenderUtils.drawLeverBoundingBox(new BlockPos((double)position.func_177958_n(), (double)((float)position.func_177956_o() + offsetY), (double)position.func_177952_p()), ((BlockLever.EnumOrientation)this.world.func_180495_p(position).func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c(), color, partialTicks);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Load event) {
        if (!Config.feature.dungeons.dungeonsWaterSolver) {
            return;
        }
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        this.waterLeverPos = null;
        this.correctLevers = new ArrayList();
    }

    private void detectWaterRoom() {
        if (this.checkForBlock((Block)Blocks.field_150320_F, 20, 57) == null) {
            this.woolBlocks = null;
            this.correctLevers = new ArrayList();
            return;
        }
        BlockPos foundPistonHead = this.checkForBlock((Block)Blocks.field_150332_K, 18, 57);
        if (foundPistonHead != null) {
            this.inWaterRoom = true;
            this.woolBlocks = this.detectWoolBlocks(foundPistonHead);
            for (int i = 0; i < this.woolBlocks.size(); ++i) {
                this.correctLevers.add(new boolean[]{true, true, true, true, true, true});
            }
            this.leversPositions = this.detectLeverPositions(new BlockPos(foundPistonHead.func_177958_n(), foundPistonHead.func_177956_o() + 4, foundPistonHead.func_177952_p()));
        }
    }

    private Set<EnumDyeColor> detectWoolBlocks(BlockPos posOrigin) {
        LinkedHashSet<EnumDyeColor> woolBlocks = new LinkedHashSet<EnumDyeColor>();
        BlockPos scan1 = new BlockPos(posOrigin.func_177958_n() + 5, posOrigin.func_177956_o(), posOrigin.func_177952_p() + 5);
        BlockPos scan2 = new BlockPos(posOrigin.func_177958_n() - 5, posOrigin.func_177956_o(), posOrigin.func_177952_p() - 5);
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)scan1, (BlockPos)scan2)) {
            IBlockState blockState = this.world.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block != Blocks.field_150332_K) continue;
            EnumFacing enumfacing = (EnumFacing)blockState.func_177229_b((IProperty)BlockPistonExtension.field_176326_a);
            BlockPos woolPos = WaterSolver.getBlockPistonHead(pos, enumfacing);
            woolBlocks.add((EnumDyeColor)this.world.func_180495_p(woolPos).func_177229_b((IProperty)BlockColored.field_176581_a));
        }
        return this.sortWoolBlocks(woolBlocks);
    }

    private Set<EnumDyeColor> sortWoolBlocks(Set<EnumDyeColor> woolBlocks) {
        LinkedHashSet<EnumDyeColor> sortedSet = new LinkedHashSet<EnumDyeColor>();
        for (EnumDyeColor color : WOOL_ORDER) {
            if (!woolBlocks.contains(color)) continue;
            sortedSet.add(color);
        }
        return sortedSet;
    }

    private Map<String, BlockPos> detectLeverPositions(BlockPos posOrigin) {
        HashMap<String, BlockPos> leversPositions = new HashMap<String, BlockPos>();
        BlockPos scan1 = new BlockPos(posOrigin.func_177958_n() + 16, posOrigin.func_177956_o(), posOrigin.func_177952_p() + 16);
        BlockPos scan2 = new BlockPos(posOrigin.func_177958_n() - 16, posOrigin.func_177956_o() - 1, posOrigin.func_177952_p() - 16);
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)scan1, (BlockPos)scan2)) {
            EnumFacing facing;
            BlockPos behindLever;
            IBlockState blockState = this.world.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block != Blocks.field_150442_at || (behindLever = WaterSolver.getBlockBehindLever(pos, facing = ((BlockLever.EnumOrientation)blockState.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c())) == null) continue;
            Block behindBlock = this.world.func_180495_p(behindLever).func_177230_c();
            String blockName = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)behindBlock)).toString();
            if (this.isTargetBlock(blockName)) {
                leversPositions.put(blockName, pos);
                continue;
            }
            if (!Objects.equals(blockName, "minecraft:stone")) continue;
            this.waterLeverPos = pos;
        }
        return leversPositions;
    }

    private BlockPos checkForBlock(Block targetBlock, int radius, int yLevel) {
        int x = (int)(this.player.field_70165_t - (double)radius);
        while ((double)x <= this.player.field_70165_t + (double)radius) {
            int z = (int)(this.player.field_70161_v - (double)radius);
            while ((double)z <= this.player.field_70161_v + (double)radius) {
                if (this.world.func_180495_p(new BlockPos(x, yLevel, z)).func_177230_c() == targetBlock) {
                    return new BlockPos(x, yLevel, z);
                }
                ++z;
            }
            ++x;
        }
        return null;
    }

    private static BlockPos getBlockPistonHead(BlockPos pos, EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            }
            case EAST: {
                return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case SOUTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
            case WEST: {
                return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return null;
    }

    public static BlockPos getBlockBehindLever(BlockPos pos, EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
            case EAST: {
                return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case SOUTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            }
            case WEST: {
                return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case UP: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
            }
            case DOWN: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
            }
        }
        return null;
    }

    private boolean isTargetBlock(String blockName) {
        return blockName.equals("minecraft:quartz_block") || blockName.equals("minecraft:gold_block") || blockName.equals("minecraft:coal_block") || blockName.equals("minecraft:diamond_block") || blockName.equals("minecraft:emerald_block") || blockName.equals("minecraft:hardened_clay");
    }

    public static boolean allTrue(boolean[] array) {
        for (boolean value : array) {
            if (value) continue;
            return false;
        }
        return true;
    }

    public static enum WOOL_SOLUTIONS {
        LIME("lime", 0, 0, 0, 0, 0, 0),
        BLUE("blue", 0, 0, 0, 0, -1, 1),
        RED("red", 0, 0, 1, -1, 1, -1),
        PURPLE("purple", 1, 1, 1, 0, -1, -1),
        ORANGE("orange", 1, 1, 0, 1, -1, -1);

        private final String color;
        private final int quartzBlock;
        private final int diamondBlock;
        private final int goldBlock;
        private final int emeraldBlock;
        private final int coalBlock;
        private final int hardenedClay;

        private WOOL_SOLUTIONS(String color, int quartz, int diamondBlock, int goldBlock, int emeraldBlock, int coalBlock, int hardenedClay) {
            this.color = color;
            this.quartzBlock = quartz;
            this.diamondBlock = diamondBlock;
            this.goldBlock = goldBlock;
            this.emeraldBlock = emeraldBlock;
            this.coalBlock = coalBlock;
            this.hardenedClay = hardenedClay;
        }

        public static int[] getArraySolutions(String color) {
            for (WOOL_SOLUTIONS solution : WOOL_SOLUTIONS.values()) {
                if (!solution.color.equals(color)) continue;
                return new int[]{solution.quartzBlock, solution.diamondBlock, solution.goldBlock, solution.emeraldBlock, solution.coalBlock, solution.hardenedClay};
            }
            return new int[]{-1, -1, -1, -1, -1, -1};
        }
    }
}

