/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.score;

import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.utils.TitleUtils;
import org.ginafro.notenoughfakepixel.variables.DungeonFloor;

@RegisterEvents
public class ScoreManager {
    static int failedPuzzles = 0;
    public static int currentSeconds = -1;
    private static int reducedPenalty = 0;
    private static boolean hasNotified270 = false;
    private static boolean isBloodOpen = false;
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent event) {
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        if (event.message.func_150260_c().contains("PUZZLE FAIL!")) {
            ++failedPuzzles;
        } else if (event.message.func_150260_c().equals("Your Spirit Pet reduced your death score penalty to 1!")) {
            reducedPenalty = 1;
            Minecraft.func_71410_x().field_71439_g.func_71165_d("/pc [NEF] I died with Spirit Pet, so my kill doesn't count");
        } else if (event.message.func_150260_c().contains("[NEF] I died with Spirit Pet, so my kill doesn't count")) {
            reducedPenalty = 1;
        } else if (event.message.func_150260_c().endsWith("The BLOOD DOOR has been opened!")) {
            isBloodOpen = true;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        this.reset();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        int virtualSecretScore;
        if (!DungeonManager.checkEssentials() || event.phase == TickEvent.Phase.END || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        int currentScore = ScoreManager.getSkillScore() + ScoreManager.getExplorationClearScore() + ScoreManager.getSpeedScore() + ScoreManager.getBonusScore();
        int virtualTotalScore = currentScore + (virtualSecretScore = Math.min(40, ScoreManager.getSecretPercentage() * 40 / DungeonFloor.getFloor(ScoreboardUtils.currentFloor.name()).getSecretPercentage()));
        if (virtualTotalScore >= 270 && !hasNotified270 & Config.feature.dungeons.dungeonsSNotifier) {
            Minecraft.func_71410_x().field_71439_g.func_71165_d("/pc 270 Score!");
            SoundUtils.playSound(this.mc.field_71439_g.func_180425_c(), "note.pling", 2.0f, 2.0f);
            TitleUtils.showTitle(EnumChatFormatting.RED + "270 Score!", 2000);
            hasNotified270 = true;
        }
    }

    private void reset() {
        failedPuzzles = 0;
        currentSeconds = -1;
        reducedPenalty = 0;
        hasNotified270 = false;
        isBloodOpen = false;
    }

    public static int getTotalScore() {
        return ScoreManager.getSkillScore() + ScoreManager.getExplorationScore() + ScoreManager.getSpeedScore() + ScoreManager.getBonusScore();
    }

    public static int getSkillScore() {
        int deaths = TablistParser.deaths;
        return Math.max(Math.min(100 - (deaths - reducedPenalty) * 2 - failedPuzzles * 14, 100), 0);
    }

    public static int getExplorationClearScore() {
        int clearedPercentage = ScoreboardUtils.clearedPercentage;
        if (isBloodOpen) {
            clearedPercentage = Math.min(clearedPercentage + 9, 100);
        }
        int baseScore = (int)Math.max(Math.min(Math.floor(60.0f * (float)clearedPercentage / 100.0f), 60.0), 0.0);
        return baseScore;
    }

    public static int getExplorationSecretScore() {
        int secretPercentage = ScoreManager.getSecretPercentage();
        int secretNeeded = DungeonFloor.getFloor(ScoreboardUtils.currentFloor.name()).getSecretPercentage();
        return (int)Math.max(Math.min(Math.floor(40.0f * (float)secretPercentage / (float)secretNeeded), 40.0), 0.0);
    }

    public static int getExplorationScore() {
        return ScoreManager.getExplorationClearScore() + ScoreManager.getExplorationSecretScore();
    }

    public static int getSpeedScore() {
        String currentTimeString = TablistParser.time;
        currentSeconds = ScoreManager.convertToSeconds(currentTimeString);
        if (currentSeconds == -1) {
            return 100;
        }
        int t = currentSeconds + DungeonFloor.getFloor(ScoreboardUtils.currentFloor.name()).getT();
        if (t < 480) {
            return 100;
        }
        if (t < 600) {
            return 140 - (int)Math.ceil((float)t * 0.083333336f);
        }
        if (t < 840) {
            return 115 - (int)Math.ceil((float)t * 0.041666668f);
        }
        if (t < 1140) {
            return 108 - (int)Math.ceil((float)t * 0.033333335f);
        }
        if (t < 3940) {
            return (int)Math.ceil(98.5f - (float)((int)Math.ceil((float)t * 0.025f)));
        }
        return 0;
    }

    public static int getBonusScore() {
        int crypts = TablistParser.crypts;
        return (Config.feature.dungeons.dungeonsIsPaul ? 10 : 0) + Math.min(5, crypts);
    }

    public static int getSecretPercentage() {
        return TablistParser.secretPercentage;
    }

    public static int getRequiredSecretNeeded() {
        int secretScoreNeeded = 240 - ScoreManager.getSkillScore() - ScoreManager.getSpeedScore() - ScoreManager.getBonusScore();
        if (secretScoreNeeded > 40) {
            return -1;
        }
        return (int)Math.ceil((float)(secretScoreNeeded * DungeonFloor.getFloor(ScoreboardUtils.currentFloor.name()).getSecretPercentage()) / 40.0f);
    }

    public static int convertToSeconds(String time) {
        if (time.isEmpty()) {
            return -1;
        }
        String[] parts = time.split(":");
        int minutes = Integer.parseInt(parts[0]);
        int seconds = Integer.parseInt(parts[1]);
        return minutes * 60 + seconds;
    }
}

