/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.score;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.Configuration;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.score.ScoreManager;
import org.ginafro.notenoughfakepixel.utils.ChatUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.variables.DungeonFloor;

@RegisterEvents
public class ScoreOverlay {
    private static final int chatDisplaySeconds = 40;
    private long readyTime = Long.MAX_VALUE;
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!this.shouldShow()) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(this.mc);
        int overlayWidth = this.getWidth(1.0f);
        int overlayHeight = this.getHeight(1.0f);
        float x = Config.feature.dungeons.scoreOverlayPos.getAbsX(sr, overlayWidth);
        float y = Config.feature.dungeons.scoreOverlayPos.getAbsY(sr, overlayHeight);
        this.draw(x, y, Config.feature.dungeons.scoreOverlayScale, false);
    }

    private boolean shouldShow() {
        if (!DungeonManager.checkEssentials()) {
            return false;
        }
        return Config.feature.dungeons.dungeonsScoreOverlay;
    }

    private void draw(float x, float y, float scale, boolean example) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        ArrayList<String> lines = new ArrayList<String>();
        this.getLines(lines, example);
        String[] colorParts = Config.feature.dungeons.scoreOverlayBackgroundColor.split(":");
        int alpha = Integer.parseInt(colorParts[1]);
        int red = Integer.parseInt(colorParts[2]);
        int green = Integer.parseInt(colorParts[3]);
        int blue = Integer.parseInt(colorParts[4]);
        int bgColor = alpha << 24 | red << 16 | green << 8 | blue;
        int textWidth = 0;
        for (String line : lines) {
            int lineWidth = this.mc.field_71466_p.func_78256_a(line);
            if (lineWidth <= textWidth) continue;
            textWidth = lineWidth;
        }
        int textHeight = lines.size() * 11;
        Gui.func_73734_a((int)0, (int)0, (int)(textWidth += 4), (int)textHeight, (int)bgColor);
        for (int i = 0; i < lines.size(); ++i) {
            this.mc.field_71466_p.func_78276_b((String)lines.get(i), 2, i * 11, -1);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void renderDummy() {
        ScaledResolution sr = new ScaledResolution(this.mc);
        int overlayWidth = this.getWidth(1.0f);
        int overlayHeight = this.getHeight(1.0f);
        float x = Config.feature.dungeons.scoreOverlayPos.getAbsX(sr, overlayWidth);
        float y = Config.feature.dungeons.scoreOverlayPos.getAbsY(sr, overlayHeight);
        this.draw(x, y, Config.feature.dungeons.scoreOverlayScale, true);
    }

    public int getWidth(float scale) {
        int baseWidth = this.mc.field_71466_p.func_78256_a("Total score: 300 (S+)") + 4;
        return (int)((float)baseWidth * scale);
    }

    public int getHeight(float scale) {
        return (int)(110.0f * scale);
    }

    private void getLines(List<String> lines, boolean example) {
        if (example) {
            if (Config.feature.dungeons.dungeonsScoreSimple) {
                lines.add("\u00a77Total score: \u00a7a300\u00a76 (S+)");
                lines.add("");
                lines.add("\u00a77Secrets: \u00a7a100% \u00a7a/ 80% \u00a7a/ 100%");
            } else {
                lines.add("\u00a77Total score: \u00a7a300\u00a76 (S+)");
                lines.add("");
                lines.add("\u00a77Skill: \u00a7a100");
                lines.add("\u00a77Exploration: \u00a7a100");
                lines.add("\u00a77Speed: \u00a7a100");
                lines.add("\u00a77Bonus: \u00a7a5");
                lines.add("");
                lines.add("\u00a77Secrets: \u00a7a100% \u00a7a/ 80% \u00a7a/ 100%");
            }
        } else if (Config.feature.dungeons.dungeonsScoreSimple) {
            lines.add(this.getRankingDisplay());
            lines.add("");
            lines.add(ScoreOverlay.getSecretDisplay());
        } else {
            lines.add(this.getRankingDisplay());
            lines.add("");
            lines.add(this.getSkillDisplay());
            lines.add(this.getExplorationDisplay());
            lines.add(this.getSpeedDisplay());
            lines.add(this.getBonusDisplay());
            lines.add("");
            lines.add(ScoreOverlay.getSecretDisplay());
        }
    }

    private String getRankingDisplay() {
        int totalScore = ScoreManager.getTotalScore();
        if (DungeonManager.isFinalStage() && ScoreManager.getExplorationClearScore() != 60) {
            return EnumChatFormatting.RED + "UNKNOWN SCORE";
        }
        String returnString = "\u00a77Total score: ";
        returnString = totalScore < 100 ? returnString + EnumChatFormatting.RED + totalScore + EnumChatFormatting.RED + " (D)" : (totalScore < 160 ? returnString + EnumChatFormatting.RED + totalScore + EnumChatFormatting.BLUE + " (C)" : (totalScore < 230 ? returnString + EnumChatFormatting.RED + totalScore + EnumChatFormatting.GREEN + " (B)" : ((float)totalScore < 269.5f ? returnString + EnumChatFormatting.YELLOW + totalScore + EnumChatFormatting.LIGHT_PURPLE + " (A)" : (totalScore < 300 ? returnString + EnumChatFormatting.YELLOW + totalScore + EnumChatFormatting.GOLD + " (S)" : returnString + EnumChatFormatting.GREEN + totalScore + EnumChatFormatting.GOLD + " (S+)"))));
        return returnString;
    }

    private String getSkillDisplay() {
        if (DungeonManager.isFinalStage() && ScoreManager.getExplorationClearScore() != 60) {
            return "\u00a77Exploration: " + EnumChatFormatting.RED + "Not all puzzles done";
        }
        int skillScore = ScoreManager.getSkillScore();
        EnumChatFormatting enumChatFormatting = skillScore == 100 ? EnumChatFormatting.GREEN : (skillScore >= 94 ? EnumChatFormatting.YELLOW : EnumChatFormatting.RED);
        return "\u00a77Skill: " + enumChatFormatting + skillScore;
    }

    private String getExplorationDisplay() {
        int explorationScore = ScoreManager.getExplorationScore();
        EnumChatFormatting enumChatFormatting = explorationScore == 100 ? EnumChatFormatting.GREEN : (explorationScore >= 90 ? EnumChatFormatting.YELLOW : EnumChatFormatting.RED);
        return "\u00a77Exploration: " + enumChatFormatting + explorationScore;
    }

    private String getSpeedDisplay() {
        int speedScore = ScoreManager.getSpeedScore();
        EnumChatFormatting enumChatFormatting = speedScore == 100 ? EnumChatFormatting.GREEN : (speedScore >= 90 ? EnumChatFormatting.YELLOW : EnumChatFormatting.RED);
        return "\u00a77Speed: " + enumChatFormatting + speedScore;
    }

    private String getBonusDisplay() {
        int threshold = Config.feature.dungeons.dungeonsIsPaul ? 15 : 5;
        int bonusScore = ScoreManager.getBonusScore();
        EnumChatFormatting enumChatFormatting = bonusScore >= threshold ? EnumChatFormatting.GREEN : (threshold == 15 && bonusScore >= 10 || threshold == 5 && bonusScore > 0 ? EnumChatFormatting.YELLOW : EnumChatFormatting.RED);
        return "\u00a77Bonus: " + enumChatFormatting + bonusScore;
    }

    private static String getSecretDisplay() {
        StringBuilder returnString = new StringBuilder("\u00a77Secrets: ");
        int secretPercentage = ScoreManager.getSecretPercentage();
        int requiredSecretNeeded = ScoreManager.getRequiredSecretNeeded();
        int secretRequirement = DungeonFloor.getFloor(ScoreboardUtils.currentFloor.name()).getSecretPercentage();
        returnString.append(secretPercentage == 0 ? "\u00a7c0% \u00a77/ " : (secretPercentage >= requiredSecretNeeded && requiredSecretNeeded != -1 ? "\u00a7a" : "\u00a7c") + secretPercentage + "% \u00a77/ ");
        if (requiredSecretNeeded == -1) {
            return returnString + "\u00a7c S+ UNREACHABLE!";
        }
        returnString.append(secretPercentage >= requiredSecretNeeded ? "\u00a7a" : "\u00a7c").append(requiredSecretNeeded).append("% \u00a77/ ");
        returnString.append(secretRequirement == 0 ? "\u00a7c?%" : (secretPercentage >= requiredSecretNeeded ? "\u00a7a" : "\u00a7c") + secretRequirement + "%");
        return returnString.toString();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        long currentTime;
        if (!Configuration.isPojav()) {
            return;
        }
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        if (ScoreManager.currentSeconds > 0 && ScoreManager.currentSeconds <= 8) {
            this.readyTime = System.currentTimeMillis() + 40000L;
        }
        if ((currentTime = System.currentTimeMillis()) >= this.readyTime) {
            this.readyTime = currentTime + 40000L;
            ChatUtils.notifyChat(EnumChatFormatting.WHITE + "----- Dungeon Report -----");
            ChatUtils.notifyChat(this.getRankingDisplay());
            ChatUtils.notifyChat("");
            ChatUtils.notifyChat(this.getSkillDisplay());
            ChatUtils.notifyChat(this.getExplorationDisplay());
            ChatUtils.notifyChat(this.getSpeedDisplay());
            ChatUtils.notifyChat(this.getBonusDisplay());
            ChatUtils.notifyChat("");
            ChatUtils.notifyChat(ScoreOverlay.getSecretDisplay());
        }
    }

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent event) {
        if (!Configuration.isPojav()) {
            return;
        }
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        String msg = event.message.func_150260_c();
        if (msg.equals("[NPC] Mort: Good luck.")) {
            this.readyTime = System.currentTimeMillis() + 40000L;
        } else if (msg.contains("> EXTRA STATS <")) {
            this.readyTime = Long.MAX_VALUE;
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!Configuration.isPojav()) {
            return;
        }
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        this.readyTime = Long.MAX_VALUE;
    }
}

