/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.terminals;

import java.awt.Color;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.lwjgl.input.Mouse;

@RegisterEvents
public class ClickInOrderSolver {
    private final LinkedList<Integer> clickQueue = new LinkedList();
    private int processedRounds = 0;
    private static final int SLOT_SIZE = 16;
    private static final int REGION_COLS = 7;
    private static final int REGION_ROWS = 2;
    private long lastUpdateTime = 0L;

    public ClickInOrderSolver() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(this::processQueue, 0L, 150L, TimeUnit.MILLISECONDS);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDrawScreenPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (!Config.feature.dungeons.dungeonsTerminalClickInOrderSolver) {
            return;
        }
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        Container container = ((GuiChest)event.gui).field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
        if (Config.feature.dungeons.dungeonsCustomGuiClickIn && title.startsWith("Click in")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onOpen(GuiOpenEvent e) {
        if (!Config.feature.dungeons.dungeonsTerminalClickInOrderSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (e.gui instanceof GuiChest) {
            GuiChest chest = (GuiChest)e.gui;
            Container container = chest.field_147002_h;
            if (container instanceof ContainerChest) {
                String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
                if (!title.startsWith("Click in")) {
                    return;
                }
                this.processedRounds = 0;
                this.clickQueue.clear();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDrawScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!Config.feature.dungeons.dungeonsTerminalClickInOrderSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        GuiChest chest = (GuiChest)event.gui;
        Container container = chest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
        if (!title.startsWith("Click in")) {
            return;
        }
        ContainerChest containerChest = (ContainerChest)container;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime > 3000L) {
            Minecraft.func_71410_x().func_152344_a(() -> this.clickQueue.clear());
            this.lastUpdateTime = currentTime;
        }
        int effectiveRound = this.processedRounds + this.clickQueue.size();
        if (Config.feature.dungeons.dungeonsCustomGuiClickIn) {
            ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
            float scale = Config.feature.dungeons.dungeonsTerminalsScale;
            int guiWidth = (int)(112.0f * scale);
            int guiHeight = (int)(32.0f * scale);
            int screenWidth = sr.func_78326_a();
            int screenHeight = sr.func_78328_b();
            int guiLeft = (screenWidth - guiWidth) / 2;
            int guiTop = (screenHeight - guiHeight) / 2;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)guiLeft, (float)guiTop, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            Gui.func_73734_a((int)-2, (int)-12, (int)114, (int)34, (int)Integer.MIN_VALUE);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("\u00a78[\u00a7bNEF\u00a78] \u00a7aClick in Order!", 0.0f, -10.0f, 0xFFFFFF);
            for (int row = 1; row <= 2; ++row) {
                for (int col = 1; col <= 7; ++col) {
                    int slotIndex = row * 9 + col;
                    Slot slot = containerChest.func_75139_a(slotIndex);
                    if (slot == null || slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || slot.func_75211_c() == null || !(Block.func_149634_a((Item)slot.func_75211_c().func_77973_b()) instanceof BlockStainedGlassPane)) continue;
                    int overlayColor = 0;
                    if (slot.func_75211_c() != null && slot.func_75211_c().field_77994_a == effectiveRound + 1) {
                        overlayColor = ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor).getRGB();
                    } else if (slot.func_75211_c().field_77994_a == effectiveRound + 2) {
                        overlayColor = ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor).getRGB();
                    } else if (slot.func_75211_c().field_77994_a == effectiveRound + 3) {
                        Color baseColor = ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor);
                        Color altColor = new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), 150);
                        overlayColor = altColor.getRGB();
                    }
                    if (Config.feature.dungeons.dungeonsTerminalHideIncorrect && slot.func_75211_c().field_77994_a > effectiveRound + 2 && slot.func_75211_c().func_77952_i() == 14) {
                        slot.func_75211_c().func_77973_b().setDamage(slot.func_75211_c(), 15);
                        overlayColor = new Color(113, 113, 113).getRGB();
                    }
                    int x = (col - 1) * 16;
                    int y = (row - 1) * 16;
                    ClickInOrderSolver.drawRect(x, y, x + 16, y + 16, overlayColor);
                    if (slot.func_75211_c() == null || slot.func_75211_c().field_77994_a <= effectiveRound) continue;
                    String stackSizeText = String.valueOf(slot.func_75211_c().field_77994_a);
                    int textWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(stackSizeText);
                    int textX = x + 8 - textWidth / 2;
                    int textY = y + 8 - 4;
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(stackSizeText, (float)textX, (float)textY, 0xFFFFFF);
                }
            }
            GlStateManager.func_179121_F();
        } else {
            for (int row = 1; row <= 2; ++row) {
                for (int col = 1; col <= 7; ++col) {
                    int slotIndex = row * 9 + col;
                    Slot slot = containerChest.func_75139_a(slotIndex);
                    if (slot == null || slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || slot.func_75211_c() == null || !(Block.func_149634_a((Item)slot.func_75211_c().func_77973_b()) instanceof BlockStainedGlassPane)) continue;
                    int overlayColor = 0;
                    if (slot.func_75211_c().field_77994_a == effectiveRound + 1) {
                        overlayColor = ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor).getRGB();
                    } else if (slot.func_75211_c().field_77994_a == effectiveRound + 2) {
                        overlayColor = ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor).getRGB();
                    }
                    RenderUtils.drawOnSlot(container.field_75151_b.size(), slot.field_75223_e, slot.field_75221_f, overlayColor);
                }
            }
        }
    }

    @SubscribeEvent
    public void onGuiRender(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (!Config.feature.dungeons.dungeonsTerminalClickInOrderSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (event.gui instanceof GuiChest) {
            GuiChest chest = (GuiChest)event.gui;
            Container container = chest.field_147002_h;
            if (container instanceof ContainerChest) {
                String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
                if (!title.startsWith("Click in")) {
                    return;
                }
                ContainerChest containerChest = (ContainerChest)container;
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastUpdateTime > 3000L) {
                    Minecraft.func_71410_x().func_152344_a(() -> this.clickQueue.clear());
                    this.lastUpdateTime = currentTime;
                }
                int effectiveRound = this.processedRounds + this.clickQueue.size();
                for (int i = 1; i < 3; ++i) {
                    for (int j = 1; j < 8; ++j) {
                        Slot slot = containerChest.func_75139_a(i * 9 + j);
                        if (slot == null || slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || slot.func_75211_c() == null || !(Block.func_149634_a((Item)slot.func_75211_c().func_77973_b()) instanceof BlockStainedGlassPane)) continue;
                        if (slot.func_75211_c().field_77994_a == effectiveRound + 1) {
                            if (slot.func_75211_c().func_77952_i() == 14 || slot.func_75211_c().func_77952_i() == 15) {
                                slot.func_75211_c().func_77973_b().setDamage(slot.func_75211_c(), 0);
                            }
                            RenderUtils.drawOnSlot(container.field_75151_b.size(), slot.field_75223_e, slot.field_75221_f, ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor).getRGB());
                        } else if (slot.func_75211_c().field_77994_a == effectiveRound + 2) {
                            if (slot.func_75211_c().func_77952_i() == 14 || slot.func_75211_c().func_77952_i() == 15) {
                                slot.func_75211_c().func_77973_b().setDamage(slot.func_75211_c(), 0);
                            }
                            RenderUtils.drawOnSlot(container.field_75151_b.size(), slot.field_75223_e, slot.field_75221_f, ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor).getRGB());
                        } else if (slot.func_75211_c().field_77994_a == effectiveRound + 3) {
                            if (slot.func_75211_c().func_77952_i() == 14 || slot.func_75211_c().func_77952_i() == 15) {
                                slot.func_75211_c().func_77973_b().setDamage(slot.func_75211_c(), 0);
                            }
                            Color base = ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor);
                            RenderUtils.drawOnSlot(container.field_75151_b.size(), slot.field_75223_e, slot.field_75221_f, new Color(base.getRed(), base.getGreen(), base.getBlue(), 150).getRGB());
                        }
                        if (!Config.feature.dungeons.dungeonsTerminalHideIncorrect || slot.func_75211_c().field_77994_a <= effectiveRound + 1 || slot.func_75211_c().func_77952_i() != 14) continue;
                        slot.func_75211_c().func_77973_b().setDamage(slot.func_75211_c(), 15);
                        RenderUtils.drawOnSlot(container.field_75151_b.size(), slot.field_75223_e, slot.field_75221_f, new Color(113, 113, 113).getRGB());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!Config.feature.dungeons.dungeonsTerminalClickInOrderSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (!Config.feature.dungeons.dungeonsTerminalHideIncorrect) {
            return;
        }
        if (!Mouse.getEventButtonState() || Mouse.getEventButton() != 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiChest guiChest = (GuiChest)mc.field_71462_r;
        Container container = guiChest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
        if (!title.startsWith("Click in")) {
            return;
        }
        if (Config.feature.dungeons.dungeonsCustomGuiClickIn) {
            ScaledResolution sr = new ScaledResolution(mc);
            float scale = Config.feature.dungeons.dungeonsTerminalsScale;
            int guiWidth = (int)(112.0f * scale);
            int guiHeight = (int)(32.0f * scale);
            int screenWidth = sr.func_78326_a();
            int screenHeight = sr.func_78328_b();
            int guiLeft = (screenWidth - guiWidth) / 2;
            int guiTop = (screenHeight - guiHeight) / 2;
            int mouseX = Mouse.getEventX() * sr.func_78326_a() / mc.field_71443_c;
            int mouseY = sr.func_78328_b() - Mouse.getEventY() * sr.func_78328_b() / mc.field_71440_d - 1;
            if (mouseX < guiLeft || mouseX >= guiLeft + guiWidth || mouseY < guiTop || mouseY >= guiTop + guiHeight) {
                event.setCanceled(true);
                return;
            }
            float relX = (float)(mouseX - guiLeft) / scale;
            float relY = (float)(mouseY - guiTop) / scale;
            int col = (int)(relX / 16.0f);
            int row = (int)(relY / 16.0f);
            if (col < 0 || col >= 7 || row < 0 || row >= 2) {
                event.setCanceled(true);
                return;
            }
            int slotIndex = (row + 1) * 9 + (col + 1);
            Slot slot = container.func_75139_a(slotIndex);
            if (slot == null || slot.func_75211_c() == null) {
                event.setCanceled(true);
                return;
            }
            int expectedRound = this.processedRounds + this.clickQueue.size() + 1;
            if (slot.func_75211_c().field_77994_a == expectedRound) {
                mc.field_71442_b.func_78753_a(container.field_75152_c, slot.field_75222_d, 2, 0, (EntityPlayer)mc.field_71439_g);
                this.clickQueue.add(slot.field_75222_d);
                event.setCanceled(true);
            } else {
                event.setCanceled(true);
            }
        } else {
            Slot hoveredSlot = guiChest.getSlotUnderMouse();
            if (hoveredSlot != null && hoveredSlot.func_75211_c() != null) {
                int expectedRound = this.processedRounds + this.clickQueue.size() + 1;
                if (hoveredSlot.func_75211_c().field_77994_a == expectedRound) {
                    this.clickQueue.add(hoveredSlot.field_75222_d);
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    private void processQueue() {
        if (this.clickQueue.isEmpty()) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiChest guiChest = (GuiChest)mc.field_71462_r;
        Container container = guiChest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
        ContainerChest cc = (ContainerChest)container;
        int slotNumber = this.clickQueue.getFirst();
        Slot slot = cc.func_75139_a(slotNumber);
        if (slot == null || slot.func_75211_c() == null) {
            return;
        }
        if (!title.startsWith("Click in")) {
            return;
        }
        if (slot.func_75211_c().func_77952_i() == 5) {
            this.clickQueue.removeFirst();
            SoundUtils.playSound(mc.field_71439_g.func_180425_c(), "gui.button.press", 1.0f, 1.0f);
            ++this.processedRounds;
        } else {
            mc.field_71442_b.func_78753_a(cc.field_75152_c, slotNumber, 2, 0, (EntityPlayer)mc.field_71439_g);
        }
    }

    private static void drawRect(int left, int top, int right, int bottom, int color) {
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)color);
    }
}

