/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.terminals;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.ginafro.notenoughfakepixel.variables.F7ColorsDict;
import org.lwjgl.input.Mouse;

@RegisterEvents
public class ClickOnColorsSolver {
    private static final int SLOT_SIZE = 16;
    private static final int COLUMNS = 9;
    private static final int INNER_COLUMNS = 7;
    private static final int INNER_ROWS = 4;
    private final Set<Integer> clickedSlots = new HashSet<Integer>();
    private long lastRecheckTime = 0L;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDrawScreenPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (!Config.feature.dungeons.dungeonsTerminalSelectColorsSolver) {
            return;
        }
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        GuiChest chestGui = (GuiChest)event.gui;
        Container container = chestGui.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String displayName = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c().trim();
        if (Config.feature.dungeons.dungeonsCustomGuiColors && displayName.startsWith("Select all the")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDrawScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!Config.feature.dungeons.dungeonsTerminalSelectColorsSolver) {
            return;
        }
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        GuiChest chest = (GuiChest)event.gui;
        Container container = chest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
        if (!title.startsWith("Select all the")) {
            return;
        }
        String targetColor = title.split("the ")[1].split(" items")[0].toLowerCase();
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRecheckTime >= 1000L) {
            this.clickedSlots.clear();
            this.lastRecheckTime = currentTime;
        }
        if (Config.feature.dungeons.dungeonsCustomGuiColors) {
            ArrayList<Slot> correctSlots = new ArrayList<Slot>();
            for (Slot slot : container.field_75151_b) {
                ItemStack item;
                int slotId = container.field_75151_b.indexOf(slot);
                if (slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || slotId == 49) continue;
                int row = slotId / 9;
                int col = slotId % 9;
                if (row < 1 || row > 4 || col < 1 || col > 7 || (item = slot.func_75211_c()) == null || item.func_77948_v() || !this.isCorrectColor(item, targetColor)) continue;
                correctSlots.add(slot);
            }
            this.renderCustomGui(chest, correctSlots, targetColor);
        } else {
            this.handleDefaultGui(chest, targetColor);
        }
    }

    private void renderCustomGui(GuiChest chest, List<Slot> correctSlots, String targetColor) {
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        float scale = Config.feature.dungeons.dungeonsTerminalsScale;
        int guiWidth = (int)(112.0f * scale);
        int guiHeight = (int)(64.0f * scale);
        int guiLeft = (sr.func_78326_a() - guiWidth) / 2;
        int guiTop = (sr.func_78328_b() - guiHeight) / 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)guiLeft, (float)guiTop, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        Gui.func_73734_a((int)-2, (int)-12, (int)114, (int)66, (int)Integer.MIN_VALUE);
        Minecraft.func_71410_x().field_71466_p.func_175063_a("\u00a78[\u00a7bNEF\u00a78] \u00a7a" + this.capitalizeFirstLetter(targetColor), 0.0f, -10.0f, 0xFFFFFF);
        for (Slot slot : correctSlots) {
            if (this.clickedSlots.contains(slot.field_75222_d)) continue;
            int slotId = chest.field_147002_h.field_75151_b.indexOf(slot);
            int row = slotId / 9;
            int col = slotId % 9;
            int innerX = (col - 1) * 16;
            int innerY = (row - 1) * 16;
            ClickOnColorsSolver.drawRect(innerX + 1, innerY + 1, innerX + 16 - 1, innerY + 16 - 1, ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor).getRGB());
        }
        GlStateManager.func_179121_F();
    }

    private void handleDefaultGui(GuiChest chest, String targetColor) {
        ContainerChest container = (ContainerChest)chest.field_147002_h;
        for (Slot slot : container.field_75151_b) {
            ItemStack item;
            if (slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || (item = slot.func_75211_c()) == null) continue;
            int slotId = container.field_75151_b.indexOf(slot);
            if (slotId == 49) {
                if (!Config.feature.dungeons.dungeonsTerminalHideIncorrect) continue;
                item.func_150996_a(((Slot)container.field_75151_b.get(0)).func_75211_c().func_77973_b());
                item.func_77973_b().setDamage(item, 15);
                continue;
            }
            if (item.func_77948_v()) {
                if (!Config.feature.dungeons.dungeonsTerminalHideIncorrect) continue;
                item.func_150996_a(((Slot)container.field_75151_b.get(0)).func_75211_c().func_77973_b());
                item.func_77973_b().setDamage(item, 15);
                continue;
            }
            if (this.isCorrectColor(item, targetColor)) {
                RenderUtils.drawOnSlot(container.field_75151_b.size(), slot.field_75223_e, slot.field_75221_f, ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor).getRGB());
                continue;
            }
            if (!Config.feature.dungeons.dungeonsTerminalHideIncorrect) continue;
            item.func_150996_a(((Slot)container.field_75151_b.get(0)).func_75211_c().func_77973_b());
            item.func_77973_b().setDamage(item, 15);
        }
    }

    @SubscribeEvent
    public void onMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!Config.feature.dungeons.dungeonsPreventMissclicks) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (!Mouse.getEventButtonState()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiChest guiChest = (GuiChest)mc.field_71462_r;
        Container container = guiChest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
        if (!title.startsWith("Select all the")) {
            return;
        }
        if (Config.feature.dungeons.dungeonsCustomGuiColors) {
            this.handleCustomGuiClick(event, guiChest, title);
        } else {
            this.handleDefaultGuiClick(event, guiChest);
        }
    }

    private void handleCustomGuiClick(GuiScreenEvent.MouseInputEvent.Pre event, GuiChest guiChest, String title) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc);
        float scale = Config.feature.dungeons.dungeonsTerminalsScale;
        int mouseX = Mouse.getEventX() * sr.func_78326_a() / mc.field_71443_c;
        int mouseY = sr.func_78328_b() - Mouse.getEventY() * sr.func_78328_b() / mc.field_71440_d - 1;
        int guiWidth = (int)(112.0f * scale);
        int guiHeight = (int)(64.0f * scale);
        int guiLeft = (sr.func_78326_a() - guiWidth) / 2;
        int guiTop = (sr.func_78328_b() - guiHeight) / 2;
        if (mouseX < guiLeft || mouseX >= guiLeft + guiWidth || mouseY < guiTop || mouseY >= guiTop + guiHeight) {
            event.setCanceled(true);
            return;
        }
        float relX = (float)(mouseX - guiLeft) / scale;
        float relY = (float)(mouseY - guiTop) / scale;
        String targetColor = title.split("the ")[1].split(" items")[0].toLowerCase();
        ContainerChest container = (ContainerChest)guiChest.field_147002_h;
        for (Slot slot : container.field_75151_b) {
            ItemStack item;
            int slotId = container.field_75151_b.indexOf(slot);
            if (slot.field_75224_c == mc.field_71439_g.field_71071_by || slotId == 49) continue;
            int row = slotId / 9;
            int col = slotId % 9;
            if (row < 1 || row > 4 || col < 1 || col > 7 || (item = slot.func_75211_c()) == null || item.func_77948_v() || !this.isCorrectColor(item, targetColor)) continue;
            int innerX = (col - 1) * 16;
            int innerY = (row - 1) * 16;
            if (!(relX >= (float)innerX) || !(relX < (float)(innerX + 16)) || !(relY >= (float)innerY) || !(relY < (float)(innerY + 16))) continue;
            mc.field_71442_b.func_78753_a(container.field_75152_c, slot.field_75222_d, 2, 0, (EntityPlayer)mc.field_71439_g);
            this.playCompletionSound();
            this.clickedSlots.add(slot.field_75222_d);
            event.setCanceled(true);
            return;
        }
        event.setCanceled(true);
    }

    private void handleDefaultGuiClick(GuiScreenEvent.MouseInputEvent.Pre event, GuiChest guiChest) {
        Slot hoveredSlot = guiChest.getSlotUnderMouse();
        if (hoveredSlot != null && hoveredSlot.func_75211_c() != null) {
            ItemStack item = hoveredSlot.func_75211_c();
            if (Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockStainedGlassPane && item.func_77960_j() == 15) {
                event.setCanceled(true);
            } else {
                this.playCompletionSound();
            }
        }
    }

    private boolean isCorrectColor(ItemStack item, String targetColor) {
        if (item.func_77973_b() == Items.field_151100_aR) {
            return targetColor.equals(F7ColorsDict.getColorFromDye(item.func_77960_j()).toString());
        }
        if (Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockStainedGlassPane || Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockStainedGlass || Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockColored || Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockCarpet) {
            return targetColor.equals(F7ColorsDict.getColorFromMain(item.func_77960_j()).toString());
        }
        return false;
    }

    private String capitalizeFirstLetter(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private void playCompletionSound() {
        Minecraft mc = Minecraft.func_71410_x();
        SoundUtils.playSound(mc.field_71439_g.func_180425_c(), "gui.button.press", 1.0f, 1.0f);
    }

    private static void drawRect(int left, int top, int right, int bottom, int color) {
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)color);
    }
}

