/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.terminals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.lwjgl.input.Mouse;

@RegisterEvents
public class CorrectPanesSolver {
    private static final int SLOT_SIZE = 16;
    private static final int COLUMNS = 9;
    private static final int ROWS = 6;
    private static final int INNER_COLUMNS = 7;
    private static final int INNER_ROWS = 4;
    private final List<Slot> lastCorrectSlots = new ArrayList<Slot>();
    private final Map<Integer, SlotPosition> slotPositions = new HashMap<Integer, SlotPosition>();
    private final Set<Integer> clickedSlots = new HashSet<Integer>();
    private long lastRecheckTime = 0L;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDrawScreenPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (!Config.feature.dungeons.dungeonsTerminalCorrectPanesSolver) {
            return;
        }
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        GuiChest chestGui = (GuiChest)event.gui;
        Container container = chestGui.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String displayName = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c().trim();
        if (Config.feature.dungeons.dungeonsCustomGuiPanes && displayName.equals("Correct all the panes!")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDrawScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!Config.feature.dungeons.dungeonsTerminalCorrectPanesSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        GuiChest chest = (GuiChest)event.gui;
        Container container = chest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        ContainerChest containerChest = (ContainerChest)container;
        String name = containerChest.func_85151_d().func_145748_c_().func_150260_c();
        if (!name.equals("Correct all the panes!")) {
            return;
        }
        this.lastCorrectSlots.clear();
        this.slotPositions.clear();
        if (Config.feature.dungeons.dungeonsCustomGuiPanes) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastRecheckTime >= 1000L) {
                this.clickedSlots.clear();
                this.lastRecheckTime = currentTime;
            }
            for (Slot slot : containerChest.field_75151_b) {
                int meta;
                ItemStack item;
                int slotId = containerChest.field_75151_b.indexOf(slot);
                if (slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || slotId == 49) continue;
                int originalRow = slotId / 9;
                int originalColumn = slotId % 9;
                if (originalRow == 0 || originalRow == 5 || originalColumn == 0 || originalColumn == 8 || (item = slot.func_75211_c()) == null || !(Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockStainedGlassPane) || (meta = item.func_77960_j()) != 14 && meta != 0) continue;
                this.lastCorrectSlots.add(slot);
                int innerX = (originalColumn - 1) * 16;
                int innerY = (originalRow - 1) * 16;
                this.slotPositions.put(slotId, new SlotPosition(innerX, innerY, slotId));
            }
            ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
            GlStateManager.func_179094_E();
            float scale = Config.feature.dungeons.dungeonsTerminalsScale;
            int guiWidth = (int)(112.0f * scale);
            int guiHeight = (int)(64.0f * scale);
            int guiLeft = (sr.func_78326_a() - guiWidth) / 2;
            int guiTop = (sr.func_78328_b() - guiHeight) / 2;
            GlStateManager.func_179109_b((float)guiLeft, (float)guiTop, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            Gui.func_73734_a((int)-2, (int)-12, (int)114, (int)66, (int)Integer.MIN_VALUE);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("\u00a78[\u00a7bNEF\u00a78] \u00a7aRed & Green!", 0.0f, -10.0f, 0xFFFFFF);
            for (Slot slot : this.lastCorrectSlots) {
                SlotPosition pos;
                if (this.clickedSlots.contains(slot.field_75222_d) || (pos = this.slotPositions.get(containerChest.field_75151_b.indexOf(slot))) == null) continue;
                CorrectPanesSolver.drawRect(pos.x + 1, pos.y + 1, pos.x + 16 - 1, pos.y + 16 - 1, ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor).getRGB());
            }
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!Config.feature.dungeons.dungeonsPreventMissclicks) {
            return;
        }
        if (!Config.feature.dungeons.dungeonsTerminalCorrectPanesSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (!Mouse.getEventButtonState()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiChest guiChest = (GuiChest)mc.field_71462_r;
        Container container = guiChest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        ContainerChest containerChest = (ContainerChest)container;
        String title = containerChest.func_85151_d().func_145748_c_().func_150260_c();
        if (!title.equals("Correct all the panes!")) {
            return;
        }
        if (Config.feature.dungeons.dungeonsCustomGuiPanes) {
            ScaledResolution sr = new ScaledResolution(mc);
            float scale = Config.feature.dungeons.dungeonsTerminalsScale;
            int mouseX = Mouse.getEventX() * sr.func_78326_a() / mc.field_71443_c;
            int mouseY = sr.func_78328_b() - Mouse.getEventY() * sr.func_78328_b() / mc.field_71440_d - 1;
            int guiWidth = (int)(112.0f * scale);
            int guiHeight = (int)(64.0f * scale);
            int guiLeft = (sr.func_78326_a() - guiWidth) / 2;
            int guiTop = (sr.func_78328_b() - guiHeight) / 2;
            if (mouseX < guiLeft || mouseX >= guiLeft + guiWidth || mouseY < guiTop || mouseY >= guiTop + guiHeight) {
                event.setCanceled(true);
                return;
            }
            float relX = (float)(mouseX - guiLeft) / scale;
            float relY = (float)(mouseY - guiTop) / scale;
            boolean validClick = false;
            for (Slot slot : this.lastCorrectSlots) {
                SlotPosition pos = this.slotPositions.get(containerChest.field_75151_b.indexOf(slot));
                if (pos == null || !(relX >= (float)pos.x) || !(relX <= (float)(pos.x + 16)) || !(relY >= (float)pos.y) || !(relY <= (float)(pos.y + 16))) continue;
                mc.field_71442_b.func_78753_a(containerChest.field_75152_c, slot.field_75222_d, 2, 0, (EntityPlayer)mc.field_71439_g);
                this.playCompletionSound();
                this.clickedSlots.add(slot.field_75222_d);
                validClick = true;
                break;
            }
            event.setCanceled(true);
        }
    }

    private void playCompletionSound() {
        Minecraft mc = Minecraft.func_71410_x();
        SoundUtils.playSound(mc.field_71439_g.func_180425_c(), "gui.button.press", 1.0f, 1.0f);
    }

    private static void drawRect(int left, int top, int right, int bottom, int color) {
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)color);
    }

    private static class SlotPosition {
        final int x;
        final int y;
        final int slotId;

        SlotPosition(int x, int y, int slotId) {
            this.x = x;
            this.y = y;
            this.slotId = slotId;
        }
    }
}

