/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.terminals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.lwjgl.input.Mouse;

@RegisterEvents
public class MazeSolver {
    private static final int SLOT_SIZE = 16;
    private static final int COLUMNS = 9;
    private static final int ROWS = 6;
    private static final int[] ADJACENT_OFFSETS = new int[]{1, -1, 9, -9};
    private final int[] adjacentPositions = new int[]{1, -1, 9, -9};
    private final List<Slot> targetSlots = new ArrayList<Slot>();
    private final List<Slot> alternativeSlots = new ArrayList<Slot>();
    private final Map<Integer, SlotPosition> slotPositions = new HashMap<Integer, SlotPosition>();
    private final long lastScanTime = 0L;
    private final ContainerChest lastContainer = null;
    private final LinkedList<Integer> clickQueue = new LinkedList();
    private long lastClickTime = 0L;

    @SubscribeEvent
    public void onOpen(GuiOpenEvent e) {
        if (!(e.gui instanceof GuiChest)) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        GuiChest chestGui = (GuiChest)e.gui;
        Container container = chestGui.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String displayName = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c().trim();
        if (Config.feature.dungeons.dungeonsCustomGuiMaze && displayName.contains("Complete the maze!")) {
            this.targetSlots.clear();
            this.alternativeSlots.clear();
            this.slotPositions.clear();
            this.clickQueue.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDrawScreenPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        GuiChest chestGui = (GuiChest)event.gui;
        Container container = chestGui.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String displayName = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c().trim();
        if (Config.feature.dungeons.dungeonsCustomGuiMaze && displayName.contains("Complete the maze!")) {
            event.setCanceled(true);
        }
    }

    private void updateSlots(ContainerChest containerChest) {
        this.targetSlots.clear();
        this.alternativeSlots.clear();
        this.slotPositions.clear();
        for (Slot slot : containerChest.field_75151_b) {
            Block block;
            ItemStack item;
            if (slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || (item = slot.func_75211_c()) == null || !((block = Block.func_149634_a((Item)item.func_77973_b())) instanceof BlockStainedGlassPane)) continue;
            int meta = item.func_77960_j();
            if (meta == 0) {
                this.slotPositions.put(slot.field_75222_d, new SlotPosition(slot.field_75223_e, slot.field_75221_f, false));
                continue;
            }
            if (meta != 5) continue;
            this.targetSlots.addAll(this.findAdjacentWhiteSlots(containerChest.field_75151_b, slot));
        }
        for (Slot targetSlot : this.targetSlots) {
            List<Slot> adjacent = this.findAdjacentWhiteSlots(containerChest.field_75151_b, targetSlot);
            for (Slot adj : adjacent) {
                if (this.targetSlots.contains(adj) || this.alternativeSlots.contains(adj)) continue;
                this.alternativeSlots.add(adj);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDrawScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        int slotNumber;
        Slot slot;
        if (!Config.feature.dungeons.dungeonsTerminalMazeSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        GuiChest chest = (GuiChest)event.gui;
        Container container = chest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        ContainerChest containerChest = (ContainerChest)container;
        String name = containerChest.func_85151_d().func_145748_c_().func_150260_c();
        if (!name.contains("Complete the maze!")) {
            return;
        }
        this.updateSlots(containerChest);
        if (Config.feature.dungeons.dungeonsCustomGuiMaze) {
            this.renderCustomGui(containerChest);
        } else {
            this.renderVanillaOverlay(containerChest);
        }
        long currentTime = System.currentTimeMillis();
        if (!this.clickQueue.isEmpty() && currentTime - this.lastClickTime > 20L && (slot = containerChest.func_75139_a(slotNumber = this.clickQueue.poll().intValue())) != null) {
            Minecraft.func_71410_x().field_71442_b.func_78753_a(containerChest.field_75152_c, slotNumber, 2, 0, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            this.lastClickTime = currentTime;
            this.playCompletionSound();
        }
    }

    private void renderCustomGui(ContainerChest container) {
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        GlStateManager.func_179094_E();
        float scale = Config.feature.dungeons.dungeonsTerminalsScale;
        int guiWidth = (int)(144.0f * scale);
        int guiHeight = (int)(96.0f * scale);
        int guiLeft = (sr.func_78326_a() - guiWidth) / 2;
        int guiTop = (sr.func_78328_b() - guiHeight) / 2;
        GlStateManager.func_179109_b((float)guiLeft, (float)guiTop, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        Gui.func_73734_a((int)-2, (int)-12, (int)146, (int)98, (int)Integer.MIN_VALUE);
        Minecraft.func_71410_x().field_71466_p.func_175063_a("\u00a78[\u00a7bNEF\u00a78] \u00a7aMaze!", 0.0f, -10.0f, 0xFFFFFF);
        for (Map.Entry<Integer, SlotPosition> entry : this.slotPositions.entrySet()) {
            int id = entry.getKey();
            Gui.func_73734_a((int)(id % 9 * 16), (int)(id / 9 * 16), (int)(id % 9 * 16 + 16), (int)(id / 9 * 16 + 16), (int)-1711276033);
        }
        this.targetSlots.forEach(slot -> {
            int x = slot.field_75222_d % 9 * 16;
            int y = slot.field_75222_d / 9 * 16;
            Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor).getRGB());
        });
        this.alternativeSlots.forEach(slot -> {
            int x = slot.field_75222_d % 9 * 16;
            int y = slot.field_75222_d / 9 * 16;
            Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor).getRGB());
        });
        GlStateManager.func_179121_F();
    }

    private void renderVanillaOverlay(ContainerChest container) {
        for (Slot slot : container.field_75151_b) {
            ItemStack item;
            if (slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || (item = slot.func_75211_c()) == null) continue;
            if (Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockStainedGlassPane && item.func_77960_j() == 0) {
                RenderUtils.drawOnSlot(container.field_75151_b.size(), slot.field_75223_e, slot.field_75221_f, -1711276033);
            }
            if (this.targetSlots.contains(slot)) {
                RenderUtils.drawOnSlot(container.field_75151_b.size(), slot.field_75223_e, slot.field_75221_f, ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor).getRGB());
                continue;
            }
            if (!this.alternativeSlots.contains(slot)) continue;
            RenderUtils.drawOnSlot(container.field_75151_b.size(), slot.field_75223_e, slot.field_75221_f, ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor).getRGB());
        }
    }

    @SubscribeEvent
    public void onMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!Config.feature.dungeons.dungeonsTerminalMazeSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        int button = Mouse.getEventButton();
        if (button != 0 || !Mouse.getEventButtonState()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiChest guiChest = (GuiChest)mc.field_71462_r;
        ContainerChest container = (ContainerChest)guiChest.field_147002_h;
        String title = container.func_85151_d().func_145748_c_().func_150260_c();
        if (!title.contains("Complete the maze!")) {
            return;
        }
        if (Config.feature.dungeons.dungeonsCustomGuiMaze) {
            this.handleCustomGuiClick(container, event);
        } else {
            this.handleVanillaGuiClick(container);
        }
    }

    private void handleCustomGuiClick(ContainerChest container, GuiScreenEvent.MouseInputEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc);
        float scale = Config.feature.dungeons.dungeonsTerminalsScale;
        int mouseX = Mouse.getEventX() * sr.func_78326_a() / mc.field_71443_c;
        int mouseY = sr.func_78328_b() - Mouse.getEventY() * sr.func_78328_b() / mc.field_71440_d - 1;
        int guiWidth = (int)(144.0f * scale);
        int guiHeight = (int)(96.0f * scale);
        int guiLeft = (sr.func_78326_a() - guiWidth) / 2;
        int guiTop = (sr.func_78328_b() - guiHeight) / 2;
        if (mouseX >= guiLeft && mouseX < guiLeft + guiWidth && mouseY >= guiTop && mouseY < guiTop + guiHeight) {
            int slotId = this.calculateClickedSlot(mouseX, mouseY, guiLeft, guiTop, scale);
            if (slotId >= 0 && slotId < container.field_75151_b.size()) {
                this.clickQueue.add(slotId);
                mc.field_71442_b.func_78753_a(container.field_75152_c, slotId, 2, 0, (EntityPlayer)mc.field_71439_g);
                this.playCompletionSound();
                this.updateSlots(container);
            }
            event.setCanceled(true);
        }
    }

    private void handleVanillaGuiClick(ContainerChest container) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiChest guiChest = (GuiChest)mc.field_71462_r;
        Slot hoveredSlot = guiChest.getSlotUnderMouse();
        if (hoveredSlot != null) {
            this.clickQueue.add(hoveredSlot.field_75222_d);
            mc.field_71442_b.func_78753_a(container.field_75152_c, hoveredSlot.field_75222_d, 2, 0, (EntityPlayer)mc.field_71439_g);
            this.playCompletionSound();
            this.updateSlots(container);
        }
    }

    private int calculateClickedSlot(int mouseX, int mouseY, int guiLeft, int guiTop, float scale) {
        float relX = (float)(mouseX - guiLeft) / scale;
        float relY = (float)(mouseY - guiTop) / scale;
        int slotCol = (int)(relX / 16.0f);
        int slotRow = (int)(relY / 16.0f);
        return slotRow * 9 + slotCol;
    }

    private void playCompletionSound() {
        Minecraft mc = Minecraft.func_71410_x();
        SoundUtils.playSound(mc.field_71439_g.func_180425_c(), "gui.button.press", 1.0f, 1.0f);
    }

    private List<Slot> findAdjacentWhiteSlots(List<Slot> slots, Slot origin) {
        ArrayList<Slot> adjacentWhites = new ArrayList<Slot>();
        for (int offset : ADJACENT_OFFSETS) {
            Slot target;
            ItemStack item;
            int targetIndex = origin.field_75222_d + offset;
            if (targetIndex < 0 || targetIndex >= slots.size() || (item = (target = slots.get(targetIndex)).func_75211_c()) == null || !(Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockStainedGlassPane) || item.func_77960_j() != 0) continue;
            adjacentWhites.add(target);
        }
        return adjacentWhites;
    }

    private static class SlotPosition {
        final int x;
        final int y;
        final boolean isTarget;

        SlotPosition(int x, int y, boolean isTarget) {
            this.x = x;
            this.y = y;
            this.isTarget = isTarget;
        }
    }
}

