/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.terminals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.lwjgl.input.Mouse;

@RegisterEvents
public class StartingWithSolver {
    private static final int SLOT_SIZE = 16;
    private static final int COLUMNS = 9;
    private static final int ROWS = 6;
    private final List<Slot> lastCorrectSlots = new ArrayList<Slot>();
    private final Map<Integer, SlotPosition> slotPositions = new HashMap<Integer, SlotPosition>();
    private final Set<Integer> clickedSlots = new HashSet<Integer>();
    private long lastRecheckTime = 0L;
    private char lastLetter = (char)32;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDrawScreenPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (!Config.feature.dungeons.dungeonsTerminalStartsWithSolver) {
            return;
        }
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        GuiChest chestGui = (GuiChest)event.gui;
        Container container = chestGui.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        String displayName = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c().trim();
        if (Config.feature.dungeons.dungeonsCustomGuiStartsWith && displayName.contains("What starts with")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDrawScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!Config.feature.dungeons.dungeonsTerminalStartsWithSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        GuiChest chest = (GuiChest)event.gui;
        Container container = chest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        ContainerChest containerChest = (ContainerChest)container;
        String name = containerChest.func_85151_d().func_145748_c_().func_150260_c();
        if (!name.contains("What starts with")) {
            return;
        }
        this.lastLetter = name.charAt(name.length() - 2);
        this.lastCorrectSlots.clear();
        this.slotPositions.clear();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        int screenWidth = sr.func_78326_a();
        int screenHeight = sr.func_78328_b();
        if (Config.feature.dungeons.dungeonsCustomGuiStartsWith) {
            int INNER_COLUMNS = 7;
            int INNER_ROWS = 4;
            for (Slot slot : containerChest.field_75151_b) {
                ItemStack item;
                int slotId = containerChest.field_75151_b.indexOf(slot);
                if (slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || slotId == 49) continue;
                int row = slotId / 9;
                int col = slotId % 9;
                if (row < 1 || row > 4 || col < 1 || col > 7 || (item = slot.func_75211_c()) == null || item.func_77948_v() || StringUtils.func_76338_a((String)item.func_82833_r()).charAt(0) != this.lastLetter) continue;
                this.lastCorrectSlots.add(slot);
                this.slotPositions.put(slotId, new SlotPosition(slot.field_75223_e, slot.field_75221_f, slotId));
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastRecheckTime >= 1000L) {
                this.clickedSlots.clear();
                this.lastRecheckTime = currentTime;
            }
            GlStateManager.func_179094_E();
            float scale = Config.feature.dungeons.dungeonsTerminalsScale;
            int guiWidth = (int)(112.0f * scale);
            int guiHeight = (int)(64.0f * scale);
            int guiLeft = (screenWidth - guiWidth) / 2;
            int guiTop = (screenHeight - guiHeight) / 2;
            GlStateManager.func_179109_b((float)guiLeft, (float)guiTop, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            Gui.func_73734_a((int)-2, (int)-12, (int)114, (int)66, (int)Integer.MIN_VALUE);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("\u00a78[\u00a7bNEF\u00a78] \u00a7aStarts With '" + this.lastLetter + "'", 0.0f, -10.0f, 0xFFFFFF);
            for (Slot slot : this.lastCorrectSlots) {
                if (this.clickedSlots.contains(slot.field_75222_d)) continue;
                int slotIndex = containerChest.field_75151_b.indexOf(slot);
                int row = slotIndex / 9;
                int col = slotIndex % 9;
                int innerCol = col - 1;
                int innerRow = row - 1;
                int x = innerCol * 16;
                int y = innerRow * 16;
                StartingWithSolver.drawRect(x + 1, y + 1, x + 16 - 1, y + 16 - 1, ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor).getRGB());
            }
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onGuiRender(GuiScreenEvent.BackgroundDrawnEvent e) {
        if (!Config.feature.dungeons.dungeonsTerminalStartsWithSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (!(e.gui instanceof GuiChest)) {
            return;
        }
        GuiChest chest = (GuiChest)e.gui;
        Container container = chest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        ContainerChest containerChest = (ContainerChest)container;
        String name = containerChest.func_85151_d().func_145748_c_().func_150260_c();
        if (name.contains("What starts with")) {
            char letter = name.charAt(name.length() - 2);
            for (Slot slot : containerChest.field_75151_b) {
                ItemStack item;
                int slotId;
                if (slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || (slotId = containerChest.field_75151_b.indexOf(slot)) == 49 || (item = slot.func_75211_c()) == null) continue;
                if (containerChest.field_75151_b.indexOf(slot) == 49) {
                    if (!Config.feature.dungeons.dungeonsTerminalHideIncorrect) continue;
                    item.func_150996_a(((Slot)containerChest.field_75151_b.get(0)).func_75211_c().func_77973_b());
                    item.func_77973_b().setDamage(item, 15);
                    continue;
                }
                if (item.func_77948_v()) {
                    if (!Config.feature.dungeons.dungeonsTerminalHideIncorrect) continue;
                    slot.func_75211_c().func_150996_a(((Slot)containerChest.field_75151_b.get(0)).func_75211_c().func_77973_b());
                    slot.func_75211_c().func_77973_b().setDamage(slot.func_75211_c(), 15);
                    continue;
                }
                if (StringUtils.func_76338_a((String)item.func_82833_r()).charAt(0) == letter) {
                    RenderUtils.drawOnSlot(chest.field_147002_h.field_75151_b.size(), slot.field_75223_e, slot.field_75221_f, ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor).getRGB());
                    continue;
                }
                if (!Config.feature.dungeons.dungeonsTerminalHideIncorrect) continue;
                if (Block.func_149634_a((Item)slot.func_75211_c().func_77973_b()) instanceof BlockStainedGlassPane) {
                    if (slot.func_75211_c().func_77960_j() == 15) continue;
                    slot.func_75211_c().func_77973_b().setDamage(slot.func_75211_c(), 15);
                    continue;
                }
                slot.func_75211_c().func_150996_a(((Slot)containerChest.field_75151_b.get(0)).func_75211_c().func_77973_b());
                slot.func_75211_c().func_77973_b().setDamage(slot.func_75211_c(), 15);
            }
        }
    }

    @SubscribeEvent
    public void onMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (!Config.feature.dungeons.dungeonsPreventMissclicks) {
            return;
        }
        if (!Config.feature.dungeons.dungeonsTerminalStartsWithSolver) {
            return;
        }
        if (!Mouse.getEventButtonState()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiChest guiChest = (GuiChest)mc.field_71462_r;
        Container container = guiChest.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        ContainerChest containerChest = (ContainerChest)container;
        String title = containerChest.func_85151_d().func_145748_c_().func_150260_c();
        if (!title.contains("What starts with")) {
            return;
        }
        if (Config.feature.dungeons.dungeonsCustomGuiStartsWith) {
            ScaledResolution sr = new ScaledResolution(mc);
            float scale = Config.feature.dungeons.dungeonsTerminalsScale;
            int mouseX = Mouse.getEventX() * sr.func_78326_a() / mc.field_71443_c;
            int mouseY = sr.func_78328_b() - Mouse.getEventY() * sr.func_78328_b() / mc.field_71440_d - 1;
            int guiWidth = (int)(144.0f * scale);
            int guiHeight = (int)(96.0f * scale);
            int guiLeft = (sr.func_78326_a() - guiWidth) / 2;
            int guiTop = (sr.func_78328_b() - guiHeight) / 2;
            if (mouseX >= guiLeft && mouseX < guiLeft + guiWidth && mouseY >= guiTop && mouseY < guiTop + guiHeight) {
                event.setCanceled(true);
                float relX = (float)(mouseX - guiLeft) / scale;
                float relY = (float)(mouseY - guiTop) / scale;
                for (Slot slot : this.lastCorrectSlots) {
                    int slotIndex = containerChest.field_75151_b.indexOf(slot);
                    if (slotIndex == -1) continue;
                    int x = slotIndex % 9 * 16;
                    int y = slotIndex / 9 * 16;
                    if (!(relX >= (float)x) || !(relX <= (float)(x + 16)) || !(relY >= (float)y) || !(relY <= (float)(y + 16))) continue;
                    mc.field_71442_b.func_78753_a(containerChest.field_75152_c, slot.field_75222_d, 2, 0, (EntityPlayer)mc.field_71439_g);
                    this.playCompletionSound();
                    this.clickedSlots.add(slot.field_75222_d);
                    break;
                }
            }
        } else {
            Slot hoveredSlot = guiChest.getSlotUnderMouse();
            if (hoveredSlot != null && hoveredSlot.func_75211_c() != null) {
                boolean isWrongLetter;
                ItemStack item = hoveredSlot.func_75211_c();
                boolean isBadItem = Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockStainedGlassPane && item.func_77960_j() == 15;
                boolean bl = isWrongLetter = StringUtils.func_76338_a((String)item.func_82833_r()).charAt(0) != this.lastLetter;
                if (isBadItem || isWrongLetter) {
                    event.setCanceled(true);
                } else {
                    this.playCompletionSound();
                }
            }
        }
    }

    private void playCompletionSound() {
        Minecraft mc = Minecraft.func_71410_x();
        SoundUtils.playSound(mc.field_71439_g.func_180425_c(), "gui.button.press", 1.0f, 1.0f);
    }

    private static void drawRect(int left, int top, int right, int bottom, int color) {
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)color);
    }

    private static class SlotPosition {
        final int x;
        final int y;
        final int slotId;

        SlotPosition(int x, int y, int slotId) {
            this.x = x;
            this.y = y;
            this.slotId = slotId;
        }
    }
}

