/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.terminals;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.RandomUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;

public class TerminalSimulator
extends GuiScreen {
    private static final String[] PUZZLE_TYPES = new String[]{"Starts With", "Click in Order", "Panes", "Colors"};
    private String currentMode = "selector";
    private String currentPuzzle = "";
    private long startTime = 0L;
    private final Random random = RandomUtils.getInstance();
    private static final int SLOT_SIZE = 16;
    private static final int INNER_COLUMNS = 7;
    private static final int INNER_ROWS = 4;
    private static final int PANES_COLUMNS = 5;
    private static final int PANES_ROWS = 3;
    private static final int CLICK_IN_ORDER_ROWS = 2;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 10;
    private static final int PADDING = 5;
    private static final int TITLE_HEIGHT = 10;
    private final float scale;
    private int guiLeft;
    private int guiTop;
    private int guiWidth;
    private int guiHeight;
    private boolean initialRenderDone;
    private int puzzleRows;
    private final Set<Integer> correctSlots;
    private final List<Integer> clickOrder;
    private int currentClickIndex;
    private char lastLetter;
    private final Set<Integer> clickedSlots;
    private String targetColor;

    public TerminalSimulator() {
        this.scale = Config.feature.dungeons.dungeonsTerminalsScale;
        this.initialRenderDone = false;
        this.correctSlots = new HashSet<Integer>();
        this.clickOrder = new ArrayList<Integer>();
        this.currentClickIndex = 0;
        this.lastLetter = (char)32;
        this.clickedSlots = new HashSet<Integer>();
        this.targetColor = "";
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        this.field_146294_l = sr.func_78326_a();
        this.field_146295_m = sr.func_78328_b();
        this.openSelector();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!this.initialRenderDone) {
            this.initialRenderDone = true;
        }
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        this.guiLeft = (sr.func_78326_a() - this.guiWidth) / 2;
        this.guiTop = (sr.func_78328_b() - this.guiHeight) / 2;
        if (this.currentMode.equals("selector")) {
            this.renderSelectorGui();
        } else if (this.currentMode.equals("puzzle")) {
            this.renderPuzzleGui();
        }
    }

    private void renderSelectorGui() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
        int totalButtonWidth = 170;
        int totalButtonHeight = 50;
        int backgroundWidth = totalButtonWidth + 10;
        int backgroundHeight = totalButtonHeight + 10 + 10;
        Gui.func_73734_a((int)0, (int)0, (int)backgroundWidth, (int)backgroundHeight, (int)Integer.MIN_VALUE);
        this.field_146289_q.func_175063_a("\u00a78[\u00a7bNEF\u00a78] \u00a7aSelect a Puzzle", 5.0f, 5.0f, 0xFFFFFF);
        for (int i = 0; i < PUZZLE_TYPES.length; ++i) {
            int row = i / 2;
            int col = i % 2;
            int x = 5 + col * 90;
            int y = 15 + row * 30;
            Gui.func_73734_a((int)x, (int)y, (int)(x + 80), (int)(y + 20), (int)-11184811);
            String text = PUZZLE_TYPES[i];
            int textWidth = this.field_146289_q.func_78256_a(text);
            int textX = x + (80 - textWidth) / 2;
            int textY = y + 6;
            this.field_146289_q.func_175063_a(text, (float)textX, (float)textY, 0xFFFFFF);
        }
        GlStateManager.func_179121_F();
    }

    private void renderPuzzleGui() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
        int gridWidth = this.currentPuzzle.equals("Panes") ? 80 : 112;
        int gridHeight = this.currentPuzzle.equals("Panes") ? 48 : this.puzzleRows * 16;
        int backgroundWidth = gridWidth + 20;
        int backgroundHeight = gridHeight + 10 + 10;
        Gui.func_73734_a((int)0, (int)0, (int)backgroundWidth, (int)backgroundHeight, (int)Integer.MIN_VALUE);
        switch (this.currentPuzzle) {
            case "Starts With": {
                this.field_146289_q.func_175063_a("\u00a78[\u00a7bNEF\u00a78] \u00a7aStarts With '" + this.lastLetter + "'", 5.0f, 5.0f, 0xFFFFFF);
                this.renderGrid(10, 15, 7, this.puzzleRows, this.correctSlots);
                break;
            }
            case "Click in Order": {
                this.field_146289_q.func_175063_a("\u00a78[\u00a7bNEF\u00a78] \u00a7aClick in Order!", 5.0f, 5.0f, 0xFFFFFF);
                this.renderClickInOrderGrid(10, 15, 7, this.puzzleRows);
                break;
            }
            case "Panes": {
                this.field_146289_q.func_175063_a("\u00a78[\u00a7bNEF\u00a78] \u00a7aRed & Green!", 5.0f, 5.0f, 0xFFFFFF);
                this.renderGrid(10, 15, 5, 3, this.correctSlots);
                break;
            }
            case "Colors": {
                this.field_146289_q.func_175063_a("\u00a78[\u00a7bNEF\u00a78] \u00a7a" + this.targetColor, 5.0f, 5.0f, 0xFFFFFF);
                this.renderGrid(10, 15, 7, this.puzzleRows, this.correctSlots);
            }
        }
        GlStateManager.func_179121_F();
    }

    private void renderGrid(int xOffset, int yOffset, int columns, int rows, Set<Integer> highlightSlots) {
        for (int i = 0; i < columns * rows; ++i) {
            int row = i / columns;
            int col = i % columns;
            int x = xOffset + col * 16;
            int y = yOffset + row * 16;
            Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-11184811);
            if (!highlightSlots.contains(i) || this.clickedSlots.contains(i)) continue;
            int color = ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor).getRGB();
            Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 16 - 1), (int)(y + 16 - 1), (int)color);
        }
    }

    private void renderClickInOrderGrid(int xOffset, int yOffset, int columns, int rows) {
        int i;
        for (i = 0; i < columns * rows; ++i) {
            int row = i / columns;
            int col = i % columns;
            int x = xOffset + col * 16;
            int y = yOffset + row * 16;
            Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-11184811);
        }
        for (i = 0; i < this.clickOrder.size(); ++i) {
            int color;
            if (i < this.currentClickIndex) continue;
            int slot = this.clickOrder.get(i);
            int row = slot / columns;
            int col = slot % columns;
            int x = xOffset + col * 16;
            int y = yOffset + row * 16;
            if (i == this.currentClickIndex) {
                color = ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor).getRGB();
            } else if (i == this.currentClickIndex + 1) {
                color = ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor).getRGB();
            } else if (i == this.currentClickIndex + 2) {
                Color baseColor = ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor);
                color = new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), 150).getRGB();
            } else {
                color = -7829368;
            }
            Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 16 - 1), (int)(y + 16 - 1), (int)color);
            String num = String.valueOf(i + 1);
            int textWidth = this.field_146289_q.func_78256_a(num);
            this.field_146289_q.func_175063_a(num, (float)(x + (16 - textWidth) / 2), (float)(y + 4), 0xFFFFFF);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.currentMode.equals("selector")) {
            this.handleSelectorClick(mouseX, mouseY);
        } else if (this.currentMode.equals("puzzle")) {
            this.handlePuzzleClick(mouseX, mouseY);
        }
    }

    private void handleSelectorClick(int mouseX, int mouseY) {
        float relX = (float)(mouseX - this.guiLeft) / this.scale;
        float relY = (float)(mouseY - this.guiTop) / this.scale;
        for (int i = 0; i < PUZZLE_TYPES.length; ++i) {
            int row = i / 2;
            int col = i % 2;
            int x = 5 + col * 90;
            int y = 15 + row * 30;
            if (!(relX >= (float)x) || !(relX <= (float)(x + 80)) || !(relY >= (float)y) || !(relY <= (float)(y + 20))) continue;
            this.currentPuzzle = PUZZLE_TYPES[i];
            this.currentMode = "puzzle";
            this.startTime = System.currentTimeMillis();
            this.initializePuzzle();
            SoundUtils.playSound(Minecraft.func_71410_x().field_71439_g.func_180425_c(), "gui.button.press", 1.0f, 1.0f);
            return;
        }
    }

    private void handlePuzzleClick(int mouseX, int mouseY) {
        float relX = (float)(mouseX - this.guiLeft) / this.scale;
        float relY = (float)(mouseY - this.guiTop) / this.scale;
        int columns = this.currentPuzzle.equals("Panes") ? 5 : 7;
        int col = (int)((relX - 10.0f) / 16.0f);
        int row = (int)((relY - 5.0f - 10.0f) / 16.0f);
        if (col < 0 || col >= columns || row < 0 || row >= this.puzzleRows) {
            return;
        }
        int slotIndex = row * columns + col;
        boolean validClick = false;
        switch (this.currentPuzzle) {
            case "Starts With": {
                if (!this.correctSlots.contains(slotIndex) || this.clickedSlots.contains(slotIndex)) break;
                this.clickedSlots.add(slotIndex);
                validClick = true;
                break;
            }
            case "Click in Order": {
                if (this.currentClickIndex >= this.clickOrder.size() || this.clickOrder.get(this.currentClickIndex) != slotIndex) break;
                ++this.currentClickIndex;
                validClick = true;
                break;
            }
            case "Panes": 
            case "Colors": {
                if (!this.correctSlots.contains(slotIndex) || this.clickedSlots.contains(slotIndex)) break;
                this.clickedSlots.add(slotIndex);
                validClick = true;
            }
        }
        if (validClick) {
            SoundUtils.playSound(Minecraft.func_71410_x().field_71439_g.func_180425_c(), "gui.button.press", 1.0f, 1.0f);
            if (this.checkPuzzleCompletion()) {
                long timeTaken = System.currentTimeMillis() - this.startTime;
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a78[\u00a7bNEF\u00a78] \u00a77" + this.currentPuzzle + " solved in " + String.format("\u00a7f%.2f", (double)timeTaken / 1000.0) + " \u00a77seconds!"));
                this.openSelector();
            }
        }
    }

    private void openSelector() {
        this.currentMode = "selector";
        this.correctSlots.clear();
        this.clickOrder.clear();
        this.clickedSlots.clear();
        this.currentClickIndex = 0;
        int totalButtonWidth = 170;
        int totalButtonHeight = 50;
        int backgroundWidth = totalButtonWidth + 10;
        int backgroundHeight = totalButtonHeight + 10 + 10;
        this.guiWidth = (int)((float)backgroundWidth * this.scale);
        this.guiHeight = (int)((float)backgroundHeight * this.scale);
    }

    private void initializePuzzle() {
        int gridHeight;
        int gridWidth;
        this.correctSlots.clear();
        this.clickOrder.clear();
        this.clickedSlots.clear();
        this.currentClickIndex = 0;
        if (this.currentPuzzle.equals("Panes")) {
            gridWidth = 80;
            gridHeight = 48;
            this.puzzleRows = 3;
        } else {
            gridWidth = 112;
            gridHeight = this.currentPuzzle.equals("Click in Order") ? 32 : 64;
            this.puzzleRows = this.currentPuzzle.equals("Click in Order") ? 2 : 4;
        }
        int backgroundWidth = gridWidth + 10;
        int backgroundHeight = gridHeight + 10 + 10;
        this.guiWidth = (int)((float)backgroundWidth * this.scale);
        this.guiHeight = (int)((float)backgroundHeight * this.scale);
        switch (this.currentPuzzle) {
            case "Starts With": {
                this.lastLetter = (char)(65 + this.random.nextInt(26));
                for (int i = 0; i < 7 * this.puzzleRows; ++i) {
                    if (this.random.nextInt(5) != 0) continue;
                    this.correctSlots.add(i);
                }
                break;
            }
            case "Click in Order": {
                ArrayList<Integer> allSlots = new ArrayList<Integer>();
                for (int i = 0; i < 7 * this.puzzleRows; ++i) {
                    allSlots.add(i);
                }
                Collections.shuffle(allSlots);
                this.clickOrder.addAll(allSlots);
                break;
            }
            case "Panes": {
                for (int i = 0; i < 15; ++i) {
                    if (this.random.nextInt(3) != 0) continue;
                    this.correctSlots.add(i);
                }
                break;
            }
            case "Colors": {
                this.targetColor = this.getColorName(this.random.nextInt(16));
                for (int i = 0; i < 7 * this.puzzleRows; ++i) {
                    if (this.random.nextInt(5) != 0) continue;
                    this.correctSlots.add(i);
                }
                break;
            }
        }
    }

    private boolean checkPuzzleCompletion() {
        switch (this.currentPuzzle) {
            case "Starts With": 
            case "Panes": 
            case "Colors": {
                return this.clickedSlots.size() == this.correctSlots.size();
            }
            case "Click in Order": {
                return this.currentClickIndex == this.clickOrder.size();
            }
        }
        return false;
    }

    private String getColorName(int meta) {
        String[] colors = new String[]{"White", "Orange", "Magenta", "Light Blue", "Yellow", "Lime", "Pink", "Gray", "Light Gray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
        return colors[meta];
    }
}

