/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.terminals;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Location;

@RegisterEvents
public class TerminalTracker {
    private static final AxisAlignedBB GLOBAL_BOUNDS = new AxisAlignedBB(3.0, 100.0, 29.0, 120.0, 159.0, 150.0);
    private static final Map<Integer, Integer> TERMINAL_MAX = new HashMap<Integer, Integer>();
    private static final int LEVER_MAX = 2;
    private static final int DEVICE_MAX = 1;
    private final Map<Integer, Integer> terminalCounts = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> deviceCounts = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> leverCounts = new HashMap<Integer, Integer>();
    private int currentPhase = 1;
    private final Map<Integer, Boolean> gateOpened = new HashMap<Integer, Boolean>();
    private final Map<String, Integer> playerTerminals = new HashMap<String, Integer>();
    private final Map<String, Integer> playerDevices = new HashMap<String, Integer>();
    private final Map<String, Integer> playerLevers = new HashMap<String, Integer>();
    private static final Pattern DEVICE_PATTERN;
    private static final Pattern TERMINAL_PATTERN;
    private static final Pattern LEVER_PATTERN;
    private static final Pattern GATE_PATTERN;

    public TerminalTracker() {
        this.resetCounts();
    }

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent event) {
        if (!Config.feature.dungeons.dungeonsTerminalTracker) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        String message = event.message.func_150260_c();
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (message.startsWith("The Core entrance is opening!")) {
            for (String name : this.playerTerminals.keySet()) {
                int terminals = this.playerTerminals.getOrDefault(name, 0);
                int devices = this.playerDevices.getOrDefault(name, 0);
                int levers = this.playerLevers.getOrDefault(name, 0);
                String msg = String.format("\u00a7b[\u00a7aNEF\u00a7b] \u00a76%s\u00a77, Terminals: \u00a7f%d\u00a77, Devices: \u00a7f%d\u00a77, Levers: \u00a7f%d\u00a77.", name, terminals, devices, levers);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(msg));
            }
        }
        if (player == null || TablistParser.currentLocation != Location.DUNGEON) {
            return;
        }
        if (!this.isPlayerInBounds(player)) {
            return;
        }
        Matcher gateMatcher = GATE_PATTERN.matcher(message);
        if (gateMatcher.matches()) {
            this.gateOpened.put(this.currentPhase, true);
            if (this.currentPhase < 4) {
                ++this.currentPhase;
            }
            return;
        }
        Matcher deviceMatcher = DEVICE_PATTERN.matcher(message);
        if (deviceMatcher.matches() && this.deviceCounts.get(this.currentPhase) < 1) {
            String name = deviceMatcher.group(1);
            this.deviceCounts.put(this.currentPhase, this.deviceCounts.get(this.currentPhase) + 1);
            this.playerDevices.put(name, this.playerDevices.getOrDefault(name, 0) + 1);
            return;
        }
        Matcher terminalMatcher = TERMINAL_PATTERN.matcher(message);
        if (terminalMatcher.matches() && this.terminalCounts.get(this.currentPhase) < TERMINAL_MAX.get(this.currentPhase)) {
            String name = terminalMatcher.group(1);
            this.terminalCounts.put(this.currentPhase, this.terminalCounts.get(this.currentPhase) + 1);
            this.playerTerminals.put(name, this.playerTerminals.getOrDefault(name, 0) + 1);
            return;
        }
        Matcher leverMatcher = LEVER_PATTERN.matcher(message);
        if (leverMatcher.matches() && this.leverCounts.get(this.currentPhase) < 2) {
            String name = leverMatcher.group(1);
            this.leverCounts.put(this.currentPhase, this.leverCounts.get(this.currentPhase) + 1);
            this.playerLevers.put(name, this.playerLevers.getOrDefault(name, 0) + 1);
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        if (!Config.feature.dungeons.dungeonsTerminalTracker) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || TablistParser.currentLocation != Location.DUNGEON) {
            return;
        }
        if (!this.isPlayerInBounds(player)) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(mc);
        int overlayWidth = 1;
        int overlayHeight = 1;
        float scale = Config.feature.dungeons.dungeonsTerminalTrackerScale;
        int x = Config.feature.dungeons.terminalTrackerPos.getAbsX(sr, overlayWidth);
        int y = Config.feature.dungeons.terminalTrackerPos.getAbsY(sr, overlayHeight);
        int lineHeight = (int)(10.0f * scale) + 4;
        String phaseLine = String.format("Phase %d", this.currentPhase);
        String terminalLine = String.format("Terminals: %d/%d", this.terminalCounts.get(this.currentPhase), TERMINAL_MAX.get(this.currentPhase));
        String deviceLine = String.format("Devices: %d/%d", this.deviceCounts.get(this.currentPhase), 1);
        String leverLine = String.format("Levers: %d/%d", this.leverCounts.get(this.currentPhase), 2);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        float scaledX = (float)x / scale;
        float scaledY = (float)y / scale;
        mc.field_71466_p.func_175063_a(phaseLine, scaledX, scaledY, ColorUtils.getColor(Config.feature.dungeons.dungeonsTerminalTrackerColor).getRGB());
        mc.field_71466_p.func_175063_a(terminalLine, scaledX, scaledY + (float)lineHeight / scale, ColorUtils.getColor(Config.feature.dungeons.dungeonsTerminalTrackerColor).getRGB());
        mc.field_71466_p.func_175063_a(deviceLine, scaledX, scaledY + (float)(2 * lineHeight) / scale, ColorUtils.getColor(Config.feature.dungeons.dungeonsTerminalTrackerColor).getRGB());
        mc.field_71466_p.func_175063_a(leverLine, scaledX, scaledY + (float)(3 * lineHeight) / scale, ColorUtils.getColor(Config.feature.dungeons.dungeonsTerminalTrackerColor).getRGB());
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.resetCounts();
        this.playerTerminals.clear();
        this.playerDevices.clear();
        this.playerLevers.clear();
    }

    private void resetCounts() {
        for (int phase = 1; phase <= 4; ++phase) {
            this.terminalCounts.put(phase, 0);
            this.deviceCounts.put(phase, 0);
            this.leverCounts.put(phase, 0);
            this.gateOpened.put(phase, false);
        }
        this.currentPhase = 1;
    }

    private boolean isPlayerInBounds(EntityPlayerSP player) {
        double x = player.field_70165_t;
        double y = player.field_70163_u;
        double z = player.field_70161_v;
        return x >= TerminalTracker.GLOBAL_BOUNDS.field_72340_a && x <= TerminalTracker.GLOBAL_BOUNDS.field_72336_d && y >= TerminalTracker.GLOBAL_BOUNDS.field_72338_b && y <= TerminalTracker.GLOBAL_BOUNDS.field_72337_e && z >= TerminalTracker.GLOBAL_BOUNDS.field_72339_c && z <= TerminalTracker.GLOBAL_BOUNDS.field_72334_f;
    }

    static {
        TERMINAL_MAX.put(1, 4);
        TERMINAL_MAX.put(2, 5);
        TERMINAL_MAX.put(3, 4);
        TERMINAL_MAX.put(4, 4);
        DEVICE_PATTERN = Pattern.compile("^(?:\\[[^\\]]+\\] )?(\\w+) completed a device! \\(\\d+/\\d+\\)$");
        TERMINAL_PATTERN = Pattern.compile("^(?:\\[[^\\]]+\\] )?(\\w+) activated a terminal! \\(\\d+/\\d+\\)$");
        LEVER_PATTERN = Pattern.compile("^(?:\\[[^\\]]+\\] )?(\\w+) activated a lever! \\(\\d+/\\d+\\)$");
        GATE_PATTERN = Pattern.compile("The gate will open in 5 seconds!");
    }
}

