/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.terminals;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@RegisterEvents
public class TerminalWaypoints {
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (Config.feature.dungeons.dungeonsTerminalWaypoints && DungeonManager.checkEssentialsF7()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g == null) {
                return;
            }
            for (Entity entity : mc.field_71441_e.field_72996_f) {
                String name = entity.func_145748_c_().func_150260_c();
                if (!name.contains("Inactive Device") && !name.contains("Not Activated") && !name.contains("Inactive Terminal")) continue;
                AxisAlignedBB bb = TerminalWaypoints.getAxisAlignedBB(event, entity, mc);
                GlStateManager.func_179094_E();
                GlStateManager.func_179097_i();
                GlStateManager.func_179090_x();
                GlStateManager.func_179140_f();
                GlStateManager.func_179129_p();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                Color color = new Color(0, 191, 255, 150);
                this.drawFilledBB(bb, color);
                GlStateManager.func_179089_o();
                GlStateManager.func_179145_e();
                GlStateManager.func_179098_w();
                GlStateManager.func_179126_j();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
    }

    @NotNull
    private static AxisAlignedBB getAxisAlignedBB(RenderWorldLastEvent event, Entity entity, Minecraft mc) {
        double px = mc.field_71439_g.field_70142_S + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70142_S) * (double)event.partialTicks;
        double py = mc.field_71439_g.field_70137_T + (mc.field_71439_g.field_70163_u - mc.field_71439_g.field_70137_T) * (double)event.partialTicks;
        double pz = mc.field_71439_g.field_70136_U + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70136_U) * (double)event.partialTicks;
        double blockX = Math.floor(entity.field_70165_t);
        double blockY = Math.floor(entity.field_70163_u);
        double blockZ = Math.floor(entity.field_70161_v);
        return new AxisAlignedBB(blockX - px, blockY - py, blockZ - pz, blockX - px + 1.0, blockY - py + 1.0, blockZ - pz + 1.0);
    }

    private void drawFilledBB(AxisAlignedBB bb, Color color) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)bb.field_72340_a, (double)bb.field_72338_b, (double)bb.field_72339_c);
        GL11.glVertex3d((double)bb.field_72336_d, (double)bb.field_72338_b, (double)bb.field_72339_c);
        GL11.glVertex3d((double)bb.field_72336_d, (double)bb.field_72338_b, (double)bb.field_72334_f);
        GL11.glVertex3d((double)bb.field_72340_a, (double)bb.field_72338_b, (double)bb.field_72334_f);
        GL11.glVertex3d((double)bb.field_72340_a, (double)bb.field_72337_e, (double)bb.field_72339_c);
        GL11.glVertex3d((double)bb.field_72336_d, (double)bb.field_72337_e, (double)bb.field_72339_c);
        GL11.glVertex3d((double)bb.field_72336_d, (double)bb.field_72337_e, (double)bb.field_72334_f);
        GL11.glVertex3d((double)bb.field_72340_a, (double)bb.field_72337_e, (double)bb.field_72334_f);
        GL11.glVertex3d((double)bb.field_72340_a, (double)bb.field_72338_b, (double)bb.field_72339_c);
        GL11.glVertex3d((double)bb.field_72336_d, (double)bb.field_72338_b, (double)bb.field_72339_c);
        GL11.glVertex3d((double)bb.field_72336_d, (double)bb.field_72337_e, (double)bb.field_72339_c);
        GL11.glVertex3d((double)bb.field_72340_a, (double)bb.field_72337_e, (double)bb.field_72339_c);
        GL11.glVertex3d((double)bb.field_72340_a, (double)bb.field_72338_b, (double)bb.field_72334_f);
        GL11.glVertex3d((double)bb.field_72336_d, (double)bb.field_72338_b, (double)bb.field_72334_f);
        GL11.glVertex3d((double)bb.field_72336_d, (double)bb.field_72337_e, (double)bb.field_72334_f);
        GL11.glVertex3d((double)bb.field_72340_a, (double)bb.field_72337_e, (double)bb.field_72334_f);
        GL11.glVertex3d((double)bb.field_72340_a, (double)bb.field_72338_b, (double)bb.field_72339_c);
        GL11.glVertex3d((double)bb.field_72340_a, (double)bb.field_72338_b, (double)bb.field_72334_f);
        GL11.glVertex3d((double)bb.field_72340_a, (double)bb.field_72337_e, (double)bb.field_72334_f);
        GL11.glVertex3d((double)bb.field_72340_a, (double)bb.field_72337_e, (double)bb.field_72339_c);
        GL11.glVertex3d((double)bb.field_72336_d, (double)bb.field_72338_b, (double)bb.field_72339_c);
        GL11.glVertex3d((double)bb.field_72336_d, (double)bb.field_72338_b, (double)bb.field_72334_f);
        GL11.glVertex3d((double)bb.field_72336_d, (double)bb.field_72337_e, (double)bb.field_72334_f);
        GL11.glVertex3d((double)bb.field_72336_d, (double)bb.field_72337_e, (double)bb.field_72339_c);
        GL11.glEnd();
    }
}

