/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.fishing;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.ParticlePacketEvent;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;

@RegisterEvents
public class FishingCountdown {
    private final Minecraft mc = Minecraft.func_71410_x();
    private EntityFishHook playerBobber;
    private long fishBiteTime;
    private String countdownText = null;
    private long countdownEndTime = 0L;
    private final List<ParticleData> particleHistory = new ArrayList<ParticleData>();
    private static final int MIN_PARTICLES_FOR_PATH = 3;
    private static final long MAX_PARTICLE_AGE = 1000L;
    private static final double MAX_INTER_PARTICLE_DISTANCE = 1.0;
    private boolean biteTriggered = false;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || this.mc.field_71441_e == null || this.mc.field_71439_g == null) {
            return;
        }
        if (!Config.feature.fishing.fishingCountdown) {
            return;
        }
        this.updatePlayerBobber();
        this.mc.func_152344_a(() -> this.checkFishBiteStatus());
        this.mc.func_152344_a(() -> this.cleanupParticleHistory());
    }

    private void updatePlayerBobber() {
        this.playerBobber = this.mc.field_71439_g.field_71104_cf;
    }

    private void checkFishBiteStatus() {
        if (this.mc.field_71439_g == null) {
            return;
        }
        if (this.playerBobber == null) {
            this.countdownText = null;
            this.particleHistory.clear();
            this.biteTriggered = false;
            return;
        }
        if (!this.biteTriggered && System.currentTimeMillis() >= this.fishBiteTime && this.countdownText != null) {
            this.countdownText = "\u00a7c\u00a7l!!!";
            SoundUtils.playSound(this.mc.field_71439_g.func_180425_c().func_177958_n(), this.mc.field_71439_g.func_180425_c().func_177956_o(), this.mc.field_71439_g.func_180425_c().func_177952_p(), "note.pling", 1.0f, 1.0f);
            this.countdownEndTime = System.currentTimeMillis() + 2000L;
            this.biteTriggered = true;
        }
        if (this.biteTriggered && System.currentTimeMillis() > this.countdownEndTime) {
            this.countdownText = null;
            this.biteTriggered = false;
        }
    }

    @SubscribeEvent
    public void onParticlePacketReceived(ParticlePacketEvent event) {
        EnumParticleTypes[] fishingParticles;
        S2APacketParticles packet = event.getPacket();
        if (this.playerBobber == null) {
            return;
        }
        for (EnumParticleTypes particleType : fishingParticles = new EnumParticleTypes[]{EnumParticleTypes.WATER_WAKE, EnumParticleTypes.LAVA}) {
            if (particleType != packet.func_179749_a()) continue;
            Vec3 particlePos = new Vec3(packet.func_149220_d(), packet.func_149226_e(), packet.func_149225_f());
            this.processFishingParticle(particlePos);
            break;
        }
    }

    private void processFishingParticle(Vec3 particlePos) {
        if (this.playerBobber == null) {
            return;
        }
        double dx = particlePos.field_72450_a - this.playerBobber.field_70165_t;
        double dz = particlePos.field_72449_c - this.playerBobber.field_70161_v;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        if (horizontalDist > 3.0) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        this.particleHistory.add(new ParticleData(particlePos, currentTime));
        if (this.particleHistory.size() >= 3 && this.isValidParticlePath(new Vec3(this.playerBobber.field_70165_t, 0.0, this.playerBobber.field_70161_v))) {
            double distanceDecrease;
            double speed;
            ParticleData firstParticle = this.particleHistory.get(0);
            ParticleData lastParticle = this.particleHistory.get(this.particleHistory.size() - 1);
            double firstDistance = new Vec3(firstParticle.position.field_72450_a, 0.0, firstParticle.position.field_72449_c).func_72438_d(new Vec3(this.playerBobber.field_70165_t, 0.0, this.playerBobber.field_70161_v));
            double lastDistance = new Vec3(lastParticle.position.field_72450_a, 0.0, lastParticle.position.field_72449_c).func_72438_d(new Vec3(this.playerBobber.field_70165_t, 0.0, this.playerBobber.field_70161_v));
            long totalTimeDiff = lastParticle.timestamp - firstParticle.timestamp;
            if (totalTimeDiff > 0L && firstDistance > lastDistance && (speed = (distanceDecrease = firstDistance - lastDistance) / (double)totalTimeDiff) > 0.0) {
                double currentDistance = lastDistance;
                double timeToReach = currentDistance / speed;
                this.fishBiteTime = currentTime + (long)timeToReach;
                if (timeToReach > 100.0) {
                    double countdownVal = MathHelper.func_151237_a((double)(timeToReach / 1000.0), (double)0.1, (double)5.0);
                    this.countdownText = "\u00a7e\u00a7l" + this.formatCountdownNumber(countdownVal);
                    this.countdownEndTime = currentTime + 1000L;
                }
            }
        }
    }

    private boolean isValidParticlePath(Vec3 bobberPos) {
        if (this.particleHistory.size() < 3) {
            return false;
        }
        for (int i = 1; i < this.particleHistory.size(); ++i) {
            double interParticleDistance = this.particleHistory.get((int)i).position.func_72438_d(this.particleHistory.get((int)(i - 1)).position);
            if (!(interParticleDistance > 1.0)) continue;
            return false;
        }
        double firstDistance = this.particleHistory.get((int)0).position.func_72438_d(bobberPos);
        double lastDistance = this.particleHistory.get((int)(this.particleHistory.size() - 1)).position.func_72438_d(bobberPos);
        return lastDistance < firstDistance;
    }

    private void cleanupParticleHistory() {
        long currentTime = System.currentTimeMillis();
        this.particleHistory.removeIf(particle -> currentTime - particle.timestamp > 1000L);
    }

    private String formatCountdownNumber(double value) {
        return String.format("%.1f", (double)Math.round(value * 10.0) / 10.0);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (!Config.feature.fishing.fishingCountdown) {
            return;
        }
        if (event.type != RenderGameOverlayEvent.ElementType.TEXT || this.countdownText == null) {
            return;
        }
        if (System.currentTimeMillis() > this.countdownEndTime) {
            this.countdownText = null;
            return;
        }
        FontRenderer fr = this.mc.field_71466_p;
        ScaledResolution res = new ScaledResolution(this.mc);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
        int textWidth = fr.func_78256_a(this.countdownText);
        int x = res.func_78326_a() / 4 - textWidth / 2;
        int y = res.func_78328_b() / 4 + 10;
        fr.func_175063_a(this.countdownText, (float)x, (float)y, 0xFFFFFF);
        GlStateManager.func_179121_F();
    }

    private static class ParticleData {
        Vec3 position;
        long timestamp;

        ParticleData(Vec3 position, long timestamp) {
            this.position = position;
            this.timestamp = timestamp;
        }
    }
}

