/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Location;
import org.jetbrains.annotations.NotNull;

@RegisterEvents
public class AbilityNotifier {
    private static long lastUsed = -1L;
    private static long canUse = -1L;
    private static boolean notifyScheduled = false;
    private static final String READY_MESSAGE = EnumChatFormatting.GREEN + "Ready";

    @SubscribeEvent
    public void onChat(@NotNull ClientChatReceivedEvent e) {
        if (AbilityNotifier.checkEssentials()) {
            return;
        }
        Matcher matcher = Pattern.compile("You used your (.+) Pickaxe Ability!").matcher(e.message.func_150260_c());
        if (matcher.find()) {
            lastUsed = System.currentTimeMillis();
            canUse = lastUsed + 120000L;
            notifyScheduled = true;
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (AbilityNotifier.checkEssentials()) {
            return;
        }
        if (!Config.feature.mining.miningAbilityNotifier) {
            return;
        }
        if (canUse == -1L || lastUsed == -1L) {
            return;
        }
        if (canUse > System.currentTimeMillis() || !notifyScheduled) {
            return;
        }
        AbilityNotifier.reminder();
    }

    public static void reminder() {
        Minecraft.func_71410_x().field_71456_v.func_175178_a(EnumChatFormatting.GOLD + "Mining Ability Ready", "", 2, 70, 2);
        notifyScheduled = false;
    }

    public static String cdSecondsRemaining() {
        if (lastUsed == -1L || canUse == -1L) {
            return READY_MESSAGE;
        }
        if (canUse < System.currentTimeMillis()) {
            return READY_MESSAGE;
        }
        return EnumChatFormatting.RED + String.valueOf((canUse - System.currentTimeMillis()) / 1000L) + "s";
    }

    private static boolean checkEssentials() {
        return Minecraft.func_71410_x().field_71439_g == null || !ScoreboardUtils.currentGamemode.isSkyblock() || !TablistParser.currentLocation.equals((Object)Location.DWARVEN) && !TablistParser.currentLocation.equals((Object)Location.CRYSTAL_HOLLOWS);
    }
}

