/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Colors;
import org.ginafro.notenoughfakepixel.variables.Location;

@RegisterEvents
public class DrillFuelParsing {
    public static int lastRead = 0;
    public static int fuel = 0;
    public static int fuelMax = 0;
    public static Matcher fuelMatcher = Pattern.compile("\u00a77Fuel: \u00a72([\\d,]+)\u00a78/(\\d+)k").matcher("");

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        String fuelLore;
        if (!Config.feature.mining.miningDrillFuel) {
            return;
        }
        if (lastRead < 120) {
            ++lastRead;
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (!TablistParser.currentLocation.equals((Object)Location.DWARVEN) && !TablistParser.currentLocation.equals((Object)Location.CRYSTAL_HOLLOWS)) {
            return;
        }
        ItemStack heldItem = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        if (heldItem == null) {
            return;
        }
        if (!ItemUtils.getInternalName(heldItem).contains("_DRILL_") && !ItemUtils.getInternalName(heldItem).equals("DIVAN_DRILL")) {
            return;
        }
        int fuelTemp = ItemUtils.getExtraAttributesIntTag(heldItem, "fuel");
        if (fuelTemp != -1) {
            fuel = fuelTemp;
        }
        if ((fuelLore = ItemUtils.getLoreLine(heldItem, "Fuel:")) == null) {
            return;
        }
        fuelMatcher.reset(fuelLore);
        if (fuelMatcher.find()) {
            fuelMax = Integer.parseInt(fuelMatcher.group(2).replace(",", "")) * 1000;
        }
        lastRead = 0;
    }

    public static String getString() {
        Colors color = (double)fuel > (double)fuelMax * 0.5 ? Colors.GREEN : ((double)fuel > (double)fuelMax * 0.25 ? Colors.YELLOW : Colors.RED);
        return (Object)((Object)Colors.GRAY) + "Drill Fuel: " + (Object)((Object)color) + fuel + (Object)((Object)Colors.GRAY) + "/" + fuelMax;
    }
}

