/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining;

import net.minecraft.util.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Location;

@RegisterEvents
public class DwarvenWaypoints {
    private static final DwarvenWaypoint[] WAYPOINTS = new DwarvenWaypoint[]{new DwarvenWaypoint("The Lift", -62.0, 200.0, -121.0), new DwarvenWaypoint("Dwarven Vilage", 7.0, 200.0, -121.0), new DwarvenWaypoint("Lava Springs", 57.0, 207.0, -9.0), new DwarvenWaypoint("The Forge", 0.0, 148.0, -53.0), new DwarvenWaypoint("Rampart's Quarry", -77.0, 153.0, -10.0), new DwarvenWaypoint("Far Reserve", -154.0, 149.0, -17.0), new DwarvenWaypoint("Goblin Burrows", -137.0, 146.0, 128.0), new DwarvenWaypoint("The Great Ice Wall", 0.0, 128.0, 160.0), new DwarvenWaypoint("Royal Palace", 129.0, 195.0, 176.0), new DwarvenWaypoint("Royal Mines", 150.0, 151.0, 33.0), new DwarvenWaypoint("Cliffside Veins", 38.0, 128.0, 32.0), new DwarvenWaypoint("Divan's Gateway", 0.0, 128.0, 96.0), new DwarvenWaypoint("Upper Mines", -117.0, 181.0, -63.0), new DwarvenWaypoint("The Mist", -12.0, 76.0, 109.0)};

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (TablistParser.currentLocation != Location.DWARVEN) {
            return;
        }
        if (!Config.feature.mining.miningDwarvenWaypoints) {
            return;
        }
        boolean renderBeacon = Config.feature.mining.miningDwarvenBeacons;
        for (DwarvenWaypoint waypoint : WAYPOINTS) {
            if (renderBeacon) {
                RenderUtils.renderBeaconBeam(new BlockPos(waypoint.x, waypoint.y, waypoint.z), ColorUtils.getColor(Config.feature.mining.miningDwarvenBeaconsColor).getRGB(), 1.0f, event.partialTicks);
            }
            RenderUtils.renderWaypointText(waypoint.getName(), new BlockPos(waypoint.x, waypoint.y + 3.0, waypoint.z), event.partialTicks);
        }
    }

    private static class DwarvenWaypoint {
        private final String name;
        private final double x;
        private final double y;
        private final double z;

        public DwarvenWaypoint(String name, double x, double y, double z) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public String getName() {
            return this.name;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DwarvenWaypoint)) {
                return false;
            }
            DwarvenWaypoint other = (DwarvenWaypoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getX(), other.getX()) != 0) {
                return false;
            }
            if (Double.compare(this.getY(), other.getY()) != 0) {
                return false;
            }
            if (Double.compare(this.getZ(), other.getZ()) != 0) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DwarvenWaypoint;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $x = Double.doubleToLongBits(this.getX());
            result = result * 59 + (int)($x >>> 32 ^ $x);
            long $y = Double.doubleToLongBits(this.getY());
            result = result * 59 + (int)($y >>> 32 ^ $y);
            long $z = Double.doubleToLongBits(this.getZ());
            result = result * 59 + (int)($z >>> 32 ^ $z);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "DwarvenWaypoints.DwarvenWaypoint(name=" + this.getName() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
        }
    }
}

