/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.AbilityNotifier;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.DrillFuelParsing;
import org.ginafro.notenoughfakepixel.features.skyblock.overlays.Overlay;
import org.ginafro.notenoughfakepixel.utils.ListUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Location;

@RegisterEvents
public class MiningOverlay
extends Overlay {
    private static final int LINE_HEIGHT = 11;
    private static final int MINIMUM_WIDTH = 20;
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!this.shouldShow()) {
            return;
        }
        this.draw(Config.feature.mining.miningOverlayOffsetX, Config.feature.mining.miningOverlayOffsetY, Config.feature.mining.miningOverlayScale, Config.feature.mining.miningOverlayBackgroundColor);
    }

    @Override
    public boolean shouldShow() {
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return false;
        }
        if (!TablistParser.currentLocation.equals((Object)Location.DWARVEN) && !TablistParser.currentLocation.equals((Object)Location.CRYSTAL_HOLLOWS)) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74321_H.func_151470_d()) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return false;
        }
        if (Config.feature.mining.miningOverlayHideOnChat && this.mc.field_71462_r instanceof GuiChat) {
            return false;
        }
        if (this.mc.field_71474_y.field_74330_P) {
            return false;
        }
        return Config.feature.mining.miningOverlay;
    }

    @Override
    public List<String> getLines() {
        if (!this.shouldShow()) {
            return ListUtils.of();
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (Config.feature.mining.miningAbilityCooldown) {
            lines.add("\u00a77Ability Cooldown: \u00a7r" + AbilityNotifier.cdSecondsRemaining());
        }
        if (Config.feature.mining.miningMithrilPowder && TablistParser.currentLocation.equals((Object)Location.DWARVEN)) {
            lines.add(this.formatMithrilPowder(TablistParser.mithrilPowder));
        }
        if (Config.feature.mining.miningGemstonePowder && TablistParser.currentLocation.equals((Object)Location.CRYSTAL_HOLLOWS)) {
            lines.add(this.formatGemstonePowder(TablistParser.gemstonePowder));
        }
        if (Config.feature.mining.miningDrillFuel) {
            lines.add(DrillFuelParsing.getString());
        }
        if (Config.feature.mining.miningCommissions) {
            for (String commission : TablistParser.commissions) {
                lines.add(this.formatCommission(commission));
            }
        }
        return lines;
    }

    @Override
    public float getWidth(float scale, List<String> lines) {
        float var = Math.max(this.getLongestLine(lines) * 5, 20);
        return var * scale;
    }

    @Override
    public float getHeight(float scale, List<String> lines) {
        return lines.size() * 11;
    }

    private String formatMithrilPowder(long mithrilPowder) {
        return String.format("\u00a77Mithril Powder: \u00a72%d", mithrilPowder);
    }

    private String formatGemstonePowder(long gemstonePowder) {
        return String.format("\u00a77Gemstone Powder: \u00a7d%d", gemstonePowder);
    }

    private String formatCommission(String commission) {
        String[] split = commission.split(":");
        try {
            if (split.length == 0) {
                return commission;
            }
            double percent = Double.parseDouble(split[1].replaceAll("[ %]", ""));
            String colorCode = percent <= 33.0 ? "\u00a7c" : (percent <= 79.0 ? "\u00a7e" : "\u00a7a");
            return "\u00a77" + commission.split(":")[0] + ": " + colorCode + percent + "%";
        }
        catch (Exception exception) {
            return commission;
        }
    }
}

