/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.Logger;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Location;
import org.ginafro.notenoughfakepixel.variables.Resources;
import org.jetbrains.annotations.NotNull;

@RegisterEvents
public class CrystalHollowsMap
extends Gui {
    private static final int MARGIN_PX = 6;
    private static final ResourceLocation MAP_ZONES_TEX = Resources.CRYSTAL_MAP_ZONES.getResource();
    private static final ResourceLocation MAP_GEMS_TEX = Resources.CRYSTAL_MAP_GEMS.getResource();
    private static final ResourceLocation PLAYER_ARROW_TEX = Resources.CRYSTAL_MAP_ARROW.getResource();
    private static final ResourceLocation PLAYER_ARROW_OUT_TEX = Resources.CRYSTAL_MAP_POINT.getResource();
    private static final int ARROW_SRC_W = 16;
    private static final int ARROW_SRC_H = 16;
    private static final int ARROW_DST = 12;
    private static final float EDGE_EPS = 0.001f;
    private final Minecraft mc = Minecraft.func_71410_x();
    private static final double WORLD_MIN_X = 202.0;
    private static final double WORLD_MIN_Z = 202.0;
    private static final double WORLD_MAX_X = 823.0;
    private static final double WORLD_MAX_Z = 823.0;

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        if (!Config.feature.mining.miningCrystalMap) {
            return;
        }
        if (!(event instanceof RenderGameOverlayEvent.Post)) {
            return;
        }
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (TablistParser.currentLocation != Location.CRYSTAL_HOLLOWS) {
            return;
        }
        if (Config.feature.mining.miningOverlayHideOnChat && this.mc.field_71462_r instanceof GuiChat) {
            return;
        }
        if (this.mc.field_71439_g == null || this.mc.field_71474_y.field_74321_H.func_151470_d() || this.mc.field_71474_y.field_74330_P) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(this.mc);
        int x = Config.feature.mining.crystalMapPos.getAbsX(sr, Config.feature.mining.miningCrystalMapWidth) - Config.feature.mining.miningCrystalMapWidth / 2;
        int y = Config.feature.mining.crystalMapPos.getAbsY(sr, Config.feature.mining.miningCrystalMapWidth) - Config.feature.mining.miningCrystalMapWidth / 2;
        int w = Config.feature.mining.miningCrystalMapWidth;
        this.drawMap(x, y, w);
        this.drawPlayer(x, y, w);
        this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMap(int x, int y, int w) {
        ResourceLocation mapTex = Objects.equals(Config.feature.mining.miningCrystalMapType, "Gemstones") ? MAP_GEMS_TEX : MAP_ZONES_TEX;
        float texW = 256.0f;
        float texH = 256.0f;
        float u = 0.0f;
        float v = 0.0f;
        int srcW = 256;
        int srcH = 256;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        try {
            this.mc.func_110434_K().func_110577_a(mapTex);
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            CrystalHollowsMap.func_152125_a((int)x, (int)y, (float)u, (float)v, (int)256, (int)256, (int)w, (int)w, (float)256.0f, (float)256.0f);
        }
        catch (Exception ex) {
            Logger.logErrorConsole("Failed to render Crystal Hollows map overlay." + ex.getMessage());
        }
        finally {
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private void drawPlayer(int x, int y, int w) {
        double px = this.mc.field_71439_g.field_70165_t;
        double pz = this.mc.field_71439_g.field_70161_v;
        ResourceLocation arrowTex = CrystalHollowsMap.getResourceLocation(px, pz);
        float sx = CrystalHollowsMap.worldToScreenX(px, x, w);
        float sy = CrystalHollowsMap.worldToScreenY(pz, y, w);
        float yaw = this.mc.field_71439_g.field_70177_z;
        float angle = 180.0f - yaw;
        float centerNudge = 0.0f;
        float half = 6.0f;
        this.mc.func_110434_K().func_110577_a(arrowTex);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179109_b((float)(sx + 0.0f), (float)(sy + 0.0f), (float)0.0f);
        GlStateManager.func_179114_b((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)-6.0f, (float)-6.0f, (float)0.0f);
        Gui.func_152125_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)12, (int)12, (float)16.0f, (float)16.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @NotNull
    private static ResourceLocation getResourceLocation(double px, double pz) {
        float tXraw = (float)((px - 202.0) / 621.0);
        float tZraw = (float)((pz - 202.0) / 621.0);
        boolean isOut = tXraw < 0.0f || tXraw > 1.0f || tZraw < 0.0f || tZraw > 1.0f;
        boolean atEdge = !isOut && (tXraw <= 0.001f || tXraw >= 0.999f || tZraw <= 0.001f || tZraw >= 0.999f);
        return isOut ? PLAYER_ARROW_OUT_TEX : PLAYER_ARROW_TEX;
    }

    private static float worldToScreenX(double worldX, float hudX, float hudW) {
        float t = (float)((worldX - 202.0) / 621.0);
        if (t < 0.0f) {
            t = 0.0f;
        } else if (t > 1.0f) {
            t = 1.0f;
        }
        return hudX + t * hudW;
    }

    private static float worldToScreenY(double worldZ, float hudY, float hudH) {
        float t = (float)((worldZ - 202.0) / 621.0);
        if (t < 0.0f) {
            t = 0.0f;
        } else if (t > 1.0f) {
            t = 1.0f;
        }
        return hudY + t * hudH;
    }

    public static int getMARGIN_PX() {
        return 6;
    }
}

