/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.ParticlePacketEvent;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;

@RegisterEvents
public class LockedTreasureHelper {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final double CHEST_RANGE = 0.5;
    private static final float SQUARE_SIZE = 0.18f;
    private static final long MARKER_TTL_MS = 300L;
    private final List<AxisAlignedBB> chestBoxes = new ArrayList<AxisAlignedBB>(64);
    private final List<Marker> markers = new ArrayList<Marker>(64);

    private Marker obtainMarker() {
        for (Marker marker : this.markers) {
            if (marker.dieAt > 0L) continue;
            return marker;
        }
        Marker m = new Marker();
        this.markers.add(m);
        return m;
    }

    @SubscribeEvent
    public void onParticlePacket(ParticlePacketEvent e) {
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (!Config.feature.mining.lockedTreasureChest) {
            return;
        }
        if (LockedTreasureHelper.MC.field_71441_e == null) {
            return;
        }
        S2APacketParticles p = e.getPacket();
        if (p.func_179749_a() != EnumParticleTypes.CRIT) {
            return;
        }
        double x = p.func_149220_d();
        double y = p.func_149226_e();
        double z = p.func_149225_f();
        this.collectNearbyChestAABBs();
        if (this.chestBoxes.isEmpty()) {
            return;
        }
        for (AxisAlignedBB box : this.chestBoxes) {
            if (!LockedTreasureHelper.pointWithinExpandedAABB(x, y, z, box, 0.5)) continue;
            e.setCanceled(true);
            Marker m = this.obtainMarker();
            m.set(x, y, z, System.currentTimeMillis() + 300L);
            break;
        }
    }

    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent evt) {
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (!Config.feature.mining.lockedTreasureChest) {
            return;
        }
        if (LockedTreasureHelper.MC.field_71441_e == null || LockedTreasureHelper.MC.field_71439_g == null) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean anyAlive = false;
        for (Marker marker : this.markers) {
            if (marker.dieAt <= now) continue;
            anyAlive = true;
            break;
        }
        if (!anyAlive) {
            return;
        }
        double camX = LockedTreasureHelper.MC.func_175598_ae().field_78730_l;
        double camY = LockedTreasureHelper.MC.func_175598_ae().field_78731_m;
        double camZ = LockedTreasureHelper.MC.func_175598_ae().field_78728_n;
        float half = 0.09f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)0.85f);
        Tessellator tess = Tessellator.func_178181_a();
        WorldRenderer wr = tess.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (Marker m : this.markers) {
            if (m.dieAt <= now) {
                m.dieAt = 0L;
                continue;
            }
            double cx = m.x - camX;
            double cy = m.y - camY;
            double vx = cx;
            double cz = m.z - camZ;
            double vz = cz;
            double vLen = Math.sqrt(vx * vx + vz * vz);
            if (vLen < 1.0E-6) {
                vx = 0.0;
                vz = 1.0;
                vLen = 1.0;
            }
            double rdx = (vz /= vLen) * (double)0.09f;
            double rdz = -(vx /= vLen) * (double)0.09f;
            double udx = 0.0;
            double udy = 0.09f;
            double udz = 0.0;
            wr.func_181662_b(cx - rdx - udx, cy - udy, cz - rdz - udz).func_181675_d();
            wr.func_181662_b(cx - rdx + udx, cy + udy, cz - rdz + udz).func_181675_d();
            wr.func_181662_b(cx + rdx + udx, cy + udy, cz + rdz + udz).func_181675_d();
            wr.func_181662_b(cx + rdx - udx, cy - udy, cz + rdz - udz).func_181675_d();
        }
        tess.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    private static boolean pointWithinExpandedAABB(double x, double y, double z, AxisAlignedBB box, double expand) {
        return x >= box.field_72340_a - expand && x <= box.field_72336_d + expand && y >= box.field_72338_b - expand && y <= box.field_72337_e + expand && z >= box.field_72339_c - expand && z <= box.field_72334_f + expand;
    }

    private void collectNearbyChestAABBs() {
        this.chestBoxes.clear();
        if (LockedTreasureHelper.MC.field_71441_e == null || LockedTreasureHelper.MC.field_71439_g == null) {
            return;
        }
        int view = LockedTreasureHelper.MC.field_71474_y.field_151451_c * 16 + 16;
        double px = LockedTreasureHelper.MC.field_71439_g.field_70165_t;
        double py = LockedTreasureHelper.MC.field_71439_g.field_70163_u;
        double pz = LockedTreasureHelper.MC.field_71439_g.field_70161_v;
        double maxDistSq = (double)view * (double)view;
        List tiles = LockedTreasureHelper.MC.field_71441_e.field_147482_g;
        for (TileEntity te : tiles) {
            double cz;
            double cy;
            BlockPos bp;
            double cx;
            if (!(te instanceof TileEntityChest) || (cx = (double)(bp = te.func_174877_v()).func_177958_n() + 0.5 - px) * cx + (cy = (double)bp.func_177956_o() + 0.5 - py) * cy + (cz = (double)bp.func_177952_p() + 0.5 - pz) * cz > maxDistSq) continue;
            this.chestBoxes.add(new AxisAlignedBB((double)bp.func_177958_n(), (double)bp.func_177956_o(), (double)bp.func_177952_p(), (double)(bp.func_177958_n() + 1), (double)(bp.func_177956_o() + 1), (double)(bp.func_177952_p() + 1)));
        }
    }

    private static class Marker {
        double x;
        double y;
        double z;
        long dieAt;

        private Marker() {
        }

        void set(double x, double y, double z, long dieAt) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dieAt = dieAt;
        }
    }
}

