/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.overlays.Overlay;
import org.ginafro.notenoughfakepixel.utils.InventoryUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.variables.Area;

@RegisterEvents
public class PrecursorItemsOverlay
extends Overlay {
    private static boolean hasSwitch = false;
    private static boolean hasSynthetic = false;
    private static boolean hasSuperlite = false;
    private static boolean hasRobotron = false;
    private static boolean hasElectron = false;
    private static boolean hasFTX = false;
    private int tickCounter = 0;

    @Override
    public boolean shouldShow() {
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return false;
        }
        if (ScoreboardUtils.currentArea != Area.CH_LOST_PRECURSOR) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74321_H.func_151470_d()) {
            return false;
        }
        if (Config.feature.mining.miningOverlayHideOnChat && this.mc.field_71462_r instanceof GuiChat) {
            return false;
        }
        return Config.feature.mining.crystalShowAutomaton;
    }

    @Override
    public List<String> getLines() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("\u00a79Synthetic Heart \u00a77- \u00a7" + (hasSynthetic ? "a\u2714" : "c\u2716"));
        lines.add("\u00a7bSuperlite Motor \u00a77- \u00a7" + (hasSuperlite ? "a\u2714" : "c\u2716"));
        lines.add("\u00a7eRobotron Reflector \u00a77- \u00a7" + (hasRobotron ? "a\u2714" : "c\u2716"));
        lines.add("\u00a7aElectron Transmitter \u00a77- \u00a7" + (hasElectron ? "a\u2714" : "c\u2716"));
        lines.add("\u00a7cFTX 3070 \u00a77- \u00a7" + (hasFTX ? "a\u2714" : "c\u2716"));
        lines.add("\u00a7dControl Switch \u00a77- \u00a7" + (hasSwitch ? "a\u2714" : "c\u2716"));
        return lines;
    }

    @Override
    public float getWidth(float scale, List<String> lines) {
        return 170.0f;
    }

    @Override
    public float getHeight(float scale, List<String> lines) {
        return 11 * this.getLines().size();
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!this.shouldShow()) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        int width = (int)this.getWidth(Config.feature.mining.automatonOverlayScale, this.getLines());
        int height = (int)this.getHeight(Config.feature.mining.automatonOverlayScale, this.getLines());
        int x = Config.feature.mining.automatonOverlayPos.getAbsX(sr, width);
        int y = Config.feature.mining.automatonOverlayPos.getAbsY(sr, height);
        this.draw((float)x - (float)width / 2.0f, (float)y - (float)height / 2.0f, Config.feature.mining.automatonOverlayScale, Config.feature.mining.miningOverlayBackgroundColor);
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 330 == 0 && this.shouldShow()) {
            hasSynthetic = InventoryUtils.searchForItemInInventory("SYNTHETIC_HEART");
            hasElectron = InventoryUtils.searchForItemInInventory("ELECTRON_TRANSMITTER");
            hasSwitch = InventoryUtils.searchForItemInInventory("CONTROL_SWITCH");
            hasFTX = InventoryUtils.searchForItemInInventory("FTX_3070");
            hasRobotron = InventoryUtils.searchForItemInInventory("ROBOTRON_REFLECTOR");
            hasSuperlite = InventoryUtils.searchForItemInInventory("SUPERLITE_MOTOR");
            this.tickCounter = 0;
        }
    }
}

