/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.overlays.Overlay;
import org.ginafro.notenoughfakepixel.utils.InventoryUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.variables.Area;

@RegisterEvents
public class ScavengedToolsOverlay
extends Overlay {
    private static boolean hasLapis = false;
    private static boolean hasGoldh = false;
    private static boolean hasEmera = false;
    private static boolean hasDiamo = false;
    private int tickCounter = 0;

    @Override
    public boolean shouldShow() {
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return false;
        }
        if (ScoreboardUtils.currentArea != Area.CH_MINES_OF_DIVAN) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74321_H.func_151470_d()) {
            return false;
        }
        if (Config.feature.mining.miningOverlayHideOnChat && this.mc.field_71462_r instanceof GuiChat) {
            return false;
        }
        return Config.feature.mining.scavengedOverlay;
    }

    @Override
    public List<String> getLines() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("\u00a73Scavenged \u00a79Lapis Sword \u00a77-       \u00a7" + (hasLapis ? "a\u2714" : "c\u2716"));
        lines.add("\u00a73Scavenged \u00a76Gold Hammer \u00a77-       \u00a7" + (hasGoldh ? "a\u2714" : "c\u2716"));
        lines.add("\u00a73Scavenged \u00a7aEmerald Hammer \u00a77-  \u00a7" + (hasEmera ? "a\u2714" : "c\u2716"));
        lines.add("\u00a73Scavenged \u00a7bDiamond Axe \u00a77-       \u00a7" + (hasDiamo ? "a\u2714" : "c\u2716"));
        return lines;
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 330 == 0 && this.shouldShow()) {
            hasLapis = InventoryUtils.searchForItemInInventory("DWARVEN_LAPIS_SWORD");
            hasGoldh = InventoryUtils.searchForItemInInventory("DWARVEN_GOLD_HAMMER");
            hasEmera = InventoryUtils.searchForItemInInventory("DWARVEN_EMERALD_HAMMER");
            hasDiamo = InventoryUtils.searchForItemInInventory("DWARVEN_DIAMOND_AXE");
            this.tickCounter = 0;
        }
    }

    @Override
    public float getWidth(float scale, List<String> lines) {
        return 170.0f;
    }

    @Override
    public float getHeight(float scale, List<String> lines) {
        return 11 * this.getLines().size();
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!this.shouldShow()) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        int width = (int)this.getWidth(Config.feature.mining.scavengedOverlayScale, this.getLines());
        int height = (int)this.getHeight(Config.feature.mining.scavengedOverlayScale, this.getLines());
        int x = Config.feature.mining.scavengedOverlayPos.getAbsX(sr, width);
        int y = Config.feature.mining.scavengedOverlayPos.getAbsY(sr, height);
        this.draw((float)x - (float)width / 2.0f, (float)y - (float)height / 2.0f, Config.feature.mining.scavengedOverlayScale, Config.feature.mining.miningOverlayBackgroundColor);
    }
}

