/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.treasure;

import java.awt.Color;
import net.minecraft.block.BlockChest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.BlockPos;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.treasure.GridTrilateration;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.treasure.TreasureTriangulator;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.Logger;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Area;
import org.ginafro.notenoughfakepixel.variables.Location;

@RegisterEvents
public class CrystalHollowsTreasureModule {
    private static final TreasureTriangulator TRI = TreasureTriangulator.getInstance();

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent e) {
        if (!Config.feature.mining.crysalMetalDetector) {
            return;
        }
        if (ScoreboardUtils.currentArea != Area.CH_MINES_OF_DIVAN) {
            return;
        }
        String msg = e.message.func_150254_d();
        if (msg.contains("TREASURE: ")) {
            try {
                String distanceStr = msg.split("TREASURE: ")[1].split("m")[0].replaceAll("[^0-9.]", "");
                double distance = Double.parseDouble(distanceStr);
                EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
                TRI.handleData(p.field_70165_t, p.field_70163_u, p.field_70161_v, distance);
            }
            catch (Exception ex) {
                Logger.log("\u00a7cMetal Detector: parse parser failed");
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload e) {
        if (!Config.feature.mining.crysalMetalDetector) {
            return;
        }
        TRI.reset();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (!Config.feature.mining.crysalMetalDetector) {
            return;
        }
        if (TablistParser.currentLocation.equals((Object)Location.CRYSTAL_HOLLOWS)) {
            TRI.reset();
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent e) {
        if (!Config.feature.mining.crysalMetalDetector) {
            return;
        }
        if (!TablistParser.currentLocation.equals((Object)Location.CRYSTAL_HOLLOWS)) {
            return;
        }
        if (e.action.equals((Object)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && e.world.func_180495_p(e.pos).func_177230_c() instanceof BlockChest) {
            TRI.reset();
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!Config.feature.mining.crysalMetalDetector) {
            return;
        }
        if (ScoreboardUtils.currentArea != Area.CH_MINES_OF_DIVAN) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        GridTrilateration.Int3 guess = TRI.getBestGuess();
        if (guess != null) {
            EntityPlayerSP p = mc.field_71439_g;
            Color waypointColor = ColorUtils.getColor(Config.feature.mining.crystalDivanWaypointColor);
            RenderUtils.renderBeaconBeam(new BlockPos((double)guess.x, p.field_70163_u, (double)guess.z), waypointColor.getRGB(), 1.0f, event.partialTicks);
            RenderUtils.renderWaypointText("Guess", new BlockPos((double)guess.x, p.field_70163_u + 3.0, (double)guess.z), event.partialTicks);
        }
    }
}

