/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.treasure;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;

public final class GridTrilateration {
    public static Result estimate(List<Sample> samples, double epsilon) {
        return GridTrilateration.estimate(samples, epsilon, (int)Math.ceil(Math.max(2.0, epsilon)), 2000000);
    }

    public static Result estimate(List<Sample> samples, double epsilon, int extraPad, int maxVolume) {
        Iterable candidates;
        if (samples == null || samples.size() < 3) {
            throw new IllegalArgumentException("Need at least 3 samples; 4+ non-coplanar is recommended.");
        }
        final double[] p0 = GridTrilateration.lsqGuess(samples);
        final int[] box = GridTrilateration.intersectedAABB(samples, epsilon);
        GridTrilateration.expandBox(box, extraPad);
        long volume = (long)(box[3] - box[0] + 1) * (long)(box[4] - box[1] + 1) * (long)(box[5] - box[2] + 1);
        if (volume <= (long)maxVolume) {
            candidates = () -> new Iterator<Int3>(){
                int x;
                int y;
                int z;
                {
                    this.x = box[0];
                    this.y = box[1];
                    this.z = box[2];
                }

                @Override
                public boolean hasNext() {
                    return this.x <= box[3];
                }

                @Override
                public Int3 next() {
                    Int3 out = new Int3(this.x, this.y, this.z);
                    if (++this.z > box[5]) {
                        this.z = box[2];
                        if (++this.y > box[4]) {
                            this.y = box[1];
                            ++this.x;
                        }
                    }
                    return out;
                }
            };
        } else {
            final int cx = (int)Math.round(p0[0]);
            final int cy = (int)Math.round(p0[1]);
            final int cz = (int)Math.round(p0[2]);
            double worstResidual = GridTrilateration.worstResidual(samples, p0);
            final int r = (int)Math.ceil(Math.max(2.0 * epsilon, worstResidual + epsilon));
            candidates = () -> new Iterator(){
                final int minX;
                final int maxX;
                final int minY;
                final int maxY;
                final int minZ;
                final int maxZ;
                int x;
                int y;
                int z;
                {
                    this.minX = Math.max(box[0], cx - r);
                    this.maxX = Math.min(box[3], cx + r);
                    this.minY = Math.max(box[1], cy - r);
                    this.maxY = Math.min(box[4], cy + r);
                    this.minZ = Math.max(box[2], cz - r);
                    this.maxZ = Math.min(box[5], cz + r);
                    this.x = this.minX;
                    this.y = this.minY;
                    this.z = this.minZ;
                }

                @Override
                public boolean hasNext() {
                    return this.x <= this.maxX;
                }

                public Int3 next() {
                    double dz;
                    double dy;
                    Int3 out;
                    double dx;
                    do {
                        out = new Int3(this.x, this.y, this.z);
                        if (++this.z <= this.maxZ) continue;
                        this.z = this.minZ;
                        if (++this.y <= this.maxY) continue;
                        this.y = this.minY;
                        ++this.x;
                        if (this.x <= this.maxX) continue;
                        return out;
                    } while (!((dx = (double)out.x - p0[0]) * dx + (dy = (double)out.y - p0[1]) * dy + (dz = (double)out.z - p0[2]) * dz <= (double)r * (double)r));
                    return out;
                }
            };
        }
        Int3 best = null;
        Int3 second = null;
        double bestScore = Double.POSITIVE_INFINITY;
        double secondScore = Double.POSITIVE_INFINITY;
        for (Int3 c : candidates) {
            double s = 0.0;
            for (Sample smp : samples) {
                double dx = (double)c.x - smp.ox;
                double dy = (double)c.y - smp.oy;
                double dz = (double)c.z - smp.oz;
                double resid = Math.abs(Math.sqrt(dx * dx + dy * dy + dz * dz) - smp.d);
                double n = resid / epsilon;
                if (!((s += n * n) >= secondScore)) continue;
                break;
            }
            if (s < bestScore) {
                secondScore = bestScore;
                second = best;
                bestScore = s;
                best = c;
                continue;
            }
            if (!(s < secondScore)) continue;
            secondScore = s;
            second = c;
        }
        double gap = second == null ? Double.POSITIVE_INFINITY : secondScore - bestScore;
        return new Result(best, bestScore, gap);
    }

    private static double[] lsqGuess(List<Sample> samples) {
        Sample r = samples.get(0);
        int m = samples.size() - 1;
        double a00 = 0.0;
        double a01 = 0.0;
        double a02 = 0.0;
        double a11 = 0.0;
        double a12 = 0.0;
        double a22 = 0.0;
        double v0 = 0.0;
        double v1 = 0.0;
        double v2 = 0.0;
        for (int i = 1; i < samples.size(); ++i) {
            Sample s = samples.get(i);
            double rx = s.ox - r.ox;
            double ry = s.oy - r.oy;
            double rz = s.oz - r.oz;
            double bi = s.ox * s.ox + s.oy * s.oy + s.oz * s.oz - s.d * s.d - (r.ox * r.ox + r.oy * r.oy + r.oz * r.oz - r.d * r.d);
            double ax = 2.0 * rx;
            double ay = 2.0 * ry;
            double az = 2.0 * rz;
            a00 += ax * ax;
            a01 += ax * ay;
            a02 += ax * az;
            a11 += ay * ay;
            a12 += ay * az;
            a22 += az * az;
            v0 += ax * bi;
            v1 += ay * bi;
            v2 += az * bi;
        }
        double[][] A = new double[][]{{a00, a01, a02}, {a01, a11, a12}, {a02, a12, a22}};
        double[] b = new double[]{v0, v1, v2};
        return GridTrilateration.solve3x3(A, b);
    }

    private static double[] solve3x3(double[][] A, double[] b) {
        int[] piv = new int[]{0, 1, 2};
        for (int k = 0; k < 3; ++k) {
            int max = k;
            double maxVal = Math.abs(A[piv[k]][k]);
            for (int i = k + 1; i < 3; ++i) {
                double v = Math.abs(A[piv[i]][k]);
                if (!(v > maxVal)) continue;
                max = i;
                maxVal = v;
            }
            int tmp = piv[k];
            piv[k] = piv[max];
            piv[max] = tmp;
            int r = piv[k];
            double pivot = A[r][k];
            if (Math.abs(pivot) < 1.0E-12) {
                return new double[]{0.0, 0.0, 0.0};
            }
            int j = k;
            while (j < 3) {
                double[] dArray = A[r];
                int n = j++;
                dArray[n] = dArray[n] / pivot;
            }
            int n = r;
            b[n] = b[n] / pivot;
            for (int i = 0; i < 3; ++i) {
                double f;
                if (i == r || (f = A[i][k]) == 0.0) continue;
                for (int j2 = k; j2 < 3; ++j2) {
                    double[] dArray = A[i];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] - f * A[r][j2];
                }
                int n3 = i;
                b[n3] = b[n3] - f * b[r];
            }
        }
        double[] x = new double[3];
        for (int i = 0; i < 3; ++i) {
            x[i] = b[i];
        }
        return x;
    }

    private static int[] intersectedAABB(List<Sample> samples, double epsilon) {
        double R;
        int minX = -536870912;
        int minY = -536870912;
        int minZ = -536870912;
        int maxX = 0x1FFFFFFF;
        int maxY = 0x1FFFFFFF;
        int maxZ = 0x1FFFFFFF;
        for (Sample s : samples) {
            R = s.d + epsilon;
            int sxMin = (int)Math.floor(s.ox - R);
            int sxMax = (int)Math.ceil(s.ox + R);
            int syMin = (int)Math.floor(s.oy - R);
            int syMax = (int)Math.ceil(s.oy + R);
            int szMin = (int)Math.floor(s.oz - R);
            int szMax = (int)Math.ceil(s.oz + R);
            minX = Math.max(minX, sxMin);
            maxX = Math.min(maxX, sxMax);
            minY = Math.max(minY, syMin);
            maxY = Math.min(maxY, syMax);
            minZ = Math.max(minZ, szMin);
            maxZ = Math.min(maxZ, szMax);
        }
        if (minX > maxX || minY > maxY || minZ > maxZ) {
            minZ = 0x1FFFFFFF;
            minY = 0x1FFFFFFF;
            minX = 0x1FFFFFFF;
            maxZ = -536870912;
            maxY = -536870912;
            maxX = -536870912;
            for (Sample s : samples) {
                R = s.d + epsilon;
                minX = Math.min(minX, (int)Math.floor(s.ox - R));
                maxX = Math.max(maxX, (int)Math.ceil(s.ox + R));
                minY = Math.min(minY, (int)Math.floor(s.oy - R));
                maxY = Math.max(maxY, (int)Math.ceil(s.oy + R));
                minZ = Math.min(minZ, (int)Math.floor(s.oz - R));
                maxZ = Math.max(maxZ, (int)Math.ceil(s.oz + R));
            }
        }
        return new int[]{minX, minY, minZ, maxX, maxY, maxZ};
    }

    private static void expandBox(int[] box, int pad) {
        box[0] = box[0] - pad;
        box[1] = box[1] - pad;
        box[2] = box[2] - pad;
        box[3] = box[3] + pad;
        box[4] = box[4] + pad;
        box[5] = box[5] + pad;
    }

    private static double worstResidual(List<Sample> samples, double[] p) {
        double w = 0.0;
        for (Sample s : samples) {
            double dx = p[0] - s.ox;
            double dy = p[1] - s.oy;
            double dz = p[2] - s.oz;
            double resid = Math.abs(Math.sqrt(dx * dx + dy * dy + dz * dz) - s.d);
            if (!(resid > w)) continue;
            w = resid;
        }
        return w;
    }

    public static Sample fromBlockPos(BlockPos pos, double d) {
        return new Sample(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), d);
    }

    public static Sample fromVector(Vec3 v, double d) {
        return new Sample(v.field_72450_a, v.field_72448_b, v.field_72449_c, d);
    }

    public static final class Result {
        public final Int3 best;
        public final double score;
        public final double gapToNext;

        public Result(Int3 best, double score, double gapToNext) {
            this.best = best;
            this.score = score;
            this.gapToNext = gapToNext;
        }

        public String toString() {
            return this.best + "  score=" + String.format(Locale.US, "%.3f", this.score) + "  gapToNext=" + String.format(Locale.US, "%.3f", this.gapToNext);
        }
    }

    public static final class Int3 {
        public final int x;
        public final int y;
        public final int z;

        public Int3(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public String toString() {
            return "Int3(" + this.x + "," + this.y + "," + this.z + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof Int3)) {
                return false;
            }
            Int3 i = (Int3)o;
            return this.x == i.x && this.y == i.y && this.z == i.z;
        }

        public int hashCode() {
            return this.x * 73856093 ^ this.y * 19349663 ^ this.z * 83492791;
        }
    }

    public static final class Sample {
        public final double ox;
        public final double oy;
        public final double oz;
        public final double d;

        public Sample(double ox, double oy, double oz, double d) {
            this.ox = ox;
            this.oy = oy;
            this.oz = oz;
            this.d = d;
        }
    }
}

