/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.treasure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.treasure.GridTrilateration;

public final class TreasureTriangulator {
    private volatile double epsilon = 4.0;
    private volatile int maxSamples = 24;
    private volatile int minSamples = 4;
    private volatile double minPlayerDelta = 0.9;
    private volatile long estimateCooldownMs = 250L;
    private volatile double pruneK = 2.5;
    private volatile int maxVolume = 200000;
    private final RingBuffer samples;
    private final ReentrantLock samplesLock = new ReentrantLock();
    private volatile GridTrilateration.Result lastResult;
    private volatile long lastEstimateAt = 0L;
    private double lastX = Double.NaN;
    private double lastY = Double.NaN;
    private double lastZ = Double.NaN;
    private double lastD = Double.NaN;
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> scheduledTask;
    private static final TreasureTriangulator INSTANCE = new TreasureTriangulator();

    public static TreasureTriangulator getInstance() {
        return INSTANCE;
    }

    private TreasureTriangulator() {
        this.samples = new RingBuffer(64);
        this.executor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "NEF-TreasureWorker");
            t.setDaemon(true);
            t.setPriority(4);
            return t;
        });
        this.startWorker();
    }

    private void startWorker() {
        this.stopWorker();
        long period = Math.max(this.estimateCooldownMs, 50L);
        this.scheduledTask = this.executor.scheduleAtFixedRate(this::tryEstimateOnWorker, period, period, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.stopWorker();
        this.executor.shutdownNow();
    }

    private void stopWorker() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
            this.scheduledTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleData(double playerX, double playerY, double playerZ, double distance) {
        if (!this.shouldAccept(playerX, playerY, playerZ, distance)) {
            return;
        }
        this.samplesLock.lock();
        try {
            this.samples.add(new GridTrilateration.Sample(playerX, playerY, playerZ, distance));
            while (this.samples.size() > this.maxSamples) {
                this.samples.poll();
            }
        }
        finally {
            this.samplesLock.unlock();
        }
    }

    private void tryEstimateOnWorker() {
        GridTrilateration.Sample[] snap;
        this.samplesLock.lock();
        try {
            int n = this.samples.size();
            if (n < this.minSamples) {
                return;
            }
            snap = this.samples.toArray(new GridTrilateration.Sample[n]);
        }
        finally {
            this.samplesLock.unlock();
        }
        long now = System.currentTimeMillis();
        if (now - this.lastEstimateAt < this.estimateCooldownMs) {
            return;
        }
        this.lastEstimateAt = now;
        ArrayList<GridTrilateration.Sample> buf = new ArrayList<GridTrilateration.Sample>(snap.length);
        Collections.addAll(buf, snap);
        GridTrilateration.Result r = TreasureTriangulator.safeEstimateWithCap(buf, this.epsilon, this.maxVolume);
        if (r != null && buf.size() > this.minSamples) {
            GridTrilateration.Result r2;
            GridTrilateration.Int3 p = r.best;
            double thr = this.pruneK * this.epsilon;
            boolean removed = false;
            Iterator<GridTrilateration.Sample> it = buf.iterator();
            while (it.hasNext()) {
                GridTrilateration.Sample s = it.next();
                double resid = TreasureTriangulator.residual(p.x, p.y, p.z, s);
                if (!(resid > thr)) continue;
                it.remove();
                removed = true;
            }
            if (removed && buf.size() >= this.minSamples && (r2 = TreasureTriangulator.safeEstimateWithCap(buf, this.epsilon, this.maxVolume)) != null) {
                r = r2;
            }
        }
        if (r != null) {
            this.lastResult = r;
        }
    }

    public GridTrilateration.Int3 getBestGuess() {
        return this.lastResult == null ? null : this.lastResult.best;
    }

    public double getConfidence() {
        if (this.lastResult == null) {
            return 0.0;
        }
        double c = this.lastResult.gapToNext / (1.0 + this.lastResult.score);
        if (c < 0.0) {
            c = 0.0;
        } else if (c > 1.0) {
            c = 1.0;
        }
        return c;
    }

    public String getDebugString() {
        if (this.lastResult == null) {
            return "Triangulation: getting samples...";
        }
        return "Triangulation: " + this.lastResult.toString() + "  conf=" + String.format(Locale.US, "%.2f", this.getConfidence());
    }

    public void reset() {
        this.samplesLock.lock();
        try {
            this.samples.clear();
        }
        finally {
            this.samplesLock.unlock();
        }
        this.lastResult = null;
        this.lastD = Double.NaN;
        this.lastZ = Double.NaN;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
        this.lastEstimateAt = 0L;
    }

    private static GridTrilateration.Result safeEstimateWithCap(List<GridTrilateration.Sample> list, double eps, int cap) {
        try {
            return GridTrilateration.estimate(list, eps, (int)Math.ceil(Math.max(2.0, eps)), cap);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static double residual(int x, int y, int z, GridTrilateration.Sample s) {
        double dx = (double)x - s.ox;
        double dy = (double)y - s.oy;
        double dz = (double)z - s.oz;
        return Math.abs(Math.sqrt(dx * dx + dy * dy + dz * dz) - s.d);
    }

    private boolean shouldAccept(double x, double y, double z, double d) {
        if (Double.isNaN(this.lastX)) {
            this.lastX = x;
            this.lastY = y;
            this.lastZ = z;
            this.lastD = d;
            return true;
        }
        double dx = x - this.lastX;
        double dy = y - this.lastY;
        double dz = z - this.lastZ;
        double move2 = dx * dx + dy * dy + dz * dz;
        double distDelta = Math.abs(d - this.lastD);
        if (move2 >= this.minPlayerDelta * this.minPlayerDelta || distDelta >= 0.75) {
            this.lastX = x;
            this.lastY = y;
            this.lastZ = z;
            this.lastD = d;
            return true;
        }
        return false;
    }

    private static final class RingBuffer {
        private GridTrilateration.Sample[] a;
        private int head = 0;
        private int tail = 0;
        private int size = 0;

        RingBuffer(int cap) {
            this.a = new GridTrilateration.Sample[cap];
        }

        int size() {
            return this.size;
        }

        void clear() {
            this.size = 0;
            this.tail = 0;
            this.head = 0;
        }

        void add(GridTrilateration.Sample s) {
            if (this.size == this.a.length) {
                this.grow();
            }
            this.a[this.tail] = s;
            this.tail = (this.tail + 1) % this.a.length;
            ++this.size;
        }

        GridTrilateration.Sample poll() {
            if (this.size == 0) {
                return null;
            }
            GridTrilateration.Sample s = this.a[this.head];
            this.a[this.head] = null;
            this.head = (this.head + 1) % this.a.length;
            --this.size;
            return s;
        }

        GridTrilateration.Sample[] toArray(GridTrilateration.Sample[] out) {
            int n = this.size;
            int i = 0;
            int idx = this.head;
            while (i < n) {
                out[i++] = this.a[idx];
                idx = (idx + 1) % this.a.length;
            }
            return out;
        }

        GridTrilateration.Sample[] toArray() {
            GridTrilateration.Sample[] out = new GridTrilateration.Sample[this.size];
            return this.toArray(out);
        }

        private void grow() {
            int n = this.a.length;
            int m = n << 1;
            GridTrilateration.Sample[] b = new GridTrilateration.Sample[m];
            this.toArray(b);
            this.a = b;
            this.head = 0;
            this.tail = this.size;
        }
    }
}

