/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints;

import java.util.UUID;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;

public class ChWaypoint {
    public final double x;
    public final double y;
    public final double z;
    public final String id;
    public final String name;
    private Boolean temporary;
    private Integer colorRgb;
    public Boolean toggled;

    public static ChWaypoint of(double x, double y, double z, String name) {
        return new ChWaypoint(x, y, z, UUID.randomUUID().toString(), name, Boolean.FALSE, null, Boolean.TRUE);
    }

    public static ChWaypoint ofTemp(double x, double y, double z, String name, boolean temporary) {
        return new ChWaypoint(x, y, z, UUID.randomUUID().toString(), name, temporary, null, Boolean.TRUE);
    }

    public boolean isTemporarySafe() {
        return this.temporary == null || this.temporary != false;
    }

    public boolean isToggledSafe() {
        return this.toggled == null || this.toggled != false;
    }

    public int getColorRgbOrDefault() {
        Integer c = this.colorRgb;
        if (c != null) {
            return c;
        }
        return ColorUtils.getColor(Config.feature.mining.crystalWaypointColor).getRGB();
    }

    public void setColorRgb(int rgb) {
        this.colorRgb = rgb;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getTemporary() {
        return this.temporary;
    }

    public Integer getColorRgb() {
        return this.colorRgb;
    }

    public Boolean getToggled() {
        return this.toggled;
    }

    public void setTemporary(Boolean temporary) {
        this.temporary = temporary;
    }

    public void setToggled(Boolean toggled) {
        this.toggled = toggled;
    }

    public ChWaypoint(double x, double y, double z, String id, String name, Boolean temporary, Integer colorRgb, Boolean toggled) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.id = id;
        this.name = name;
        this.temporary = temporary;
        this.colorRgb = colorRgb;
        this.toggled = toggled;
    }

    public ChWaypoint() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.id = null;
        this.name = null;
    }
}

