/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.UUID;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.ChWaypoint;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;

public final class ChWaypointAdapter
implements JsonDeserializer<ChWaypoint>,
JsonSerializer<ChWaypoint> {
    public ChWaypoint deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
        JsonObject o = json.getAsJsonObject();
        double x = ChWaypointAdapter.getAsDouble(o, "x", 0.0);
        double y = ChWaypointAdapter.getAsDouble(o, "y", 0.0);
        double z = ChWaypointAdapter.getAsDouble(o, "z", 0.0);
        String id = ChWaypointAdapter.getAsString(o, "id", UUID.randomUUID().toString());
        String name = ChWaypointAdapter.getAsString(o, "name", "Waypoint");
        Boolean temporary = o.has("temporary") ? o.get("temporary").getAsBoolean() : Boolean.FALSE.booleanValue();
        Integer colorRgb = o.has("colorRgb") ? o.get("colorRgb").getAsInt() : ColorUtils.getColor(Config.feature.mining.crystalWaypointColor).getRGB();
        Boolean toggled = o.has("toggled") ? o.get("toggled").getAsBoolean() : Boolean.TRUE.booleanValue();
        return new ChWaypoint(x, y, z, id, name, temporary, colorRgb, toggled);
    }

    public JsonElement serialize(ChWaypoint src, Type typeOfSrc, JsonSerializationContext ctx) {
        JsonObject o = new JsonObject();
        o.addProperty("x", (Number)src.getX());
        o.addProperty("y", (Number)src.getY());
        o.addProperty("z", (Number)src.getZ());
        o.addProperty("id", src.getId());
        o.addProperty("name", src.getName());
        o.addProperty("temporary", Boolean.valueOf(src.isTemporarySafe()));
        o.addProperty("colorRgb", (Number)src.getColorRgbOrDefault());
        return o;
    }

    private static double getAsDouble(JsonObject o, String k, double def) {
        return o.has(k) ? o.get(k).getAsDouble() : def;
    }

    private static String getAsString(JsonObject o, String k, String def) {
        return o.has(k) ? o.get(k).getAsString() : def;
    }
}

