/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints;

import java.awt.Color;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.config.gui.core.util.StringUtils;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.ChWaypoint;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.CrystalWaypoints;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.NumberUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Location;

@RegisterEvents
public class ChWaypointEvents {
    private static final Pattern CHW_PAYLOAD = Pattern.compile("\\bCHW\\s*:\\s*([^:]+)\\s*:\\s*([-+]?\\d+(?:[\\.,]\\d+)?)\\s*:\\s*([-+]?\\d+(?:[\\.,]\\d+)?)\\s*:\\s*([-+]?\\d+(?:[\\.,]\\d+)?)", 2);
    private static final Pattern CHW_STRICT = Pattern.compile("^(?:\\[[^\\]]+\\]\\s*)?[A-Za-z0-9_]{1,16}:\\s*CHW\\s*:\\s*([^:]+)\\s*:\\s*([-+]?\\d+(?:[\\.,]\\d+)?)\\s*:\\s*([-+]?\\d+(?:[\\.,]\\d+)?)\\s*:\\s*([-+]?\\d+(?:[\\.,]\\d+)?)$", 2);

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload e) {
        CrystalWaypoints.getInstance().saveIfDirty();
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        CrystalWaypoints.getInstance().saveIfDirty();
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!TablistParser.currentLocation.equals((Object)Location.CRYSTAL_HOLLOWS) || !Config.feature.mining.crystalWaypoints) {
            return;
        }
        if (Config.feature.mining.crystalWaypointsBeacons) {
            Color color = ColorUtils.getColor(Config.feature.mining.crystalWaypointColor);
            for (ChWaypoint waypoint : CrystalWaypoints.getInstance().getAll()) {
                if (Boolean.FALSE.equals(waypoint.toggled)) continue;
                RenderUtils.renderBeaconBeam(new BlockPos(waypoint.x, waypoint.y, waypoint.z), color.getRGB(), 1.0f, event.partialTicks);
            }
        }
        if (Config.feature.mining.crystalWaypointsNames) {
            for (ChWaypoint waypoint : CrystalWaypoints.getInstance().getAll()) {
                if (Boolean.FALSE.equals(waypoint.toggled)) continue;
                RenderUtils.renderWaypointText(waypoint.getName(), new BlockPos(waypoint.x, waypoint.y + 3.0, waypoint.z), event.partialTicks);
            }
        }
    }

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent event) {
        try {
            if (event.message.func_150260_c().contains("[ADD]")) {
                return;
            }
            String raw = StringUtils.clean(event.message.func_150260_c());
            Matcher m = CHW_PAYLOAD.matcher(raw);
            if (!m.find()) {
                return;
            }
            String name = m.group(1).trim();
            String sx = m.group(2);
            String sy = m.group(3);
            String sz = m.group(4);
            double x = NumberUtils.parseDoubleFlexible(sx);
            double y = NumberUtils.parseDoubleFlexible(sy);
            double z = NumberUtils.parseDoubleFlexible(sz);
            String cmdAdd = String.format(Locale.ROOT, "/chw add %s %.3f %.3f %.3f", name, x, y, z);
            ChatComponentText space = new ChatComponentText(" ");
            ChatComponentText add = new ChatComponentText("[ADD]");
            add.func_150256_b().func_150238_a(EnumChatFormatting.AQUA).func_150227_a(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmdAdd)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("Add Waypoint")));
            event.message.func_150257_a((IChatComponent)space);
            event.message.func_150257_a((IChatComponent)add);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

