/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.ginafro.notenoughfakepixel.config.gui.commands.SimpleCommand;
import org.ginafro.notenoughfakepixel.config.gui.core.util.StringUtils;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterCommand;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.ChWaypoint;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.CrystalWaypoints;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.WaypointChatMessages;
import org.ginafro.notenoughfakepixel.utils.NumberUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Location;

@RegisterCommand
public class CrystalWaypointCommand
extends SimpleCommand {
    private final String PREFIX = "\u00a76[\u00a7eChWaypoints\u00a76] \u00a7r";

    @Override
    public String getName() {
        return "chw";
    }

    @Override
    public String getUsage() {
        return "/chw new <name>";
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        this.func_71515_b(sender, args);
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (!TablistParser.currentLocation.equals((Object)Location.CRYSTAL_HOLLOWS)) {
            throw new WrongUsageException("You can only use waypoints in Crystal Hollows", new Object[0]);
        }
        if (args.length >= 1 && "new".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("Usage: " + this.func_71518_a(sender), new Object[0]);
            }
            String name = StringUtils.joinStrings(args, 1);
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g == null) {
                throw new CommandException("You are not online", new Object[0]);
            }
            double x = mc.field_71439_g.field_70165_t;
            double y = mc.field_71439_g.field_70163_u;
            double z = mc.field_71439_g.field_70161_v;
            ChWaypoint wp = ChWaypoint.of(x, y, z, name);
            CrystalWaypoints.getInstance().addWaypoint(wp);
            CrystalWaypointCommand.notify(sender, "\u00a76[\u00a7eChWaypoints\u00a76] \u00a7r\u00a7aWaypoint created: \u00a7c%s \u00a77(\u00a7c%.1f\u00a77, \u00a7a%.1f\u00a77, \u00a79%.1f\u00a77)", name, x, y, z);
            return;
        }
        if (args.length >= 1 && "list".equalsIgnoreCase(args[0])) {
            List<ChWaypoint> list = CrystalWaypoints.getInstance().getAll();
            if (list.isEmpty()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a76[\u00a7eChWaypoints\u00a76] \u00a7r\u00a77No waypoints yet."));
            } else {
                for (ChWaypoint w : list) {
                    WaypointChatMessages.sendWaypointLine(sender, w);
                }
            }
            return;
        }
        if (args.length >= 1 && "del".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("Usage: /chw del <id>", new Object[0]);
            }
            boolean ok = CrystalWaypoints.getInstance().removeById(args[1]);
            CrystalWaypointCommand.notify(sender, ok ? "Deleted." : "ID not found.", new Object[0]);
            return;
        }
        if ("copy".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("Usage: /chw copy <id>", new Object[0]);
            }
            ChWaypoint w = CrystalWaypoints.getInstance().findById(args[1]);
            if (w == null) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a76[\u00a7eChWaypoints\u00a76] \u00a7r\u00a77ID not found."));
                return;
            }
            String coords = WaypointChatMessages.formatCoordsEs(w);
            GuiScreen.func_146275_d((String)coords);
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a76[\u00a7eChWaypoints\u00a76] \u00a7r\u00a7aCopied to clipboard: \u00a7f" + coords));
            return;
        }
        if ("share".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("Usage: /chw share <id>", new Object[0]);
            }
            ChWaypoint w = CrystalWaypoints.getInstance().findById(args[1]);
            if (w == null) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a76[\u00a7eChWaypoints\u00a76] \u00a7r\u00a7cID not found."));
                return;
            }
            String msgToShare = String.format("CHW:%s:%.1f:%.1f:%.1f", w.getName(), w.x, w.y, w.z);
            if (sender instanceof EntityPlayerSP) {
                ((EntityPlayerSP)sender).func_71165_d(msgToShare);
            }
            return;
        }
        if ("add".equalsIgnoreCase(args[0])) {
            if (args.length < 5) {
                throw new WrongUsageException("Usage: /chw add <name...> <x> <y> <z>", new Object[0]);
            }
            int n = args.length;
            String sx = args[n - 3];
            String sy = args[n - 2];
            String sz = args[n - 1];
            String name = StringUtils.joinRange(args, 1, n - 3);
            double x = NumberUtils.parseDoubleFlexible(sx);
            double y = NumberUtils.parseDoubleFlexible(sy);
            double z = NumberUtils.parseDoubleFlexible(sz);
            ChWaypoint wp = ChWaypoint.of(x, y, z, name);
            wp.setTemporary(true);
            CrystalWaypoints.getInstance().addWaypoint(wp);
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7aWaypoint added from chat: \u00a7e" + name + " \u00a77(" + WaypointChatMessages.formatCoordsEs(x, y, z) + ")"));
            return;
        }
        if ("copycoords".equalsIgnoreCase(args[0])) {
            if (args.length < 4) {
                throw new WrongUsageException("Uso: /chw copycoords <x> <y> <z>", new Object[0]);
            }
            String sx = args[1].replace('.', ',');
            String sy = args[2].replace('.', ',');
            String sz = args[3].replace('.', ',');
            String text = "x" + sx + ", y" + sy + ", z" + sz;
            GuiScreen.func_146275_d((String)text);
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7aCopiado al portapapeles: \u00a7f" + text));
            return;
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    @Override
    public List<String> func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> cmds = new ArrayList<String>();
        if (args.length == 1) {
            cmds.add("new");
            cmds.add("list");
            cmds.add("add");
        }
        return cmds;
    }

    public static void notify(ICommandSender sender, String format, Object ... args) {
        String msg = String.format(format, args);
        sender.func_145747_a((IChatComponent)new ChatComponentText(msg));
    }
}

