/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.ChWaypoint;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.ChWaypointAdapter;

public class CrystalWaypoints {
    private static final CrystalWaypoints INSTANCE = new CrystalWaypoints();
    private final List<ChWaypoint> waypoints = new ArrayList<ChWaypoint>(128);
    private final Gson gson = new GsonBuilder().registerTypeAdapter(ChWaypoint.class, (Object)new ChWaypointAdapter()).setPrettyPrinting().create();
    private final AtomicBoolean dirty = new AtomicBoolean(false);
    private File file;

    private CrystalWaypoints() {
    }

    public static CrystalWaypoints getInstance() {
        return INSTANCE;
    }

    public void initFile() {
        if (this.file != null) {
            return;
        }
        File cfgDir = new File(Minecraft.func_71410_x().field_71412_D, "config");
        cfgDir.mkdirs();
        this.file = new File(cfgDir, "chwaypoints.json");
    }

    public synchronized void load() {
        this.initFile();
        this.waypoints.clear();
        boolean migrated = false;
        if (this.file.exists()) {
            try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));){
                Type listType = new TypeToken<List<ChWaypoint>>(){}.getType();
                List loaded = (List)this.gson.fromJson((Reader)r, listType);
                if (loaded != null) {
                    LinkedHashMap<String, ChWaypoint> map = new LinkedHashMap<String, ChWaypoint>(loaded.size() * 2);
                    for (ChWaypoint w : loaded) {
                        if (w == null) {
                            migrated = true;
                            continue;
                        }
                        String id = w.getId();
                        if (id == null || id.isEmpty()) {
                            w = new ChWaypoint(w.getX(), w.getY(), w.getZ(), UUID.randomUUID().toString(), w.getName() != null ? w.getName() : "Waypoint", w.isTemporarySafe(), w.getColorRgbOrDefault(), w.isToggledSafe());
                            migrated = true;
                        }
                        boolean needsRewrite = false;
                        Boolean tmp = w.isTemporarySafe();
                        int color = w.getColorRgbOrDefault();
                        if (w.getClass() == ChWaypoint.class) {
                            // empty if block
                        }
                        map.put(w.getId(), new ChWaypoint(w.getX(), w.getY(), w.getZ(), w.getId(), w.getName() != null ? w.getName() : "Waypoint", tmp, color, w.isToggledSafe()));
                        if (!needsRewrite) continue;
                        migrated = true;
                    }
                    this.waypoints.addAll(map.values());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dirty.set(migrated);
        if (migrated) {
            this.saveIfDirty();
        } else {
            this.dirty.set(false);
        }
    }

    public synchronized void addWaypoint(ChWaypoint wp) {
        this.waypoints.add(wp);
        this.dirty.set(true);
    }

    public synchronized List<ChWaypoint> getAll() {
        return Collections.unmodifiableList(new ArrayList<ChWaypoint>(this.waypoints));
    }

    public synchronized boolean removeById(String id) {
        boolean removed = this.waypoints.removeIf(w -> w.id.equalsIgnoreCase(id));
        if (removed) {
            this.dirty.set(true);
        }
        return removed;
    }

    public synchronized void saveIfDirty() {
        if (!this.dirty.get()) {
            return;
        }
        this.saveForce();
    }

    public synchronized void saveForce() {
        this.initFile();
        File tmp = new File(this.file.getParentFile(), this.file.getName() + ".tmp");
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(tmp.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), StandardCharsets.UTF_8));){
            this.gson.toJson(this.waypoints, (Appendable)w);
            ((Writer)w).flush();
            try {
                Files.move(tmp.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException ex) {
                Files.move(tmp.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.dirty.set(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                Files.deleteIfExists(tmp.toPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized ChWaypoint findById(String id) {
        for (ChWaypoint w : this.waypoints) {
            if (!w.getId().equalsIgnoreCase(id)) continue;
            return w;
        }
        return null;
    }

    public synchronized boolean updateWaypoint(ChWaypoint updated) {
        for (int i = 0; i < this.waypoints.size(); ++i) {
            ChWaypoint w = this.waypoints.get(i);
            if (!w.id.equalsIgnoreCase(updated.id)) continue;
            this.waypoints.set(i, updated);
            this.markDirty();
            return true;
        }
        return false;
    }

    public synchronized void removeAllTemp() {
        boolean removed = this.waypoints.removeIf(ChWaypoint::isTemporarySafe);
        if (removed) {
            this.dirty.set(true);
        }
    }

    public synchronized boolean hasTemp() {
        for (ChWaypoint w : this.waypoints) {
            if (!w.isTemporarySafe()) continue;
            return true;
        }
        return false;
    }

    public void markDirty() {
        this.dirty.set(true);
    }
}

