/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.ChWaypoint;

public final class WaypointChatMessages {
    private static final Locale ES = new Locale("es", "ES");
    private static final DecimalFormat DF;

    private WaypointChatMessages() {
    }

    public static String formatCoordsEs(ChWaypoint w) {
        return "x" + DF.format(w.x) + ", y" + DF.format(w.y) + ", z" + DF.format(w.z);
    }

    public static void sendWaypointLine(ICommandSender sender, ChWaypoint w) {
        String coords = WaypointChatMessages.formatCoordsEs(w);
        ChatComponentText root = new ChatComponentText("");
        ChatComponentText name = new ChatComponentText("- " + w.name + " ");
        name.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW).func_150227_a(Boolean.valueOf(true));
        root.func_150257_a((IChatComponent)name);
        ChatComponentText pos = new ChatComponentText("(" + coords + ") ");
        pos.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
        root.func_150257_a((IChatComponent)pos);
        ChatComponentText del = new ChatComponentText("[DELETE]");
        del.func_150256_b().func_150238_a(EnumChatFormatting.RED).func_150227_a(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/chw del " + w.id)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("Delete waypoint")));
        root.func_150257_a((IChatComponent)new ChatComponentText(" "));
        root.func_150257_a((IChatComponent)del);
        ChatComponentText copy = new ChatComponentText("[COPY]");
        copy.func_150256_b().func_150238_a(EnumChatFormatting.AQUA).func_150227_a(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/chw copy " + w.id)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("Copy coordinates to clipboard")));
        root.func_150257_a((IChatComponent)new ChatComponentText(" "));
        root.func_150257_a((IChatComponent)copy);
        ChatComponentText share = new ChatComponentText("[SHARE]");
        share.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW).func_150227_a(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/chw share " + w.id)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("Share coordinates in chat")));
        root.func_150257_a((IChatComponent)new ChatComponentText(" "));
        root.func_150257_a((IChatComponent)share);
        sender.func_145747_a((IChatComponent)root);
    }

    public static String formatCoordsEs(double x, double y, double z) {
        return "x" + DF.format(x) + ", y" + DF.format(y) + ", z" + DF.format(z);
    }

    static {
        DecimalFormatSymbols sym = new DecimalFormatSymbols(ES);
        DF = new DecimalFormat("0.0", sym);
    }
}

