/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.gui;

import java.io.IOException;
import java.util.Locale;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.ChWaypoint;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.CrystalWaypoints;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.lwjgl.input.Keyboard;

public class GuiWaypointCreate
extends GuiScreen {
    private GuiTextField nameField;
    private GuiTextField xField;
    private GuiTextField yField;
    private GuiTextField zField;
    private GuiButton btnSave;
    private GuiButton btnCancel;
    private GuiButton btnTemp;
    private GuiButton btnUsePos;
    private boolean temporary = false;
    private final ChWaypoint editing;
    private final boolean editMode;
    private String errorMsg = null;
    private long errorUntilMs = 0L;

    public GuiWaypointCreate() {
        this.editing = null;
        this.editMode = false;
    }

    public GuiWaypointCreate(ChWaypoint toEdit) {
        this.editing = toEdit;
        this.editMode = toEdit != null;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        int panelW = 320;
        int panelH = 160;
        int cx = this.field_146294_l / 2;
        int cy = this.field_146295_m / 2;
        int left = cx - panelW / 2;
        int top = cy - panelH / 2;
        this.field_146292_n.clear();
        this.nameField = new GuiTextField(0, this.field_146289_q, left + 90, top + 20, 200, 18);
        this.nameField.func_146203_f(48);
        this.xField = new GuiTextField(1, this.field_146289_q, left + 90, top + 63, 60, 18);
        this.yField = new GuiTextField(2, this.field_146289_q, left + 156, top + 63, 60, 18);
        this.zField = new GuiTextField(3, this.field_146289_q, left + 222, top + 63, 60, 18);
        if (this.editMode) {
            this.nameField.func_146180_a(this.editing.name);
            this.xField.func_146180_a(GuiWaypointCreate.fmt1(this.editing.x));
            this.yField.func_146180_a(GuiWaypointCreate.fmt1(this.editing.y));
            this.zField.func_146180_a(GuiWaypointCreate.fmt1(this.editing.z));
            this.temporary = this.readTemporary(this.editing);
        } else {
            EntityPlayerSP p = this.field_146297_k.field_71439_g;
            this.nameField.func_146180_a("");
            this.xField.func_146180_a(GuiWaypointCreate.fmt1(p != null ? p.field_70165_t : 0.0));
            this.yField.func_146180_a(GuiWaypointCreate.fmt1(p != null ? p.field_70163_u : 0.0));
            this.zField.func_146180_a(GuiWaypointCreate.fmt1(p != null ? p.field_70161_v : 0.0));
            this.temporary = false;
        }
        this.nameField.func_146195_b(true);
        this.btnTemp = new GuiButton(10, left + 90, top + 90, 90, 20, this.labelTemp());
        this.btnUsePos = new GuiButton(11, left + 186, top + 90, 104, 20, "Use my position");
        this.field_146292_n.add(this.btnTemp);
        if (!this.editMode) {
            this.field_146292_n.add(this.btnUsePos);
        }
        this.btnSave = new GuiButton(12, left + 30, top + 133, 90, 20, this.editMode ? "Update" : "Save");
        this.btnCancel = new GuiButton(13, left + 204, top + 133, 86, 20, "Cancel");
        this.field_146292_n.add(this.btnSave);
        this.field_146292_n.add(this.btnCancel);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 10: {
                this.temporary = !this.temporary;
                this.btnTemp.field_146126_j = this.labelTemp();
                break;
            }
            case 11: {
                EntityPlayerSP p = this.field_146297_k.field_71439_g;
                if (p == null) break;
                this.xField.func_146180_a(GuiWaypointCreate.fmt1(p.field_70165_t));
                this.yField.func_146180_a(GuiWaypointCreate.fmt1(p.field_70163_u));
                this.zField.func_146180_a(GuiWaypointCreate.fmt1(p.field_70161_v));
                break;
            }
            case 12: {
                this.doSave();
                break;
            }
            case 13: {
                this.field_146297_k.func_147108_a(null);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 15) {
            if (this.nameField.func_146206_l()) {
                this.nameField.func_146195_b(false);
                this.xField.func_146195_b(true);
            } else if (this.xField.func_146206_l()) {
                this.xField.func_146195_b(false);
                this.yField.func_146195_b(true);
            } else if (this.yField.func_146206_l()) {
                this.yField.func_146195_b(false);
                this.zField.func_146195_b(true);
            } else {
                this.zField.func_146195_b(false);
                this.nameField.func_146195_b(true);
            }
            return;
        }
        if (keyCode == 28 || keyCode == 156) {
            this.doSave();
            return;
        }
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        if (this.nameField.func_146206_l()) {
            this.nameField.func_146201_a(typedChar, keyCode);
        } else {
            if (this.xField.func_146206_l()) {
                this.numericKeyTyped(this.xField, typedChar, keyCode);
            }
            if (this.yField.func_146206_l()) {
                this.numericKeyTyped(this.yField, typedChar, keyCode);
            }
            if (this.zField.func_146206_l()) {
                this.numericKeyTyped(this.zField, typedChar, keyCode);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.nameField.func_146192_a(mouseX, mouseY, mouseButton);
        this.xField.func_146192_a(mouseX, mouseY, mouseButton);
        this.yField.func_146192_a(mouseX, mouseY, mouseButton);
        this.zField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1442840576, -1442840576);
        int panelW = 320;
        int panelH = 160;
        int cx = this.field_146294_l / 2;
        int cy = this.field_146295_m / 2;
        int left = cx - panelW / 2;
        int top = cy - panelH / 2;
        int right = left + panelW;
        int bottom = top + panelH;
        GuiWaypointCreate.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)0x66000000);
        this.func_73730_a(left, right, top, 0x33FFFFFF);
        this.func_73730_a(left, right, bottom, 0x33FFFFFF);
        this.func_73728_b(left, top, bottom, 0x33FFFFFF);
        this.func_73728_b(right, top, bottom, 0x33FFFFFF);
        String title = EnumChatFormatting.AQUA + "New Waypoint";
        this.func_73732_a(this.field_146289_q, title, cx, top - 12, 0xFFFFFF);
        this.field_146289_q.func_175065_a("Name:", (float)(left + 20), (float)(top + 24), 0xFFFFFF, false);
        this.field_146289_q.func_175065_a("X:", (float)(left + 120), (float)(top + 48), 0xFFFFFF, false);
        this.field_146289_q.func_175065_a("Y:", (float)(left + 156), (float)(top + 48), 0xFFFFFF, false);
        this.field_146289_q.func_175065_a("Z:", (float)(left + 222), (float)(top + 48), 0xFFFFFF, false);
        this.nameField.func_146194_f();
        this.xField.func_146194_f();
        this.yField.func_146194_f();
        this.zField.func_146194_f();
        if (this.errorMsg != null && System.currentTimeMillis() < this.errorUntilMs) {
            int w = this.field_146289_q.func_78256_a(this.errorMsg);
            GuiWaypointCreate.func_73734_a((int)(cx - w / 2 - 6), (int)(bottom + 6), (int)(cx + w / 2 + 6), (int)(bottom + 6 + 14), (int)-1434510565);
            this.func_73732_a(this.field_146289_q, this.errorMsg, cx, bottom + 8, 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void doSave() {
        String name = GuiWaypointCreate.sanitizeName(this.nameField.func_146179_b());
        if (name == null) {
            this.showError("Name required");
            return;
        }
        Double dx = GuiWaypointCreate.parseDoubleSafe(this.xField.func_146179_b());
        Double dy = GuiWaypointCreate.parseDoubleSafe(this.yField.func_146179_b());
        Double dz = GuiWaypointCreate.parseDoubleSafe(this.zField.func_146179_b());
        if (dx == null || dy == null || dz == null) {
            this.showError("Invalid coordinates");
            return;
        }
        if (this.editMode) {
            ChWaypoint updated = new ChWaypoint(dx, dy, dz, this.editing.id, name, this.temporary, this.editing.getColorRgbOrDefault(), this.editing.isToggledSafe());
            CrystalWaypoints.getInstance().updateWaypoint(updated);
            CrystalWaypoints.getInstance().saveIfDirty();
        } else {
            ChWaypoint wp = ChWaypoint.of(dx, dy, dz, name);
            CrystalWaypoints.getInstance().addWaypoint(wp);
            CrystalWaypoints.getInstance().saveIfDirty();
        }
        this.field_146297_k.func_147108_a(null);
    }

    private static String fmt1(double d) {
        return String.format(Locale.ROOT, "%.1f", d);
    }

    private static String sanitizeName(String raw) {
        if (raw == null) {
            return null;
        }
        String s = raw.trim();
        if (s.isEmpty()) {
            return null;
        }
        s = EnumChatFormatting.func_110646_a((String)s);
        return s.replace(':', ';');
    }

    private static Double parseDoubleSafe(String s) {
        try {
            return Double.parseDouble(s.replace(',', '.'));
        }
        catch (Exception e) {
            return null;
        }
    }

    private String labelTemp() {
        return this.temporary ? "Temp: \u00a7aON" : "Temp: \u00a7cOFF";
    }

    private boolean readTemporary(ChWaypoint wp) {
        try {
            return (Boolean)ChWaypoint.class.getMethod("isTemporarySafe", new Class[0]).invoke((Object)wp, new Object[0]);
        }
        catch (Exception ignore) {
            try {
                return (Boolean)ChWaypoint.class.getMethod("getTemporary", new Class[0]).invoke((Object)wp, new Object[0]);
            }
            catch (Exception ignore2) {
                return false;
            }
        }
    }

    private int getColorOrDefault(ChWaypoint wp) {
        try {
            return (Integer)ChWaypoint.class.getMethod("getColorRgbOrDefault", new Class[0]).invoke((Object)wp, new Object[0]);
        }
        catch (Exception ignore) {
            return ColorUtils.getColor(Config.feature.mining.crystalWaypointColor).getRGB();
        }
    }

    private void showError(String msg) {
        this.errorMsg = "\u00a7c" + msg;
        this.errorUntilMs = System.currentTimeMillis() + 2200L;
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("random.click"), (float)0.8f));
    }

    private static boolean isAllowedNumericChar(char c) {
        return c >= '0' && c <= '9' || c == '.' || c == '-' || c == '\u0000';
    }

    private void numericKeyTyped(GuiTextField tf, char typedChar, int keyCode) {
        if (keyCode == 14 || keyCode == 211 || keyCode == 203 || keyCode == 205 || keyCode == 199 || keyCode == 207) {
            tf.func_146201_a(typedChar, keyCode);
            return;
        }
        if (!GuiWaypointCreate.isAllowedNumericChar(typedChar)) {
            return;
        }
        if (typedChar == '.' && tf.func_146179_b().indexOf(46) >= 0) {
            return;
        }
        if (typedChar == '-' && (tf.func_146198_h() != 0 || tf.func_146179_b().indexOf(45) == 0)) {
            return;
        }
        tf.func_146201_a(typedChar, keyCode);
    }
}

