/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.gui;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumChatFormatting;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.ChWaypoint;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.CrystalWaypoints;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.gui.GuiWaypointCreate;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.gui.RowActions;
import org.lwjgl.input.Mouse;

public class GuiWaypointManager
extends GuiScreen
implements RowActions {
    private WaypointList list;
    private GuiButton closeBtn;
    private GuiButton removeTempsBtn;
    private GuiButton addNewBtn;
    private List<ChWaypoint> waypoints;

    public void func_73866_w_() {
        this.waypoints = CrystalWaypoints.getInstance().getAll();
        int panelW = 360;
        int top = 32;
        int bottom = this.field_146295_m - 40;
        int panelL = (this.field_146294_l - panelW) / 2;
        this.list = new WaypointList(this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 40, 20, this.waypoints, this);
        int cx = this.field_146294_l / 2;
        this.field_146292_n.clear();
        this.closeBtn = new GuiButton(0, cx - 40, bottom + 10, 80, 20, "Close");
        this.field_146292_n.add(this.closeBtn);
        this.removeTempsBtn = new GuiButton(1, 8, bottom + 10, 140, 20, "Remove all Temps");
        try {
            this.removeTempsBtn.field_146124_l = CrystalWaypoints.getInstance().hasTemp();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.field_146292_n.add(this.removeTempsBtn);
        this.addNewBtn = new GuiButton(2, this.field_146294_l - 8 - 140, bottom + 10, 140, 20, "Add New Waypoint");
        this.field_146292_n.add(this.addNewBtn);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a(null);
        }
        if (button.field_146127_k == 1) {
            CrystalWaypoints.getInstance().removeAllTemp();
            this.waypoints = CrystalWaypoints.getInstance().getAll();
            this.list.setData(this.waypoints);
            try {
                CrystalWaypoints.getInstance().markDirty();
            }
            catch (Throwable ignored) {
                CrystalWaypoints.getInstance().saveIfDirty();
            }
            try {
                this.removeTempsBtn.field_146124_l = CrystalWaypoints.getInstance().hasTemp();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if (button.field_146127_k == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiWaypointCreate());
            return;
        }
    }

    @Override
    public void onDelete(ChWaypoint wp) {
        if (CrystalWaypoints.getInstance().removeById(wp.getId())) {
            this.waypoints = CrystalWaypoints.getInstance().getAll();
            this.list.setData(this.waypoints);
            CrystalWaypoints.getInstance().saveIfDirty();
        }
    }

    @Override
    public void onShare(ChWaypoint wp) {
        if (wp == null) {
            return;
        }
        EntityPlayerSP p = this.field_146297_k.field_71439_g;
        if (p == null) {
            return;
        }
        String name = wp.getName() != null ? wp.getName() : "Waypoint";
        name = EnumChatFormatting.func_110646_a((String)name).replace(':', ';');
        String msgToShare = String.format(Locale.ROOT, "CHW:%s:%.1f:%.1f:%.1f", name, wp.x, wp.y, wp.z);
        p.func_71165_d(msgToShare);
    }

    @Override
    public void onEdit(ChWaypoint wp) {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiWaypointCreate(wp));
    }

    public void func_146281_b() {
        CrystalWaypoints.getInstance().saveIfDirty();
        super.func_146281_b();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.func_178039_p();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.list.func_148128_a(mouseX, mouseY, partialTicks);
        String title = EnumChatFormatting.AQUA + "Waypoints (" + this.waypoints.size() + ")";
        this.func_73732_a(this.field_146289_q, title, this.field_146294_l / 2, 12, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public static class WaypointList
    extends GuiSlot {
        private List<ChWaypoint> data;
        private final Minecraft mc;
        private final RowActions actions;
        private static final int LEFT_MARGIN = 6;
        private static final int CB_SIZE = 12;
        private static final int CB_GAP_TEXT = 6;
        private static final int BTN_H = 14;
        private static final int BTN_PAD_X = 4;
        private static final int BTN_GAP = 4;
        private static final int RIGHT_MARGIN = 8;
        private static final String LBL_DELETE = "Delete";
        private static final String LBL_SHARE = "Share";
        private static final String LBL_EDIT = "Edit";
        private final int rowH;
        private final int W_DELETE;
        private final int W_SHARE;
        private final int W_EDIT;
        private long lastClickMs = 0L;
        private int lastClickIndex = -1;

        public WaypointList(Minecraft mc, int w, int h, int top, int bottom, int slotHeight, List<ChWaypoint> data, RowActions actions) {
            super(mc, w, h, top, bottom, slotHeight);
            this.mc = mc;
            this.data = data;
            this.actions = actions;
            this.rowH = slotHeight;
            FontRenderer fr = mc.field_71466_p;
            this.W_DELETE = fr.func_78256_a(LBL_DELETE) + 8;
            this.W_SHARE = fr.func_78256_a(LBL_SHARE) + 8;
            this.W_EDIT = fr.func_78256_a(LBL_EDIT) + 8;
        }

        protected int func_148127_b() {
            return this.data.size();
        }

        protected void func_148123_a() {
        }

        protected boolean func_148131_a(int index) {
            return false;
        }

        protected void func_148144_a(int index, boolean doubleClick, int mouseX, int mouseY) {
            if (index < 0 || index >= this.data.size()) {
                return;
            }
            if (Mouse.getEventButton() != 0 || !Mouse.getEventButtonState()) {
                return;
            }
            if (doubleClick) {
                return;
            }
            long now = System.currentTimeMillis();
            if (index == this.lastClickIndex && now - this.lastClickMs < 120L) {
                return;
            }
            this.lastClickIndex = index;
            this.lastClickMs = now;
            ChWaypoint wp = this.data.get(index);
            BtnRect cb = this.rectCheckboxForIndex(index);
            if (cb.contains(mouseX, mouseY)) {
                wp.setToggled(wp.getToggled() == false);
                try {
                    CrystalWaypoints.getInstance().markDirty();
                }
                catch (Throwable ignored) {
                    CrystalWaypoints.getInstance().saveIfDirty();
                }
                return;
            }
            int slotTopY = this.field_148153_b + index * this.rowH - (int)this.field_148169_q;
            int btnY = slotTopY + (this.rowH - 14) / 2;
            int listRight = this.field_148151_d;
            int xRight = listRight - 8;
            BtnRect del = new BtnRect(xRight - this.W_DELETE, btnY, this.W_DELETE, 14);
            BtnRect shr = new BtnRect((xRight -= this.W_DELETE + 4) - this.W_SHARE, btnY, this.W_SHARE, 14);
            BtnRect edt = new BtnRect((xRight -= this.W_SHARE + 4) - this.W_EDIT, btnY, this.W_EDIT, 14);
            if (del.contains(mouseX, mouseY)) {
                this.actions.onDelete(wp);
                return;
            }
            if (shr.contains(mouseX, mouseY)) {
                this.actions.onShare(wp);
                return;
            }
            if (edt.contains(mouseX, mouseY)) {
                this.actions.onEdit(wp);
                return;
            }
        }

        protected void func_180791_a(int idx, int x, int y, int slotHeight, int mouseX, int mouseY) {
            String name;
            if (y + slotHeight < this.field_148153_b || y > this.field_148154_c) {
                return;
            }
            ChWaypoint wp = this.data.get(idx);
            FontRenderer fr = this.mc.field_71466_p;
            int listLeft = this.field_148152_e;
            int listRight = this.field_148151_d;
            int xRight = listRight - 8;
            BtnRect del = WaypointList.makeBtnRect(xRight - this.W_DELETE, y + (slotHeight - 14) / 2, this.W_DELETE, 14);
            BtnRect shr = WaypointList.makeBtnRect((xRight -= this.W_DELETE + 4) - this.W_SHARE, y + (slotHeight - 14) / 2, this.W_SHARE, 14);
            BtnRect edt = WaypointList.makeBtnRect((xRight -= this.W_SHARE + 4) - this.W_EDIT, y + (slotHeight - 14) / 2, this.W_EDIT, 14);
            this.drawButton(edt, LBL_EDIT, mouseX, mouseY, fr);
            this.drawButton(shr, LBL_SHARE, mouseX, mouseY, fr);
            this.drawButton(del, LBL_DELETE, mouseX, mouseY, fr);
            BtnRect cb = this.rectCheckboxForIndex(idx);
            boolean hoverCb = cb.contains(mouseX, mouseY);
            Gui.func_73734_a((int)(cb.x - 1), (int)(cb.y - 1), (int)(cb.x + cb.w + 1), (int)(cb.y + cb.h + 1), (int)-12303292);
            int bg = wp.isToggledSafe() ? (hoverCb ? -13118855 : -13710223) : (hoverCb ? -13421773 : -14540254);
            Gui.func_73734_a((int)cb.x, (int)cb.y, (int)(cb.x + cb.w), (int)(cb.y + cb.h), (int)bg);
            if (wp.isToggledSafe()) {
                String tick = "\u2714";
                int tw = fr.func_78256_a(tick);
                fr.func_78276_b(tick, cb.x + (12 - tw) / 2, cb.y + 1, 1044661);
            }
            int nameX = listLeft + 6 + 12 + 6;
            int textRightLimit = Math.min(edt.x - 8, listRight - 8);
            int xi = (int)Math.round(wp.getX());
            int yi = (int)Math.round(wp.getY());
            int zi = (int)Math.round(wp.getZ());
            String coords = EnumChatFormatting.GRAY + "[" + xi + "," + yi + "," + zi + "]";
            int coordsW = fr.func_78256_a(coords);
            int coordsX = textRightLimit - coordsW;
            int nameMaxW = Math.max(16, coordsX - 6 - nameX);
            String string = name = wp.getName() != null ? wp.getName() : "Waypoint";
            if (fr.func_78256_a(name) > nameMaxW) {
                name = WaypointList.trimToWidthWithEllipsis(fr, name, nameMaxW);
            }
            fr.func_175065_a(name, (float)nameX, (float)(y + 3), 0xFFFFFF, false);
            fr.func_175065_a(coords, (float)coordsX, (float)(y + 3), 0xAAAAAA, false);
        }

        public int func_148139_c() {
            return this.field_148155_a;
        }

        protected int func_148137_d() {
            return this.field_148151_d - 6;
        }

        protected void func_148136_c(int startY, int endY, int startAlpha, int endAlpha) {
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer worldrenderer = tessellator.func_178180_c();
            this.mc.func_110434_K().func_110577_a(Gui.field_110325_k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldrenderer.func_181662_b((double)this.field_148152_e, (double)endY, 0.0).func_181673_a(0.0, (double)((float)endY / 32.0f)).func_181669_b(64, 64, 64, endAlpha).func_181675_d();
            worldrenderer.func_181662_b((double)(this.field_148152_e + this.field_148155_a), (double)endY, 0.0).func_181673_a((double)((float)this.field_148155_a / 32.0f), (double)((float)endY / 32.0f)).func_181669_b(64, 64, 64, endAlpha).func_181675_d();
            worldrenderer.func_181662_b((double)(this.field_148152_e + this.field_148155_a), (double)startY, 0.0).func_181673_a((double)((float)this.field_148155_a / 32.0f), (double)((float)startY / 32.0f)).func_181669_b(64, 64, 64, startAlpha).func_181675_d();
            worldrenderer.func_181662_b((double)this.field_148152_e, (double)startY, 0.0).func_181673_a(0.0, (double)((float)startY / 32.0f)).func_181669_b(64, 64, 64, startAlpha).func_181675_d();
            tessellator.func_78381_a();
        }

        private BtnRect rectCheckboxForIndex(int index) {
            int slotTopY = this.field_148153_b + index * this.rowH - (int)this.field_148169_q;
            int cbX = this.field_148152_e + 6;
            int cbY = slotTopY + (this.rowH - 12) / 2;
            return new BtnRect(cbX, cbY, 12, 12);
        }

        protected void drawContainerBackground(Tessellator tess) {
            Gui.func_73734_a((int)this.field_148152_e, (int)this.field_148153_b, (int)this.field_148151_d, (int)this.field_148154_c, (int)0x55000000);
        }

        private static BtnRect makeBtnRect(int x, int y, int w, int h) {
            return new BtnRect(x, y, w, h);
        }

        private BtnRect makeBtnFromRight(int rightX, int mouseY, int width) {
            int x0 = rightX - width;
            int y0 = Math.max(this.field_148153_b, mouseY - 7);
            return new BtnRect(x0, y0, width, 14);
        }

        private void drawButton(BtnRect r, String label, int mouseX, int mouseY, FontRenderer fr) {
            boolean hover = r.contains(mouseX, mouseY);
            int bg = hover ? -1 : -12303292;
            switch (label) {
                case "Share": {
                    bg = hover ? -217534 : -486089;
                    break;
                }
                case "Delete": {
                    bg = hover ? -1610167 : -2011344;
                    break;
                }
                case "Edit": {
                    bg = hover ? -13987378 : -15568199;
                }
            }
            Gui.func_73734_a((int)r.x, (int)r.y, (int)(r.x + r.w), (int)(r.y + r.h), (int)bg);
            int tl = hover ? 0x55FFFFFF : 0x33333333;
            int br = hover ? 0x33000000 : 0x55000000;
            Gui.func_73734_a((int)r.x, (int)r.y, (int)(r.x + r.w), (int)(r.y + 1), (int)tl);
            Gui.func_73734_a((int)r.x, (int)(r.y + r.h - 1), (int)(r.x + r.w), (int)(r.y + r.h), (int)br);
            Gui.func_73734_a((int)r.x, (int)r.y, (int)(r.x + 1), (int)(r.y + r.h), (int)tl);
            Gui.func_73734_a((int)(r.x + r.w - 1), (int)r.y, (int)(r.x + r.w), (int)(r.y + r.h), (int)br);
            int tx = r.x + (r.w - fr.func_78256_a(label)) / 2;
            int ty = r.y + (r.h - 8) / 2;
            fr.func_175065_a(label, (float)tx, (float)ty, 0xFFFFFF, false);
        }

        private static String trimToWidthWithEllipsis(FontRenderer fr, String s, int maxWidth) {
            if (maxWidth <= 6) {
                return "...";
            }
            String trimmed = fr.func_78269_a(s, maxWidth - 6);
            return (trimmed.endsWith(" ") ? trimmed.substring(0, trimmed.length() - 1) : trimmed) + "...";
        }

        public void setData(List<ChWaypoint> data) {
            this.data = data;
        }

        private static final class BtnRect {
            final int x;
            final int y;
            final int w;
            final int h;

            BtnRect(int x, int y, int w, int h) {
                this.x = x;
                this.y = y;
                this.w = w;
                this.h = h;
            }

            boolean contains(int mx, int my) {
                return mx >= this.x && mx < this.x + this.w && my >= this.y && my < this.y + this.h;
            }
        }
    }
}

