/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.overlays;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class Timer {
    private long lastBucketSec = Long.MIN_VALUE;
    private String cachedText = "0:00";
    private static long goal = 0L;

    @SubscribeEvent
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Text event) {
        if (!this.shouldShow()) {
            return;
        }
        this.updateCache();
        this.render(event);
    }

    private void updateCache() {
        long deltaMs = this.getGoalEpochMs() - System.currentTimeMillis();
        long bucket = deltaMs / 1000L;
        if (bucket != this.lastBucketSec) {
            this.lastBucketSec = bucket;
            this.cachedText = this.formatDelta(deltaMs);
        }
    }

    public void render(RenderGameOverlayEvent.Text event) {
        this.preRender();
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        long deltaMs = this.getGoalEpochMs() - System.currentTimeMillis();
        int color = this.getTextColor(deltaMs);
        float scale = this.getScale();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        ScaledResolution sr = new ScaledResolution(mc);
        int screenW = sr.func_78326_a();
        int screenH = sr.func_78328_b();
        int objW = this.getObjectWidth();
        int objH = this.getObjectHeight();
        int clampedX = this.getX();
        int clampedY = this.getY();
        if (clampedX + objW > screenW) {
            clampedX = Math.max(0, screenW - objW);
        }
        if (clampedY + objH > screenH) {
            clampedY = Math.max(0, screenH - objH);
        }
        if (clampedX < 0) {
            clampedX = 0;
        }
        if (clampedY < 0) {
            clampedY = 0;
        }
        int rx = (int)((float)clampedX / scale);
        int ry = (int)((float)clampedY / scale);
        int textW = fr.func_78256_a(this.cachedText);
        int textH = fr.field_78288_b;
        int texW = this.getIconTextureWidth();
        int texH = this.getIconTextureHeight();
        int iconDrawH = textH;
        int iconDrawW = (int)Math.round((double)texW / (double)texH * (double)iconDrawH);
        int cursorX = rx;
        ResourceLocation icon = this.getIcon();
        if (icon != null) {
            mc.func_110434_K().func_110577_a(icon);
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            Gui.func_146110_a((int)cursorX, (int)(ry - 1), (float)0.0f, (float)0.0f, (int)iconDrawW, (int)iconDrawH, (float)iconDrawW, (float)iconDrawH);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179126_j();
            cursorX += iconDrawW + this.getPadding();
        }
        if (this.getTextShadow()) {
            fr.func_175063_a(this.cachedText, (float)cursorX, (float)ry, color);
        } else {
            fr.func_78276_b(this.cachedText, cursorX, ry, color);
        }
        GlStateManager.func_179121_F();
    }

    public int getObjectWidth() {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        int textW = fr.func_78256_a(this.cachedText);
        int texW = this.getIconTextureWidth();
        int texH = this.getIconTextureHeight();
        int textH = fr.field_78288_b;
        int iconDrawW = (int)Math.round((double)texW / (double)texH * (double)textH);
        return (int)(this.getScale() * (float)(textW + (this.getIcon() != null ? iconDrawW + this.getPadding() : 0)));
    }

    public int getObjectHeight() {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        int textH = fr.field_78288_b;
        return (int)(this.getScale() * (float)textH);
    }

    protected int getTextColor(long deltaMs) {
        if (deltaMs < 0L) {
            return -171;
        }
        if (deltaMs < 5000L) {
            return -11141291;
        }
        return -1;
    }

    protected String formatDelta(long deltaMs) {
        if (deltaMs < 0L) {
            deltaMs = 0L;
        }
        long totalSec = deltaMs / 1000L;
        long min = totalSec / 60L;
        long sec = totalSec % 60L;
        return (min < 10L ? "0" + min : String.valueOf(min)) + ":" + (sec < 10L ? "0" + sec : String.valueOf(sec));
    }

    public abstract boolean shouldShow();

    public void preRender() {
    }

    public abstract ResourceLocation getIcon();

    protected int getIconTextureWidth() {
        return 16;
    }

    protected int getIconTextureHeight() {
        return 16;
    }

    public abstract long getGoalEpochMs();

    public int getX() {
        return 0;
    }

    public int getY() {
        return 0;
    }

    public boolean getTextShadow() {
        return false;
    }

    public float getScale() {
        return 1.0f;
    }

    public int getPadding() {
        return 3;
    }
}

