/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.overlays.inventory.equipment;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.overlays.inventory.equipment.EquipmentData;
import org.ginafro.notenoughfakepixel.mixin.accesors.AccessorGuiContainer;
import org.ginafro.notenoughfakepixel.utils.ConfigHandler;
import org.ginafro.notenoughfakepixel.utils.CustomConfigFiles;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.variables.Gamemode;
import org.ginafro.notenoughfakepixel.variables.Resources;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@RegisterEvents
public class EquipmentOverlay {
    public static final int EQUIPMENT_SLOT_OFFSET_Y = 8;
    public static final int ARMOR_OVERLAY_OVERHAND_WIDTH = 24;
    public static final int ARMOR_OVERLAY_HEIGHT = 86;
    public static final int ARMOR_OVERLAY_WIDTH = 31;
    protected boolean mouseClick = false;
    protected long lastClick = 0L;
    protected static Map<Integer, ItemStack> equipments = new HashMap<Integer, ItemStack>();
    protected static EquipmentData data;
    Minecraft mc;

    @SubscribeEvent
    public void onDraw(GuiScreenEvent.DrawScreenEvent.Post e) throws NBTException {
        ContainerChest cc;
        if (ScoreboardUtils.currentGamemode != Gamemode.SKYBLOCK || !Config.feature.overlays.equipment) {
            return;
        }
        RenderHelper.func_74520_c();
        if (e.gui instanceof GuiInventory) {
            GuiInventory inventory = (GuiInventory)e.gui;
            AccessorGuiContainer container = (AccessorGuiContainer)inventory;
            int overlayLeft = container.getGuiLeft() - 24;
            int overlayTop = container.getGuiTop();
            this.renderHudBackground(e.gui);
            if (Mouse.isButtonDown((int)0) && e.mouseX > overlayLeft && e.mouseY > overlayTop && e.mouseX < overlayLeft + 31 && e.mouseY < overlayTop + 86) {
                this.sendEquipmentCommand(e.gui.field_146297_k.field_71439_g);
            }
            int yIndex = 0;
            if (data == null) {
                return;
            }
            if (!EquipmentOverlay.data.items.isEmpty()) {
                for (Integer i : data.getItemStacks().keySet()) {
                    ItemStack stack = data.getItemStacks().get(i);
                    if (stack.func_77973_b() instanceof ItemBlock) {
                        ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
                        if (itemBlock.field_150939_a instanceof BlockStainedGlassPane) {
                            ++yIndex;
                            continue;
                        }
                    }
                    Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, overlayLeft + 8, overlayTop + 8 + yIndex * 18);
                    if (e.mouseX > overlayLeft + 8 && e.mouseY > overlayTop + 8 + yIndex * 16 && e.mouseX < overlayLeft + 24 && e.mouseY < overlayTop + 8 + yIndex * 16 + 16) {
                        this.renderToolTip(e.gui, stack, e.mouseX, e.mouseY);
                    }
                    if (yIndex % 3 == 0) {
                        yIndex = 0;
                    }
                    ++yIndex;
                }
            }
        }
        if (e.gui instanceof GuiContainer && e.gui instanceof GuiChest && (cc = (ContainerChest)((GuiContainer)e.gui).field_147002_h).func_85151_d().func_145748_c_().func_150260_c().startsWith("Your Equipment")) {
            for (int i = 10; i < 38; i += 9) {
                equipments.put(i, cc.func_75139_a(i).func_75211_c());
            }
            data = new EquipmentData(equipments);
            EquipmentOverlay.saveData();
        }
        RenderHelper.func_74518_a();
    }

    protected void renderToolTip(GuiScreen screen, ItemStack stack, int x, int y) {
        this.mc = Minecraft.func_71410_x();
        List list = stack.func_82840_a((EntityPlayer)this.mc.field_71439_g, this.mc.field_71474_y.field_82882_x);
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                continue;
            }
            list.set(i, EnumChatFormatting.GRAY + (String)list.get(i));
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        this.drawHoveringText(list, x, y, font == null ? this.mc.field_71466_p : font, screen);
    }

    protected void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font, GuiScreen screen) {
        try {
            GuiUtils.drawHoveringText(textLines, (int)x, (int)y, (int)screen.field_146294_l, (int)screen.field_146295_m, (int)-1, (FontRenderer)font);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveData() {
        File file = new File(CustomConfigFiles.EQUIPMENTS.path);
        try (FileWriter writer = new FileWriter(file);){
            String json = ConfigHandler.GSON.toJson((Object)data);
            writer.write(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadData() {
        if (!new File(CustomConfigFiles.EQUIPMENTS.path).exists()) {
            return;
        }
        File file = new File(CustomConfigFiles.EQUIPMENTS.path);
        if (!file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file);){
            data = (EquipmentData)ConfigHandler.GSON.fromJson((Reader)reader, EquipmentData.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendEquipmentCommand(EntityPlayerSP p) {
        if (this.mouseClick) {
            p.func_71165_d("/equipment");
            this.mouseClick = false;
            this.lastClick = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.lastClick > 1000L) {
            p.func_71165_d("/equipment");
            this.lastClick = System.currentTimeMillis();
        }
    }

    public void renderHudBackground(GuiScreen inventory) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AccessorGuiContainer container = (AccessorGuiContainer)inventory;
        int overlayLeft = container.getGuiLeft() - 24;
        int overlayTop = container.getGuiTop();
        ResourceLocation equipmentTexture = Resources.EQUIPMENT.getResource();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(equipmentTexture);
        Gui.func_152125_a((int)overlayLeft, (int)overlayTop, (float)0.0f, (float)0.0f, (int)31, (int)86, (int)31, (int)86, (float)31.0f, (float)86.0f);
        GlStateManager.func_179144_i((int)0);
    }

    public static void renderHudBackground(int guiLeft, int guiTop) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int overlayLeft = guiLeft - 24;
        ResourceLocation equipmentTexture = Resources.EQUIPMENT.getResource();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(equipmentTexture);
        Gui.func_152125_a((int)overlayLeft, (int)guiTop, (float)0.0f, (float)0.0f, (int)31, (int)86, (int)31, (int)86, (float)31.0f, (float)86.0f);
        GlStateManager.func_179144_i((int)0);
    }
}

