/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.overlays.stats;

import java.io.IOException;
import java.util.EnumMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.config.gui.core.config.Position;
import org.ginafro.notenoughfakepixel.features.skyblock.overlays.stats.StatBars;

public class PositionEditorScreen
extends GuiScreen {
    private final EnumMap<StatBars.BarType, Position> editingPositions = new EnumMap(StatBars.BarType.class);
    private StatBars.BarType draggingBar = null;
    private int dragOffsetX;
    private int dragOffsetY;

    public void func_73866_w_() {
        this.editingPositions.put(StatBars.BarType.HEALTH, Config.feature.overlays.posHealth);
        this.editingPositions.put(StatBars.BarType.MANA, Config.feature.overlays.posMana);
        this.editingPositions.put(StatBars.BarType.EXP, Config.feature.overlays.posExp);
        this.editingPositions.put(StatBars.BarType.SPEED, Config.feature.overlays.posSpeed);
        this.editingPositions.put(StatBars.BarType.DEFENCE, Config.feature.overlays.posDefense);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        for (StatBars.BarType type : StatBars.BarType.values()) {
            Position pos = this.editingPositions.get((Object)type);
            int x = pos.getRawX();
            int y = pos.getRawY();
            StatBars.BarLength length = new StatBars().getBarLength(type);
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179124_c((float)type.color[0], (float)type.color[1], (float)type.color[2]);
            this.field_146297_k.func_110434_K().func_110577_a(length.fill);
            this.func_73729_b(x, y, 0, 0, length.width, 7);
            GlStateManager.func_179121_F();
        }
        this.func_73732_a(this.field_146289_q, "Drag bars to reposition. ESC to exit.", this.field_146294_l / 2, this.field_146295_m - 20, 0xAAAAAA);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        for (StatBars.BarType type : StatBars.BarType.values()) {
            Position pos = this.editingPositions.get((Object)type);
            int x = pos.getRawX();
            int y = pos.getRawY();
            StatBars.BarLength length = new StatBars().getBarLength(type);
            if (mouseX < x || mouseX > x + length.width || mouseY < y || mouseY > y + 7) continue;
            this.draggingBar = type;
            this.dragOffsetX = mouseX - x;
            this.dragOffsetY = mouseY - y;
            break;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        this.draggingBar = null;
        super.func_146286_b(mouseX, mouseY, state);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.draggingBar != null) {
            Position pos = this.editingPositions.get((Object)this.draggingBar);
            int newX = mouseX - this.dragOffsetX;
            int newY = mouseY - this.dragOffsetY;
            ScaledResolution res = new ScaledResolution(this.field_146297_k);
            int screenWidth = res.func_78326_a();
            int screenHeight = res.func_78328_b();
            int barWidth = new StatBars().getBarLength((StatBars.BarType)this.draggingBar).width;
            int vanillaHotbarX = screenWidth / 2 - barWidth / 2;
            int vanillaHotbarY = screenHeight - 49;
            int snapDistance = 5;
            if (Math.abs(newX - vanillaHotbarX) <= snapDistance) {
                newX = vanillaHotbarX;
            }
            if (Math.abs(newY - vanillaHotbarY) <= snapDistance) {
                newY = vanillaHotbarY;
            }
            pos.set(new Position(newX, newY));
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    public boolean func_73868_f() {
        return false;
    }
}

