/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.overlays.stats;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;

@RegisterEvents
public class StatBars {
    private static int expLevel;
    private static int health;
    private static int maxHealth;
    private static int mana;
    private static int maxMana;
    private static int overflowMana;
    private static int overflowHealth;
    private static int defence;
    private static int speed;
    private static float exp;

    public BarLength getBarLength(BarType type) {
        if (type == BarType.HEALTH) {
            return this.getLength(Config.feature.overlays.barLengthH);
        }
        if (type == BarType.MANA) {
            return this.getLength(Config.feature.overlays.barLengthM);
        }
        if (type == BarType.SPEED) {
            return this.getLength(Config.feature.overlays.barLengthS);
        }
        if (type == BarType.EXP) {
            return this.getLength(Config.feature.overlays.barLengthE);
        }
        return this.getLength(Config.feature.overlays.barLengthD);
    }

    public BarLength getLength(int i) {
        if (i == 0) {
            return BarLength.TINY;
        }
        if (i == 1) {
            return BarLength.SMALL;
        }
        if (i == 2) {
            return BarLength.MEDIUM;
        }
        if (i == 3) {
            return BarLength.LARGE;
        }
        return BarLength.SMALL;
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent e) {
        if (e.type == 2) {
            this.updateStats(e.message);
            if (Config.feature.overlays.disableActionBar && e.message.func_150260_c().contains("Defense")) {
                e.setCanceled(true);
            }
        }
    }

    private void updateStats(IChatComponent message) {
        String text1 = message.func_150260_c();
        if (text1.contains("\u2764") && text1.contains("\u2747") && text1.contains("\u270e")) {
            String text = text1.replace("\u2764", "").replace("\u2747", "").replace("\u270e", "");
            String[] stats = text.split(" {5}");
            String heal = StringUtils.func_76338_a((String)stats[0].trim());
            String def = StringUtils.func_76338_a((String)stats[1].trim());
            String man = StringUtils.func_76338_a((String)stats[2].trim());
            defence = Integer.parseInt(def.replace("Defense", "").trim());
            maxHealth = Integer.parseInt(heal.split("/")[1].trim());
            health = Integer.parseInt(heal.split("/")[0].trim());
            overflowHealth = Math.max(0, health - maxHealth);
            String[] manas = man.replace(" Mana", "").split(" ");
            mana = Integer.parseInt(manas[0].split("/")[0].trim());
            maxMana = Integer.parseInt(manas[0].split("/")[1].trim());
            if (man.contains("\u02ac")) {
                overflowMana = Integer.parseInt(manas[1].replace("\u02ac", "").trim());
            }
            exp = Minecraft.func_71410_x().field_71439_g.field_71106_cc;
            expLevel = Minecraft.func_71410_x().field_71439_g.field_71068_ca;
        }
    }

    @SubscribeEvent
    public void onDraw(RenderGameOverlayEvent e) {
        if (maxHealth > 0 && maxMana > 0 && Config.feature.overlays.disableIcons && (e.type == RenderGameOverlayEvent.ElementType.EXPERIENCE || e.type == RenderGameOverlayEvent.ElementType.ARMOR || e.type == RenderGameOverlayEvent.ElementType.HEALTH || e.type == RenderGameOverlayEvent.ElementType.HEALTHMOUNT || e.type == RenderGameOverlayEvent.ElementType.FOOD)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post e) {
        if (e.type != RenderGameOverlayEvent.ElementType.HOTBAR || !Config.feature.overlays.statOverlay) {
            return;
        }
        if (maxMana != 0 || maxHealth != 0) {
            for (BarType type : BarType.values()) {
                this.drawBar(type.getX(), type.getY(), type, this.getBarLength(type), type.getStatValue());
            }
        }
    }

    private void drawBar(int x, int y, BarType type, BarLength barLength, StatValue value) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179117_G();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(type.logo);
        Gui.func_146110_a((int)(x - 11), (int)(y - 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (float)9.0f, (float)9.0f);
        float filled = barLength.width;
        if (value.value2 != 0.0f) {
            filled = Math.min((float)barLength.width, value.value1 / value.value2 * (float)barLength.width);
        }
        if (type == BarType.EXP) {
            filled = Math.min((float)barLength.width, BarType.EXP.getStatValue().value3 * (float)barLength.width);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(barLength.base);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)barLength.width, (int)7, (float)barLength.width, (float)7.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(barLength.fill);
        GlStateManager.func_179124_c((float)type.color[0], (float)type.color[1], (float)type.color[2]);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)((int)filled), (int)7, (float)barLength.width, (float)7.0f);
        if (value.value3 != 0.0f && type != BarType.EXP && type.color.length > 3) {
            float fill = Math.min((float)barLength.width, value.value3 / value.value2 * (float)barLength.width);
            GlStateManager.func_179117_G();
            GlStateManager.func_179124_c((float)type.color[3], (float)type.color[4], (float)type.color[5]);
            Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)((int)fill), (int)7, (float)barLength.width, (float)7.0f);
        }
        String text = String.valueOf(type.getStatValue().value1);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        float xPos = (float)x + (float)barLength.width / 2.0f - (float)font.func_78256_a(text) / 2.0f;
        int color = new Color((int)type.color[0] * 255, (int)type.color[1] * 255, (int)type.color[2] * 255).getRGB();
        font.func_175063_a(text, xPos, (float)y, color);
        GlStateManager.func_179121_F();
    }

    public static void setExpLevel(int expLevel) {
        StatBars.expLevel = expLevel;
    }

    public static void setHealth(int health) {
        StatBars.health = health;
    }

    public static void setMaxHealth(int maxHealth) {
        StatBars.maxHealth = maxHealth;
    }

    public static void setMana(int mana) {
        StatBars.mana = mana;
    }

    public static void setMaxMana(int maxMana) {
        StatBars.maxMana = maxMana;
    }

    public static void setOverflowMana(int overflowMana) {
        StatBars.overflowMana = overflowMana;
    }

    public static void setOverflowHealth(int overflowHealth) {
        StatBars.overflowHealth = overflowHealth;
    }

    public static void setDefence(int defence) {
        StatBars.defence = defence;
    }

    public static void setSpeed(int speed) {
        StatBars.speed = speed;
    }

    public static int getExpLevel() {
        return expLevel;
    }

    public static int getHealth() {
        return health;
    }

    public static int getMaxHealth() {
        return maxHealth;
    }

    public static int getMana() {
        return mana;
    }

    public static int getMaxMana() {
        return maxMana;
    }

    public static int getOverflowMana() {
        return overflowMana;
    }

    public static int getOverflowHealth() {
        return overflowHealth;
    }

    public static int getDefence() {
        return defence;
    }

    public static int getSpeed() {
        return speed;
    }

    static {
        speed = 100;
    }

    public static class StatValue {
        public float value1;
        public float value2;
        public float value3;

        public StatValue(float v1, float v2) {
            this.value1 = v1;
            this.value2 = v2;
        }

        public StatValue(float v1, float v2, float v3) {
            this.value1 = v1;
            this.value2 = v2;
            this.value3 = v3;
        }

        public StatValue(float v1) {
            this.value1 = v1;
        }
    }

    public static enum BarType {
        HEALTH(new ResourceLocation("notenoughfakepixel", "skyblock/stats/heart.png"), new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.84f, 0.074f}),
        MANA(new ResourceLocation("notenoughfakepixel", "skyblock/stats/mana.png"), new float[]{0.0745f, 0.905f, 1.0f}),
        EXP(new ResourceLocation("notenoughfakepixel", "skyblock/stats/exp.png"), new float[]{0.7843f, 1.0f, 0.5607f}),
        SPEED(new ResourceLocation("notenoughfakepixel", "skyblock/stats/speed.png"), new float[]{1.0f, 1.0f, 1.0f}),
        DEFENCE(new ResourceLocation("notenoughfakepixel", "skyblock/stats/defense.png"), new float[]{1.0f, 1.0f, 1.0f});

        public ResourceLocation logo;
        public float[] color;

        private BarType(ResourceLocation logo, float[] color) {
            this.logo = logo;
            this.color = color;
        }

        public int getX() {
            if (this == HEALTH) {
                return Config.feature.overlays.posHealth.getRawX();
            }
            if (this == MANA) {
                return Config.feature.overlays.posMana.getRawX();
            }
            if (this == SPEED) {
                return Config.feature.overlays.posSpeed.getRawX();
            }
            if (this == EXP) {
                return Config.feature.overlays.posExp.getRawX();
            }
            return Config.feature.overlays.posDefense.getRawX();
        }

        public int getY() {
            if (this == HEALTH) {
                return Config.feature.overlays.posHealth.getRawY();
            }
            if (this == MANA) {
                return Config.feature.overlays.posMana.getRawY();
            }
            if (this == SPEED) {
                return Config.feature.overlays.posSpeed.getRawY();
            }
            if (this == EXP) {
                return Config.feature.overlays.posExp.getRawY();
            }
            return Config.feature.overlays.posDefense.getRawY();
        }

        public StatValue getStatValue() {
            if (this == HEALTH) {
                return new StatValue(health, maxHealth, overflowHealth);
            }
            if (this == MANA) {
                return new StatValue(mana, maxMana, overflowMana);
            }
            if (this == SPEED) {
                return new StatValue(speed, 400.0f);
            }
            if (this == EXP) {
                return new StatValue(expLevel, 0.0f, exp);
            }
            if (this == DEFENCE) {
                return new StatValue(defence);
            }
            return new StatValue(0.0f, 0.0f);
        }
    }

    public static enum BarLength {
        TINY(new ResourceLocation("notenoughfakepixel", "skyblock/stats/bars/size_0_base.png"), new ResourceLocation("notenoughfakepixel", "skyblock/stats/bars/size_0_fill.png"), 34),
        SMALL(new ResourceLocation("notenoughfakepixel", "skyblock/stats/bars/size_1_base.png"), new ResourceLocation("notenoughfakepixel", "skyblock/stats/bars/size_1_fill.png"), 50),
        MEDIUM(new ResourceLocation("notenoughfakepixel", "skyblock/stats/bars/size_2_base.png"), new ResourceLocation("notenoughfakepixel", "skyblock/stats/bars/size_2_fill.png"), 80),
        LARGE(new ResourceLocation("notenoughfakepixel", "skyblock/stats/bars/size_3_base.png"), new ResourceLocation("notenoughfakepixel", "skyblock/stats/bars/size_3_fill.png"), 182);

        public final ResourceLocation base;
        public final ResourceLocation fill;
        public final int width;

        private BarLength(ResourceLocation base, ResourceLocation fill, int width) {
            this.base = base;
            this.fill = fill;
            this.width = width;
        }
    }
}

