/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.Utils;

public class CustomBar {
    public int currentHealth = 1;
    public int maxHealth = 1;
    public int currentMana = 1;
    public int maxMana = 1;

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent e) {
        if ((e.type == RenderGameOverlayEvent.ElementType.HEALTH || e.type == RenderGameOverlayEvent.ElementType.ARMOR || e.type == RenderGameOverlayEvent.ElementType.FOOD) && ScoreboardUtils.currentGamemode.isSkyblock() && Config.feature.overlays.statOverlay) {
            this.renderCustomHealth(e.resolution);
            this.renderCustomMana(e.resolution);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent e) {
        if (e.type != 2) {
            return;
        }
        String[] actionBar = e.message.func_150260_c().split(" {5}");
        if (actionBar.length == 3) {
            String mana;
            String health = ColorUtils.cleanColor(actionBar[0]);
            if (health.endsWith("\u2764")) {
                String[] healthValues = health.replace("\u2764", "").split("/");
                this.currentHealth = Integer.parseInt(healthValues[0]);
                this.maxHealth = Integer.parseInt(healthValues[1]);
            }
            if ((mana = ColorUtils.cleanColor(actionBar[2])).contains("Mana")) {
                int index = mana.indexOf("\u270e");
                String[] manaValues = mana.substring(0, index).split("/");
                this.currentMana = Integer.parseInt(manaValues[0]);
                this.maxMana = Integer.parseInt(manaValues[1]);
            }
        }
        if (e.isCancelable() && Config.feature.overlays.statOverlay) {
            e.setCanceled(true);
        }
    }

    private void renderCustomHealth(ScaledResolution sr) {
        int w = sr.func_78326_a();
        int h = sr.func_78328_b();
        int left = w / 2 - (int)(110.0 * (double)Utils.getScale());
        int top = h - (int)(40.0f * Utils.getScale());
        float percentage = (float)this.currentHealth / (float)this.maxHealth;
        int barWidth = (int)(Utils.getScale() * 75.0f);
        int barHeight = (int)(5.0f * Utils.getScale());
        Gui.func_73734_a((int)left, (int)top, (int)(left + barWidth), (int)(top + barHeight), (int)new Color(0, 0, 0, 102).getRGB());
        Gui.func_73734_a((int)left, (int)top, (int)(left + (int)((float)barWidth * percentage)), (int)(top + barHeight), (int)new Color(255, 0, 0, 180).getRGB());
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int l = left + (barWidth - fr.func_78256_a(this.currentHealth + "/" + this.maxHealth)) / 2;
        int t = top - fr.field_78288_b;
        fr.func_78276_b(this.currentHealth + "/" + this.maxHealth, l, t, new Color(255, 0, 0, 180).getRGB());
    }

    private void renderCustomMana(ScaledResolution sr) {
        int w = sr.func_78326_a();
        int h = sr.func_78328_b();
        int left = w / 2 + (int)(40.0f * Utils.getScale());
        int top = h - (int)(40.0f * Utils.getScale());
        float percentage = (float)this.currentMana / (float)this.maxMana;
        int barWidth = (int)(Utils.getScale() * 75.0f);
        int barHeight = (int)(5.0f * Utils.getScale());
        Gui.func_73734_a((int)left, (int)top, (int)(left + barWidth), (int)(top + barHeight), (int)new Color(0, 0, 0, 102).getRGB());
        Gui.func_73734_a((int)left, (int)top, (int)(left + (int)((float)barWidth * percentage)), (int)(top + barHeight), (int)new Color(51, 255, 255, 180).getRGB());
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int l = left + (barWidth - fr.func_78256_a(this.currentMana + "/" + this.maxMana)) / 2;
        int t = top - fr.field_78288_b;
        fr.func_78276_b(this.currentMana + "/" + this.maxMana, l, t, new Color(51, 255, 255, 180).getRGB());
    }
}

