/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.Utils;
import org.ginafro.notenoughfakepixel.variables.Gamemode;

@Deprecated
public class DamageCommas {
    private static final WeakHashMap<EntityLivingBase, ChatComponentText> replacementMap = new WeakHashMap();
    private static final EnumChatFormatting[] coloursHypixel = new EnumChatFormatting[]{EnumChatFormatting.WHITE, EnumChatFormatting.YELLOW, EnumChatFormatting.GOLD, EnumChatFormatting.RED, EnumChatFormatting.RED, EnumChatFormatting.WHITE};
    private static final char STAR = '\u2727';
    private static final char OVERLOAD_STAR = '\u272f';
    private static final Pattern PATTERN_CRIT = Pattern.compile("\u00a7f\u2727((?:\u00a7.\\d(?:\u00a7.,)?)+)\u00a7.\u2727(.*)");
    private static final Pattern PATTERN_NO_CRIT = Pattern.compile("(\u00a7.)([\\d+,]*)(.*)");
    private static final Pattern OVERLOAD_PATTERN = Pattern.compile("(\u00a7.)\u272f((?:\u00a7.[\\d,])+)(\u00a7.)\u272f\u00a7r");

    public static IChatComponent replaceName(EntityLivingBase entity) {
        IChatComponent name = entity.func_145748_c_();
        if (!entity.func_145818_k_()) {
            return name;
        }
        if (ScoreboardUtils.currentGamemode != Gamemode.SKYBLOCK) {
            return name;
        }
        return name;
    }

    public static IChatComponent replaceForCommas(EntityLivingBase entity, IChatComponent name) {
        String suffix;
        String prefix;
        String numbers;
        if (replacementMap.containsKey(entity)) {
            ChatComponentText component = replacementMap.get(entity);
            if (component == null) {
                return name;
            }
            return component;
        }
        String formatted = name.func_150254_d();
        boolean crit = false;
        Matcher matcherCrit = PATTERN_CRIT.matcher(formatted);
        Matcher matcherOverload = OVERLOAD_PATTERN.matcher(formatted);
        if (matcherCrit.matches()) {
            crit = true;
            numbers = ColorUtils.cleanColor(matcherCrit.group(1)).replace(",", "");
            prefix = "\u00a7f\u2727";
            suffix = "\u00a7f\u2727" + matcherCrit.group(2);
        } else if (matcherOverload.matches()) {
            crit = true;
            numbers = ColorUtils.cleanColor(matcherOverload.group(2)).replace(",", "");
            prefix = matcherOverload.group(1) + '\u272f';
            suffix = matcherOverload.group(3) + '\u272f' + "\u00a7r";
        } else {
            Matcher matcherNoCrit = PATTERN_NO_CRIT.matcher(formatted);
            if (matcherNoCrit.matches()) {
                numbers = matcherNoCrit.group(2).replace(",", "");
                prefix = matcherNoCrit.group(1);
                suffix = "\u00a7r" + matcherNoCrit.group(3);
            } else {
                replacementMap.put(entity, null);
                return name;
            }
        }
        StringBuilder newFormatted = new StringBuilder();
        try {
            int number = Integer.parseInt(numbers);
            if (number <= 999) {
                return name;
            }
            newFormatted.append(DamageCommas.formatNumber(number));
        }
        catch (NumberFormatException e) {
            replacementMap.put(entity, null);
            return name;
        }
        if (crit) {
            StringBuilder newFormattedCrit = new StringBuilder();
            int colourIndex = 0;
            for (char c : newFormatted.toString().toCharArray()) {
                if (c == ',') {
                    newFormattedCrit.append(EnumChatFormatting.GRAY);
                } else {
                    newFormattedCrit.append(coloursHypixel[colourIndex++ % coloursHypixel.length]);
                }
                newFormattedCrit.append(c);
            }
            newFormatted = newFormattedCrit;
        }
        ChatComponentText finalComponent = new ChatComponentText(prefix + newFormatted + suffix);
        replacementMap.put(entity, finalComponent);
        return finalComponent;
    }

    private static String formatNumber(int number) {
        return Utils.commaFormat(number);
    }
}

