/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.overlays.Timer;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.TimeUtils;
import org.ginafro.notenoughfakepixel.variables.Resources;

@RegisterEvents
public class DarkAhTimer
extends Timer {
    private static long goal = 0L;

    @Override
    public boolean shouldShow() {
        return Config.feature.qol.qolDAtimer && ScoreboardUtils.currentGamemode.isSkyblock();
    }

    @Override
    public ResourceLocation getIcon() {
        return Resources.DARK_AH.getResource();
    }

    @Override
    public void preRender() {
        long now = System.currentTimeMillis();
        long goal = this.getGoalEpochMs();
        if (goal <= 0L || now > goal) {
            DarkAhTimer.setGoalEpochMs(TimeUtils.nextXx55UtcEpochMs());
        }
        if (goal - now <= 60000L && goal - now > 59900L) {
            DarkAhTimer.notifyDA();
        }
    }

    @Override
    protected int getTextColor(long deltaMs) {
        if (deltaMs <= 0L) {
            return -11141291;
        }
        long sec = deltaMs / 1000L;
        if (sec <= 180L) {
            return -43691;
        }
        return -22016;
    }

    @Override
    public int getX() {
        return Config.feature.qol.darkAhTimerPos.getAbsX(new ScaledResolution(Minecraft.func_71410_x()), this.getObjectWidth()) - this.getObjectWidth() / 2;
    }

    @Override
    public int getY() {
        return Config.feature.qol.darkAhTimerPos.getAbsY(new ScaledResolution(Minecraft.func_71410_x()), this.getObjectHeight()) - this.getObjectHeight() / 2;
    }

    @Override
    public float getScale() {
        return Config.feature.qol.darkAHTimerScale;
    }

    @Override
    public boolean getTextShadow() {
        return true;
    }

    @Override
    public long getGoalEpochMs() {
        return goal;
    }

    public static void setGoalEpochMs(long goal) {
        DarkAhTimer.goal = goal;
    }

    private static void notifyDA() {
        if (!Config.feature.qol.qolDarkAhNotifier) {
            return;
        }
        Minecraft.func_71410_x().field_71456_v.func_175178_a(EnumChatFormatting.GOLD + "Mining Ability Ready", "", 2, 70, 2);
    }
}

