/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.SpawnedParticleEvent;
import org.ginafro.notenoughfakepixel.features.skyblock.qol.highlighters.BlockHighlighter;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.NumberUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Location;

@RegisterEvents
public class EnderNodesHighlighter
extends BlockHighlighter {
    @SubscribeEvent
    public void onParticleSpawn(SpawnedParticleEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getParticleTypes() == EnumParticleTypes.PORTAL) {
            double x = event.getXCoord();
            double y = event.getYCoord();
            double z = event.getZCoord();
            double dist = 0.2;
            boolean xZero = NumberUtils.basicallyEqual(x % 1.0, 0.0, dist);
            boolean yZero = NumberUtils.basicallyEqual(y % 1.0, 0.0, dist);
            boolean zZero = NumberUtils.basicallyEqual(z % 1.0, 0.0, dist);
            double truncX = NumberUtils.truncateTwoDecimalPlaces(Math.abs(x % 1.0));
            double truncY = NumberUtils.truncateTwoDecimalPlaces(Math.abs(y % 1.0));
            double truncZ = NumberUtils.truncateTwoDecimalPlaces(Math.abs(z % 1.0));
            if (truncY < 0.25 && xZero && zZero && this.tryRegisterInterest(x, y - 1.0, z)) {
                return;
            }
            if (truncY > 0.75 && xZero && zZero && this.tryRegisterInterest(x, y + 1.0, z)) {
                return;
            }
            if (truncX < 0.25 && yZero && zZero && this.tryRegisterInterest(x + 1.0, y, z)) {
                return;
            }
            if (truncX > 0.75 && yZero && zZero && this.tryRegisterInterest(x - 1.0, y, z)) {
                return;
            }
            if (truncZ < 0.25 && yZero && xZero && this.tryRegisterInterest(x, y, z + 1.0)) {
                return;
            }
            if (truncZ < 0.75 && yZero && xZero) {
                this.tryRegisterInterest(x, y, z - 1.0);
            }
        }
    }

    @Override
    protected boolean isEnabled() {
        return TablistParser.currentLocation.equals((Object)Location.THE_END) && Config.feature.qol.qolEndNodeHighlighter;
    }

    @Override
    protected boolean isValidHighlightSpot(BlockPos key) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return false;
        }
        Block b = w.func_180495_p(key).func_177230_c();
        return b == Blocks.field_150377_bs || b == Blocks.field_150343_Z;
    }

    @Override
    protected Color getColor(BlockPos blockPos) {
        return ColorUtils.getColor(Config.feature.qol.endNodeColor);
    }
}

