/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import com.google.gson.Gson;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.handlers.RepoHandler;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.ConfigHandler;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Gamemode;
import org.ginafro.notenoughfakepixel.variables.Location;

@RegisterEvents
public class FairySouls {
    private String island;
    public static File SOULS_FILE = new File(Config.configDirectory, "gainedsouls.json");
    public static Gson gson = ConfigHandler.GSON;
    public static Map<String, List<String>> templateMap = new HashMap<String, List<String>>();
    private static final FairySoulData STUB_SOULS = new FairySoulData("Could not load repository", 247, Collections.emptyMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onRender(RenderWorldLastEvent e) {
        FairySoulData all = FairySouls.getAllSouls();
        Map<String, List<String>> locs = all != null ? all.locations : null;
        List<String> souls = Collections.emptyList();
        this.island = null;
        if (ScoreboardUtils.currentGamemode != Gamemode.SKYBLOCK) {
            return;
        }
        if (!Config.feature.qol.fairySoulWaypoints) {
            return;
        }
        Location currentIsland = TablistParser.currentLocation;
        if (locs != null && currentIsland != null) {
            switch (currentIsland) {
                case HUB: {
                    souls = locs.getOrDefault("hub", Collections.emptyList());
                    this.island = "hub";
                    break;
                }
                case SPIDERS_DEN: {
                    souls = locs.getOrDefault("spider", Collections.emptyList());
                    this.island = "spider";
                    break;
                }
                case CRIMSON_ISLE: {
                    souls = locs.getOrDefault("crimson", Collections.emptyList());
                    this.island = "crimson";
                    break;
                }
                case THE_END: {
                    souls = locs.getOrDefault("end", Collections.emptyList());
                    this.island = "end";
                    break;
                }
                case PARK: {
                    souls = locs.getOrDefault("park", Collections.emptyList());
                    this.island = "park";
                    break;
                }
                case BARN: {
                    souls = locs.getOrDefault("farming", Collections.emptyList());
                    this.island = "farming";
                    break;
                }
                case GOLD_MINE: {
                    souls = locs.getOrDefault("gold", Collections.emptyList());
                    this.island = "gold";
                    break;
                }
                case DUNGEON_HUB: {
                    souls = locs.getOrDefault("dungeon_hub", Collections.emptyList());
                    this.island = "dungeon_hub";
                    break;
                }
                case JERRY: {
                    souls = locs.getOrDefault("winter", Collections.emptyList());
                    this.island = "winter";
                    break;
                }
                case DWARVEN: {
                    souls = locs.getOrDefault("dwarven", Collections.emptyList());
                    this.island = "dwarven";
                    break;
                }
            }
        }
        GlStateManager.func_179094_E();
        try {
            List<String> renderedSouls = this.checkSouls(souls);
            for (String s : renderedSouls) {
                String[] coords = s.split(",");
                Entity viewer = Minecraft.func_71410_x().func_175606_aa();
                double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)e.partialTicks;
                double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)e.partialTicks;
                double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)e.partialTicks;
                int x = Integer.parseInt(coords[0].trim());
                int y = Integer.parseInt(coords[1].trim());
                int z = Integer.parseInt(coords[2].trim());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                AxisAlignedBB aab = new AxisAlignedBB((double)x - viewerX + 0.2, (double)y - viewerY - 1.0, (double)z - viewerZ + 0.2, (double)x + 0.8 - viewerX, (double)y - viewerY + 256.0, (double)z + 0.8 - viewerZ).func_72314_b((double)0.01f, (double)0.01f, (double)0.01f);
                Color base = ColorUtils.getColor(Config.feature.qol.fairySoulWaypointsColor);
                Color beam = new Color(base.getRed(), base.getGreen(), base.getBlue(), 102);
                RenderUtils.highlightBlock(new BlockPos(x, y, z), base, true, e.partialTicks);
                GlStateManager.func_179129_p();
                GlStateManager.func_179097_i();
                RenderUtils.renderBeaconBeam(new BlockPos(x, y, z), beam.getRGB(), 1.0f, e.partialTicks);
                GlStateManager.func_179126_j();
                GlStateManager.func_179089_o();
                GlStateManager.func_179098_w();
            }
        }
        finally {
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent e) {
        String msg = StringUtils.func_76338_a((String)e.message.func_150260_c()).trim();
        if (msg.equalsIgnoreCase("SOUL! You found a Fairy Soul!") || msg.equalsIgnoreCase("You already found that Fairy Soul!")) {
            System.out.println("Chat Recieved");
            String soul = null;
            double closestDistSq = 25.0;
            FairySoulData soulData = FairySouls.getAllSouls();
            FairySoulData soulData1 = FairySouls.getSoulData();
            if (this.island == null || soulData1.locations == null) {
                System.out.println("Island or soulData.locations is null");
                return;
            }
            List<String> souls = soulData.locations.get(this.island);
            List gainedSouls = soulData1.locations.computeIfAbsent(this.island, k -> new ArrayList());
            for (String s : souls) {
                String[] s1 = s.split(",");
                BlockPos pos = new BlockPos(Integer.parseInt(s1[0]), Integer.parseInt(s1[1]), Integer.parseInt(s1[2]));
                double distSq = pos.func_177951_i((Vec3i)Minecraft.func_71410_x().field_71439_g.func_180425_c());
                if (!(distSq < closestDistSq)) continue;
                closestDistSq = distSq;
                soul = s;
            }
            if (soul != null && !gainedSouls.contains(soul)) {
                gainedSouls.add(soul);
                soulData1.locations.put(this.island, gainedSouls);
                ++soulData1.soulCount;
                FairySouls.saveSoulData(soulData1);
            }
        }
    }

    private List<String> checkSouls(List<String> shownSouls) {
        FairySoulData data = FairySouls.getSoulData();
        if (data == null || data.locations == null || this.island == null) {
            return shownSouls;
        }
        List<String> gained = data.locations.get(this.island);
        if (gained == null || gained.isEmpty()) {
            return shownSouls;
        }
        ArrayList<String> result = new ArrayList<String>(shownSouls.size());
        for (String s : shownSouls) {
            if (gained.contains(s)) continue;
            result.add(s);
        }
        return result.isEmpty() ? shownSouls : result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FairySoulData getSoulData() {
        try {
            if (!Files.exists(SOULS_FILE.toPath(), new LinkOption[0])) {
                HashMap<String, List<String>> template = new HashMap<String, List<String>>();
                template.put("hub", new ArrayList());
                template.put("spider", new ArrayList());
                template.put("crimson", new ArrayList());
                template.put("end", new ArrayList());
                template.put("park", new ArrayList());
                template.put("farming", new ArrayList());
                template.put("gold", new ArrayList());
                template.put("dungeon_hub", new ArrayList());
                template.put("winter", new ArrayList());
                template.put("dwarven", new ArrayList());
                FairySoulData data = new FairySoulData("Do Not Manually Change This File, It will lead to errors", 0, template);
                FairySouls.saveSoulData(data);
                return data;
            }
            try (FileReader reader = new FileReader(SOULS_FILE);){
                FairySoulData fairySoulData = (FairySoulData)gson.fromJson((Reader)reader, FairySoulData.class);
                return fairySoulData;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new FairySoulData("Could not load file", 247, new HashMap<String, List<String>>());
        }
    }

    public static void saveSoulData(FairySoulData soulData) {
        try (FileWriter writer = new FileWriter(SOULS_FILE);){
            gson.toJson((Object)soulData, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static FairySoulData getAllSouls() {
        return RepoHandler.getData("fairysouls", FairySoulData.class, STUB_SOULS);
    }

    public static class FairySoulData {
        String description;
        int soulCount;
        Map<String, List<String>> locations;

        public FairySoulData(String desc, int souls, Map<String, List<String>> locs) {
            this.description = desc;
            this.soulCount = souls;
            this.locations = locs;
        }
    }
}

