/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;

@RegisterEvents
public class GoldenEnchants {
    public static final Map<String, String> t6Enchants;
    public static final Pattern t6EnchantPattern;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTooltip(ItemTooltipEvent event) {
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (event.toolTip == null || event.itemStack == null) {
            return;
        }
        if (Config.feature.qol.qolGoldenEnchants) {
            for (int i = 0; i < event.toolTip.size(); ++i) {
                String line = (String)event.toolTip.get(i);
                if (line == null) continue;
                event.toolTip.set(i, GoldenEnchants.returnGoldenEnchants(line));
            }
        }
    }

    public static String returnGoldenEnchants(String line) {
        if (line == null) {
            return "";
        }
        Matcher matcher = t6EnchantPattern.matcher(line);
        StringBuffer out = new StringBuffer();
        while (matcher.find()) {
            String replacement = t6Enchants.get(matcher.group(1));
            if (replacement != null) {
                matcher.appendReplacement(out, replacement);
                continue;
            }
            matcher.appendReplacement(out, matcher.group(1));
        }
        matcher.appendTail(out);
        return out.toString();
    }

    static {
        HashMap<String, String> tempEnchants = new HashMap<String, String>();
        tempEnchants.put("\u00a79Aiming IV", "\u00a76Aiming IV");
        tempEnchants.put("\u00a79Dragon Tracer V", "\u00a76Dragon Tracer V");
        tempEnchants.put("\u00a79Angler VI", "\u00a76Angler VI");
        tempEnchants.put("\u00a79Aqua Affinity I", "\u00a76Aqua Affinity I");
        tempEnchants.put("\u00a79Bane of Arthropods VII", "\u00a76Bane of Arthropods VII");
        tempEnchants.put("\u00a79Big Brain V", "\u00a76Big Brain V");
        tempEnchants.put("\u00a79Blast Protection VII", "\u00a76Blast Protection VII");
        tempEnchants.put("\u00a79Blessing VI", "\u00a76Blessing VI");
        tempEnchants.put("\u00a79Caster VI", "\u00a76Caster VI");
        tempEnchants.put("\u00a79Cayenne V", "\u00a76Cayenne V");
        tempEnchants.put("\u00a79Chance V", "\u00a76Chance V");
        tempEnchants.put("\u00a79Cleave VI", "\u00a76Cleave VI");
        tempEnchants.put("\u00a79Counter-Strike V", "\u00a76Counter-Strike V");
        tempEnchants.put("\u00a79Critical VII", "\u00a76Critical VII");
        tempEnchants.put("\u00a79Cubism VI", "\u00a76Cubism VI");
        tempEnchants.put("\u00a79Charm V", "\u00a76Charm V");
        tempEnchants.put("\u00a79Corruption V", "\u00a76Corruption V");
        tempEnchants.put("\u00a79Delicate V", "\u00a76Delicate V");
        tempEnchants.put("\u00a79Depth Strider III", "\u00a76Depth Strider III");
        tempEnchants.put("\u00a79Divine Gift III", "\u00a76Divine Gift III");
        tempEnchants.put("\u00a79Dragon Hunter V", "\u00a76Dragon Hunter V");
        tempEnchants.put("\u00a79Efficiency X", "\u00a76Efficiency X");
        tempEnchants.put("\u00a79Ender Slayer VII", "\u00a76Ender Slayer VII");
        tempEnchants.put("\u00a79Execute VI", "\u00a76Execute VI");
        tempEnchants.put("\u00a79Experience IV", "\u00a76Experience IV");
        tempEnchants.put("\u00a79Feather Falling X", "\u00a76Feather Falling X");
        tempEnchants.put("\u00a79Fire Aspect III", "\u00a76Fire Aspect III");
        tempEnchants.put("\u00a79Fire Protection VII", "\u00a76Fire Protection VII");
        tempEnchants.put("\u00a79First Strike V", "\u00a76First Strike V");
        tempEnchants.put("\u00a79Flame II", "\u00a76Flame II");
        tempEnchants.put("\u00a79Fortune IV", "\u00a76Fortune IV");
        tempEnchants.put("\u00a79Frail VI", "\u00a76Frail VI");
        tempEnchants.put("\u00a79Frost Walker II", "\u00a76Frost Walker II");
        tempEnchants.put("\u00a79Ferocious Mana X", "\u00a76Ferocious Mana X");
        tempEnchants.put("\u00a79Giant Killer VII", "\u00a76Giant Killer VII");
        tempEnchants.put("\u00a79Growth VII", "\u00a76Growth VII");
        tempEnchants.put("\u00a79Harvesting VI", "\u00a76Harvesting VI");
        tempEnchants.put("\u00a79Hardened Mana X", "\u00a76Hardened Mana X");
        tempEnchants.put("\u00a79Impaling III", "\u00a76Impaling III");
        tempEnchants.put("\u00a79Infinite Quiver X", "\u00a76Infinite Quiver X");
        tempEnchants.put("\u00a79Knockback II", "\u00a76Knockback II");
        tempEnchants.put("\u00a79Lethality VI", "\u00a76Lethality VI");
        tempEnchants.put("\u00a79Life Steal V", "\u00a76Life Steal V");
        tempEnchants.put("\u00a79Looting V", "\u00a76Looting V");
        tempEnchants.put("\u00a79Luck VII", "\u00a76Luck VII");
        tempEnchants.put("\u00a79Luck of the Sea VI", "\u00a76Luck of the Sea VI");
        tempEnchants.put("\u00a79Lure VI", "\u00a76Lure VI");
        tempEnchants.put("\u00a79Magnet VI", "\u00a76Magnet VI");
        tempEnchants.put("\u00a79Mana Steal III", "\u00a76Mana Steal III");
        tempEnchants.put("\u00a79Mana Vampire X", "\u00a76Mana Vampire X");
        tempEnchants.put("\u00a79Overload V", "\u00a76Overload V");
        tempEnchants.put("\u00a79Piercing I", "\u00a76Piercing I");
        tempEnchants.put("\u00a79Piscary VI", "\u00a76Piscary VI");
        tempEnchants.put("\u00a79Power VII", "\u00a76Power VII");
        tempEnchants.put("\u00a79Pristine V", "\u00a76Pristine V");
        tempEnchants.put("\u00a79Projectile Protection VII", "\u00a76Projectile Protection VII");
        tempEnchants.put("\u00a79Prosecute VI", "\u00a76Prosecute VI");
        tempEnchants.put("\u00a79Protection VII", "\u00a76Protection VII");
        tempEnchants.put("\u00a79Punch II", "\u00a76Punch II");
        tempEnchants.put("\u00a79Rainbow II", "\u00a76Rainbow II");
        tempEnchants.put("\u00a79Rejuvenate V", "\u00a76Rejuvenate V");
        tempEnchants.put("\u00a79Replenish I", "\u00a76Replenish I");
        tempEnchants.put("\u00a79Respiration III", "\u00a76Respiration III");
        tempEnchants.put("\u00a79Respite V", "\u00a76Respite V");
        tempEnchants.put("\u00a79Scavenger V", "\u00a76Scavenger V");
        tempEnchants.put("\u00a79Sharpness VII", "\u00a76Sharpness VII");
        tempEnchants.put("\u00a79Silk Touch I", "\u00a76Silk Touch I");
        tempEnchants.put("\u00a79Smarty Pants V", "\u00a76Smarty Pants V");
        tempEnchants.put("\u00a79Smelting Touch I", "\u00a76Smelting Touch I");
        tempEnchants.put("\u00a79Smite VII", "\u00a76Smite VII");
        tempEnchants.put("\u00a79Snipe IV", "\u00a7SantSnipe IV");
        tempEnchants.put("\u00a79Spiked Hook VI", "\u00a76Spiked Hook VI");
        tempEnchants.put("\u00a79Sugar Rush III", "\u00a76Sugar Rush III");
        tempEnchants.put("\u00a79Syphon V", "\u00a76Syphon V");
        tempEnchants.put("\u00a79Smoldering V", "\u00a76Smoldering V");
        tempEnchants.put("\u00a79Strong Mana X", "\u00a76Strong Mana X");
        tempEnchants.put("\u00a79Tabasco III", "\u00a76Tabasco III");
        tempEnchants.put("\u00a79Telekinesis I", "\u00a76Telekinesis I");
        tempEnchants.put("\u00a79Thorns III", "\u00a76Thorns III");
        tempEnchants.put("\u00a79Thunderbolt VI", "\u00a76Thunderbolt VI");
        tempEnchants.put("\u00a79Thunderlord VII", "\u00a76Thunderlord VII");
        tempEnchants.put("\u00a79Titan Killer VII", "\u00a76Titan Killer VII");
        tempEnchants.put("\u00a79Triple-Strike V", "\u00a76Triple-Strike V");
        tempEnchants.put("\u00a79True Protection I", "\u00a76True Protection I");
        tempEnchants.put("\u00a79Turbo-Cacti V", "\u00a76Turbo-Cacti V");
        tempEnchants.put("\u00a79Turbo-Cane V", "\u00a76Turbo-Cane V");
        tempEnchants.put("\u00a79Turbo-Carrot V", "\u00a76Turbo-Carrot V");
        tempEnchants.put("\u00a79Turbo-Cocoa V", "\u00a76Turbo-Cocoa V");
        tempEnchants.put("\u00a79Turbo-Melon V", "\u00a76Turbo-Melon V");
        tempEnchants.put("\u00a79Turbo-Mushrooms V", "\u00a76Turbo-Mushrooms V");
        tempEnchants.put("\u00a79Turbo-Potato V", "\u00a76Turbo-Potato V");
        tempEnchants.put("\u00a79Turbo-Pumpkin V", "\u00a76Turbo-Pumpkin V");
        tempEnchants.put("\u00a79Turbo-Warts V", "\u00a76Turbo-Warts V");
        tempEnchants.put("\u00a79Turbo-Wheat V", "\u00a76Turbo-Wheat V");
        tempEnchants.put("\u00a79Vampirism VI", "\u00a76Vampirism VI");
        tempEnchants.put("\u00a79Venomous VI", "\u00a76Venomous VI");
        tempEnchants.put("\u00a79Vicious V", "\u00a76Vicious V");
        tempEnchants.put("\u00a79Compact X", "\u00a76Compact X");
        tempEnchants.put("\u00a79Cultivating X", "\u00a76Cultivating X");
        tempEnchants.put("\u00a79Expertise X", "\u00a76Expertise X");
        tempEnchants.put("\u00a79Hecatomb X", "\u00a76Hecatomb X");
        tempEnchants.put("\u00a79Champion X", "\u00a76Champion X");
        t6Enchants = Collections.unmodifiableMap(tempEnchants);
        String patternString = "(" + String.join((CharSequence)"|", (CharSequence[])tempEnchants.keySet().stream().map(Pattern::quote).toArray(String[]::new)) + ")";
        t6EnchantPattern = Pattern.compile(patternString);
    }
}

