/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.variables.Skins;

@RegisterEvents
public class HideFlamingFists {
    private static final UUID TARGET_UUID = UUID.fromString("eaf71309-6ae5-3bf3-bf7f-51a579bbc6ee");
    private static final Set<EntityArmorStand> trackedStands = new HashSet<EntityArmorStand>();
    private static int checkTimer = 0;

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (!Config.feature.qol.qolHideFlamingFists || !ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (!event.world.field_72995_K) {
            return;
        }
        if (event.entity instanceof EntityArmorStand) {
            trackedStands.add((EntityArmorStand)event.entity);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!Config.feature.qol.qolHideFlamingFists || event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++checkTimer >= 5) {
            checkTimer = 0;
            this.checkArmorStands();
        }
    }

    private void checkArmorStands() {
        trackedStands.removeIf(s -> s == null || s.field_70128_L || !s.func_70089_S());
        for (EntityArmorStand stand : trackedStands) {
            ItemStack head = stand.func_71124_b(4);
            if (head == null || !HideFlamingFists.isTargetSkull(head)) continue;
            stand.func_82142_c(true);
        }
    }

    public static boolean isTargetSkull(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != Items.field_151144_bL) {
            return false;
        }
        String texture = ItemUtils.getSkullTexture(stack);
        if (texture == null || texture.isEmpty()) {
            return false;
        }
        return Skins.equalsSkin(texture, Skins.FLAMING_FIST);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            trackedStands.clear();
        }
    }

    @SubscribeEvent
    public void onRenderArmorStand(RenderLivingEvent.Pre<?> event) {
        if (!Config.feature.qol.qolHideFlamingFists || !(event.entity instanceof EntityArmorStand)) {
            return;
        }
        EntityArmorStand stand = (EntityArmorStand)event.entity;
        ItemStack head = stand.func_71124_b(4);
        if (HideFlamingFists.isTargetSkull(head)) {
            event.setCanceled(true);
        }
    }
}

