/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.StringUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Location;

@RegisterEvents
public class HidePlayersNearNpcs {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final double HIDE_RADIUS_IN = 3.0;
    private static final double HIDE_RADIUS_OUT = 4.0;
    private static final double HIDE_RADIUS_IN_SQ = 9.0;
    private static final double HIDE_RADIUS_OUT_SQ = 16.0;
    private static final int NPC_KEEP_ALIVE_TICKS = 60;
    private static final int HIDE_STABILITY_TICKS = 5;
    private static final Map<UUID, TrackedNpc> npcMap = new HashMap<UUID, TrackedNpc>(128);
    private static final Map<UUID, HideState> hideStateByPlayer = new HashMap<UUID, HideState>(256);
    private static int lastComputedTick = -1;
    private static final HashMap<UUID, Boolean> hideDecisionCache = new HashMap(256);

    public static boolean isNpc(Entity entity) {
        if (!(entity instanceof EntityOtherPlayerMP)) {
            return false;
        }
        EntityLivingBase base = (EntityLivingBase)entity;
        return entity.func_110124_au().version() == 4 && StringUtils.startsWithFast(base.func_70005_c_(), "\u00a7e\u00a7l");
    }

    public static void trackNpc(EntityOtherPlayerMP npc) {
        int tick;
        UUID id = npc.func_110124_au();
        TrackedNpc t = npcMap.get(id);
        int n = tick = HidePlayersNearNpcs.mc.field_71441_e.func_82737_E() != 0L ? (int)HidePlayersNearNpcs.mc.field_71441_e.func_82737_E() : (int)(System.nanoTime() & Integer.MAX_VALUE);
        if (t == null) {
            npcMap.put(id, new TrackedNpc(npc.field_70165_t, npc.field_70163_u, npc.field_70161_v, tick));
        } else {
            t.x = npc.field_70165_t;
            t.y = npc.field_70163_u;
            t.z = npc.field_70161_v;
            t.lastSeenTick = tick;
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPre(RenderPlayerEvent.Pre e) {
        UUID id;
        Boolean cached;
        if (HidePlayersNearNpcs.mc.field_71441_e == null || HidePlayersNearNpcs.mc.field_71439_g == null) {
            return;
        }
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (!Config.feature.qol.qolHidePlayerNearNpcs) {
            return;
        }
        if (TablistParser.currentLocation == Location.PRIVATE_ISLAND || TablistParser.currentLocation == Location.DUNGEON) {
            return;
        }
        Entity entity = e.entity;
        if (!(entity instanceof EntityOtherPlayerMP)) {
            return;
        }
        if (HidePlayersNearNpcs.isNpc(entity)) {
            return;
        }
        EntityOtherPlayerMP other = (EntityOtherPlayerMP)entity;
        int worldTick = (int)HidePlayersNearNpcs.mc.field_71441_e.func_82737_E();
        if (worldTick != lastComputedTick) {
            HidePlayersNearNpcs.cleanupStaleNpcs(worldTick);
            hideDecisionCache.clear();
            lastComputedTick = worldTick;
        }
        if ((cached = hideDecisionCache.get(id = other.func_110124_au())) == null) {
            cached = HidePlayersNearNpcs.shouldHideWithHysteresis(other, worldTick);
            hideDecisionCache.put(id, cached);
        }
        if (cached.booleanValue()) {
            e.setCanceled(true);
        }
    }

    public static boolean isCurrentlyHidden(UUID id) {
        Boolean b = hideDecisionCache.get(id);
        return b != null && b != false;
    }

    public static boolean checkForMixin(Entity entity) {
        return entity instanceof EntityOtherPlayerMP && !HidePlayersNearNpcs.isNpc(entity) && HidePlayersNearNpcs.isCurrentlyHidden(entity.func_110124_au());
    }

    private static boolean shouldHideWithHysteresis(EntityOtherPlayerMP player, int worldTick) {
        UUID id = player.func_110124_au();
        HideState state = hideStateByPlayer.computeIfAbsent(id, k -> new HideState(false, worldTick));
        double minDistSq = HidePlayersNearNpcs.minDistanceSqToAnyNpc(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        boolean targetHidden = state.hidden;
        if (state.hidden) {
            if (minDistSq > 16.0 && worldTick - state.lastFlipTick >= 5) {
                targetHidden = false;
            }
        } else if (minDistSq <= 9.0 && worldTick - state.lastFlipTick >= 5) {
            targetHidden = true;
        }
        if (targetHidden != state.hidden) {
            state.hidden = targetHidden;
            state.lastFlipTick = worldTick;
        }
        return state.hidden;
    }

    private static double minDistanceSqToAnyNpc(double x, double y, double z) {
        if (npcMap.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        double best = Double.POSITIVE_INFINITY;
        for (TrackedNpc t : npcMap.values()) {
            double dx = x - t.x;
            double dy = y - t.y;
            double dz = z - t.z;
            double d2 = dx * dx + dy * dy + dz * dz;
            if (d2 < best) {
                best = d2;
            }
            if (!(best <= 9.0)) continue;
            return best;
        }
        return best;
    }

    private static void cleanupStaleNpcs(int worldTick) {
        if (npcMap.isEmpty()) {
            return;
        }
        int cutoff = worldTick - 60;
        Iterator<Map.Entry<UUID, TrackedNpc>> it = npcMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, TrackedNpc> e = it.next();
            TrackedNpc t = e.getValue();
            if (t.lastSeenTick >= cutoff) continue;
            it.remove();
        }
    }

    @SubscribeEvent
    public void onWorldJoin(EntityJoinWorldEvent e) {
        if (e.world.field_72995_K && e.entity == HidePlayersNearNpcs.mc.field_71439_g) {
            npcMap.clear();
            hideStateByPlayer.clear();
            hideDecisionCache.clear();
            lastComputedTick = -1;
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload e) {
        if (e.world.field_72995_K) {
            npcMap.clear();
            hideStateByPlayer.clear();
            hideDecisionCache.clear();
            lastComputedTick = -1;
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent e) {
        if (!(e.entity instanceof EntityOtherPlayerMP)) {
            return;
        }
        UUID id = e.entity.func_110124_au();
        npcMap.remove(id);
        hideStateByPlayer.remove(id);
        hideDecisionCache.remove(id);
    }

    private static final class HideState {
        boolean hidden;
        int lastFlipTick;

        HideState(boolean hidden, int lastFlipTick) {
            this.hidden = hidden;
            this.lastFlipTick = lastFlipTick;
        }
    }

    private static final class TrackedNpc {
        double x;
        double y;
        double z;
        int lastSeenTick;

        TrackedNpc(double x, double y, double z, int tick) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.lastSeenTick = tick;
        }
    }
}

