/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.mixin.accesors.EntityPlayerAccessor;

@RegisterEvents
public class ItemAnimations {
    private static final float PI_F = (float)Math.PI;
    public static Minecraft mc = Minecraft.func_71410_x();
    private static float cachedSizeScale = 1.0f;
    private static float cachedPivotX = 0.56f;
    private static float cachedPivotY = -0.52f;
    private static float cachedPivotZ = -0.72f;
    private static float lastCustomSize = Float.NaN;
    private static float lastCustomX = Float.NaN;
    private static float lastCustomY = Float.NaN;
    private static float lastCustomZ = Float.NaN;

    private static void recacheIfNeeded() {
        float cSize = Config.feature.qol.customSize;
        float cX = Config.feature.qol.customX;
        float cY = Config.feature.qol.customY;
        float cZ = Config.feature.qol.customZ;
        if (cSize != lastCustomSize) {
            cachedSizeScale = (float)((double)0.4f * Math.exp(cSize));
            lastCustomSize = cSize;
        }
        if (cX != lastCustomX || cY != lastCustomY || cZ != lastCustomZ) {
            cachedPivotX = 0.56f * (1.0f + cX);
            cachedPivotY = -0.52f * (1.0f - cY);
            cachedPivotZ = -0.72f * (1.0f + cZ);
            lastCustomX = cX;
            lastCustomY = cY;
            lastCustomZ = cZ;
        }
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : Math.min(v, 1.0f);
    }

    public static void processItemAnimation(float equipProgress, float swingProgress) {
        ItemAnimations.recacheIfNeeded();
        GlStateManager.func_179109_b((float)cachedPivotX, (float)cachedPivotY, (float)cachedPivotZ);
        GlStateManager.func_179109_b((float)0.0f, (float)(-0.6f * equipProgress), (float)0.0f);
        GlStateManager.func_179114_b((float)Config.feature.qol.customPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Config.feature.qol.customYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Config.feature.qol.customRoll, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float swingSin = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        float swingSqrtSin = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
        GlStateManager.func_179114_b((float)(-20.0f * swingSin), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-20.0f * swingSqrtSin), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(-80.0f * swingSqrtSin), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)cachedSizeScale, (float)cachedSizeScale, (float)cachedSizeScale);
    }

    public static void changeSwingScale(float swingProgress) {
        ItemAnimations.recacheIfNeeded();
        float swingSqrt = MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI;
        float sinSqrt = MathHelper.func_76126_a((float)swingSqrt);
        float sinSqrt2 = MathHelper.func_76126_a((float)(swingSqrt * 2.0f));
        float sinLinear = MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        float offsetX = -0.4f * sinSqrt * cachedSizeScale;
        float offsetY = 0.2f * sinSqrt2 * cachedSizeScale;
        float offsetZ = -0.2f * sinLinear * cachedSizeScale;
        GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)offsetZ);
    }

    public static void rotationlessDrink(AbstractClientPlayer clientPlayer, float partialTicks) {
        if (clientPlayer == null || ItemAnimations.mc.field_71439_g == null || ItemAnimations.mc.field_71439_g.func_70694_bm() == null) {
            return;
        }
        EntityPlayerAccessor accessor = (EntityPlayerAccessor)clientPlayer;
        float useTimeLeft = (float)accessor.getItemInUseCount() - partialTicks + 1.0f;
        int maxUse = Math.max(1, ItemAnimations.mc.field_71439_g.func_70694_bm().func_77988_m());
        float useProgress = ItemAnimations.clamp01(useTimeLeft / (float)maxUse);
        float yOffset = MathHelper.func_76135_e((float)(MathHelper.func_76134_b((float)(useTimeLeft * 0.25f * (float)Math.PI)) * 0.1f));
        if (useProgress >= 0.8f) {
            yOffset = 0.0f;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)yOffset, (float)0.0f);
    }

    public static void scaledDrinking(AbstractClientPlayer clientPlayer, float partialTicks, ItemStack itemToRender) {
        if (clientPlayer == null || itemToRender == null) {
            return;
        }
        ItemAnimations.recacheIfNeeded();
        EntityPlayerAccessor accessor = (EntityPlayerAccessor)clientPlayer;
        float useTimeLeft = (float)accessor.getItemInUseCount() - partialTicks + 1.0f;
        int maxUse = Math.max(1, itemToRender.func_77988_m());
        float useProgress = ItemAnimations.clamp01(useTimeLeft / (float)maxUse);
        float wave = MathHelper.func_76134_b((float)(useTimeLeft * 0.25f * (float)Math.PI));
        float yOffset = MathHelper.func_76135_e((float)(wave * 0.1f));
        if (useProgress >= 0.8f) {
            yOffset = 0.0f;
        }
        float ease = 1.0f - (float)Math.pow(useProgress, 27.0);
        float pivotX = cachedPivotX - 0.56f;
        float pivotY = cachedPivotY + 0.52f;
        float pivotZ = cachedPivotZ + 0.72f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)pivotX, (float)pivotY, (float)pivotZ);
        GlStateManager.func_179109_b((float)0.0f, (float)yOffset, (float)0.0f);
        GlStateManager.func_179109_b((float)(ease * 0.6f), (float)(ease * -0.5f), (float)0.0f);
        GlStateManager.func_179114_b((float)(ease * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(ease * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(ease * 30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static boolean shouldChange() {
        return Config.feature.qol.customAnimations;
    }

    public static boolean shouldChangeScaleSwing() {
        return ItemAnimations.shouldChange() && Config.feature.qol.doesScaleSwing;
    }

    public static boolean shouldRotationlessDrink() {
        return ItemAnimations.shouldChange() && Config.feature.qol.drinkingSelector == 1;
    }

    public static boolean shouldScaledDrink() {
        return ItemAnimations.shouldChange() && Config.feature.qol.drinkingSelector == 2;
    }

    public static final class RenderConstants {
        public static final float VANILLA_PIVOT_X = 0.56f;
        public static final float VANILLA_PIVOT_Y = 0.52f;
        public static final float VANILLA_PIVOT_Z = 0.72f;

        private RenderConstants() {
        }
    }
}

