/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.variables.Resources;
import org.lwjgl.opengl.GL11;

public class ItemBackgroundRarity {
    private static final ResourceLocation RARITY_TEXTURE = Resources.RARITY_TEXTURE.getResource();
    private static final Pattern RARITY_PATTERN = Pattern.compile("(\u00a7[0-9a-f]\u00a7l\u00a7ka\u00a7r )?([\u00a70-9a-fk-or]+)(?<rarity>[A-Z]+)");
    private static final Pattern PET_PATTERN = Pattern.compile("\u00a77\\[Lvl \\d+\\] (?<color>\u00a7[0-9a-fk-or]).+");

    public static void renderRarityOverlay(ItemStack stack, int x, int y) {
        if (stack == null) {
            return;
        }
        ItemRarity rarity = ItemBackgroundRarity.getItemRarity(stack);
        if (rarity == null) {
            return;
        }
        ItemBackgroundRarity.renderRarityBackground(x, y, rarity);
    }

    private static void renderRarityBackground(int x, int y, ItemRarity rarity) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(RARITY_TEXTURE);
        ItemBackgroundRarity.setColorFromRarity(rarity);
        GL11.glTexEnvi((int)8960, (int)8704, (int)3042);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static void setColorFromRarity(ItemRarity rarity) {
        int rgb = ItemBackgroundRarity.getColorValue(rarity.getColor());
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        float a = Math.max(0.0f, Math.min(1.0f, Config.feature.qol.qolItemRarityOpacity));
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    private static int getColorValue(EnumChatFormatting format) {
        switch (format) {
            case GREEN: {
                return 0x55FF55;
            }
            case BLUE: {
                return 0x5555FF;
            }
            case DARK_PURPLE: {
                return 0xAA00AA;
            }
            case GOLD: {
                return 0xFFAA00;
            }
            case LIGHT_PURPLE: {
                return 0xFF55FF;
            }
            case AQUA: {
                return 0x55FFFF;
            }
            case DARK_RED: {
                return 0xAA0000;
            }
            case RED: {
                return 0xFF5555;
            }
        }
        return 0xFFFFFF;
    }

    public static ItemRarity getItemRarity(ItemStack item) {
        if (item == null || !item.func_77942_o()) {
            return null;
        }
        NBTTagCompound display = item.func_179543_a("display", false);
        if (display == null) {
            return null;
        }
        String name = ItemBackgroundRarity.getDisplayName(item);
        NBTTagList lore = display.func_150295_c("Lore", 8);
        Matcher petMatcher = PET_PATTERN.matcher(name);
        if (petMatcher.find()) {
            return ItemRarity.byBaseColor(petMatcher.group("color"));
        }
        for (int i = 0; i < lore.func_74745_c(); ++i) {
            String line = lore.func_150307_f(i);
            Matcher rarityMatcher = RARITY_PATTERN.matcher(line);
            if (!rarityMatcher.find()) continue;
            String rarityName = rarityMatcher.group("rarity");
            for (ItemRarity rarity : ItemRarity.values()) {
                if (!rarityName.startsWith(rarity.name)) continue;
                return rarity;
            }
        }
        return null;
    }

    private static String getDisplayName(ItemStack item) {
        NBTTagCompound display;
        if (item.func_77942_o() && item.func_77978_p().func_150297_b("display", 10) && (display = item.func_77978_p().func_74775_l("display")).func_150297_b("Name", 8)) {
            return display.func_74779_i("Name");
        }
        return item.func_82833_r();
    }

    public static enum ItemRarity {
        COMMON("COMMON", EnumChatFormatting.WHITE),
        UNCOMMON("UNCOMMON", EnumChatFormatting.GREEN),
        RARE("RARE", EnumChatFormatting.BLUE),
        EPIC("EPIC", EnumChatFormatting.DARK_PURPLE),
        LEGENDARY("LEGENDARY", EnumChatFormatting.GOLD),
        MYTHIC("MYTHIC", EnumChatFormatting.LIGHT_PURPLE),
        DIVINE("DIVINE", EnumChatFormatting.AQUA),
        SUPREME("SUPREME", EnumChatFormatting.DARK_RED),
        SPECIAL("SPECIAL", EnumChatFormatting.RED),
        VERY_SPECIAL("VERY SPECIAL", EnumChatFormatting.RED);

        private final String name;
        private final EnumChatFormatting color;

        private ItemRarity(String name, EnumChatFormatting color) {
            this.name = name;
            this.color = color;
        }

        public static ItemRarity byBaseColor(String colorCode) {
            for (ItemRarity rarity : ItemRarity.values()) {
                if (!rarity.color.toString().equals(colorCode)) continue;
                return rarity;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public EnumChatFormatting getColor() {
            return this.color;
        }
    }
}

