/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.lwjgl.input.Mouse;

@RegisterEvents
public class MiddleClickEvent {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final List<String> menuWhitelist = Arrays.asList("Skyblock Menu", "Chronomatron", "Experiment Over", "Ultrasequencer", "Superpairs", "Coop Bank Account", "Booster Cookie", "Pets", "Storage", "Your Museum", "Museum", "Settings", "Autopet", "Quest Log", "Trades", "Profiles");
    private static final List<String> itemWhitelist = Arrays.asList("Go Back", "Close", "\u00ab First Page", "Last Page \u00bb", "Next Page \u2192", "\u2190 Previous Page", "Enable Favorites", "Chocolate", "Rabbit", "CLICK ME");

    @SubscribeEvent
    public void onMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (!Config.feature.qol.qolMiddleClickChests) {
            return;
        }
        if (Mouse.getEventButton() != 0 || !Mouse.getEventButtonState()) {
            return;
        }
        if (!(MiddleClickEvent.mc.field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiChest chestGui = (GuiChest)MiddleClickEvent.mc.field_71462_r;
        ContainerChest container = (ContainerChest)chestGui.field_147002_h;
        String chestName = container.func_85151_d().func_145748_c_().func_150260_c();
        if (!this.isValidClick(chestGui)) {
            return;
        }
        if (menuWhitelist.stream().anyMatch(name -> name.contains(chestName))) {
            this.registerMiddleClickEvent(event, chestGui);
            return;
        }
        ItemStack item = container.func_75139_a(chestGui.getSlotUnderMouse().field_75222_d).func_75211_c();
        if (ItemUtils.isMenuItem(item) || itemWhitelist.stream().anyMatch(itemName -> item.func_82833_r().contains((CharSequence)itemName))) {
            this.registerMiddleClickEvent(event, chestGui);
        }
    }

    private boolean isValidClick(GuiChest chestGui) {
        ContainerChest container = (ContainerChest)chestGui.field_147002_h;
        if (chestGui.getSlotUnderMouse() == null || container == null || container.func_75139_a(chestGui.getSlotUnderMouse().field_75222_d).func_75211_c() == null) {
            return false;
        }
        return container.func_75139_a(chestGui.getSlotUnderMouse().field_75222_d).func_75211_c().func_82833_r() != null;
    }

    private void registerMiddleClickEvent(GuiScreenEvent.MouseInputEvent.Pre event, GuiChest chestGui) {
        int slot;
        ContainerChest container = (ContainerChest)chestGui.field_147002_h;
        event.setCanceled(true);
        int n = slot = chestGui.getSlotUnderMouse() != null ? chestGui.getSlotUnderMouse().field_75222_d : -1;
        if (slot >= 0) {
            MiddleClickEvent.mc.field_71442_b.func_78753_a(container.field_75152_c, slot, 2, 0, (EntityPlayer)MiddleClickEvent.mc.field_71439_g);
        }
    }
}

