/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.qol;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.S08PacketPlayerPosLook;
import net.minecraft.network.play.server.S0EPacketSpawnObject;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.PacketReadEvent;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;

@RegisterEvents
public class MiscFeatures {
    ArrayList<Block> flowerPlaceable = new ArrayList<Block>(Arrays.asList(Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150457_bL, Blocks.field_150329_H, Blocks.field_150398_cm));
    List<ItemStack> armour = new ArrayList<ItemStack>();
    private final Minecraft mc = Minecraft.func_71410_x();
    private BlockPos teleportTarget = null;
    private long teleportStartTime = 0L;
    private Long landingTime = null;
    private static final long TELEPORT_GRACE_PERIOD_MS = 5000L;
    private static final long SOUND_WINDOW_MS = 1000L;

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        if (!ScoreboardUtils.currentGamemode.isSkyblock() || this.mc.field_71439_g != event.entityPlayer) {
            return;
        }
        ItemStack item = event.entityPlayer.func_70694_bm();
        if (item == null) {
            return;
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            Block block = this.mc.field_71441_e.func_180495_p(event.pos).func_177230_c();
            if (this.flowerPlaceable.contains(block)) {
                if (Config.feature.qol.qolBlockPlacingItems && item.func_82833_r().contains("Flower of Truth")) {
                    event.setCanceled(true);
                }
                if (Config.feature.qol.qolBlockPlacingItems && item.func_82833_r().contains("Spirit Sceptre")) {
                    event.setCanceled(true);
                }
                if (Config.feature.qol.qolBlockPlacingItems && item.func_82833_r().contains("Bouquet of Lies")) {
                    event.setCanceled(true);
                }
            }
            if (Config.feature.qol.qolBlockPlacingItems && item.func_82833_r().contains("Superboom TNT")) {
                event.setCanceled(true);
            }
            if (Config.feature.qol.qolBlockPlacingItems && item.func_82833_r().contains("Infinityboom TNT")) {
                event.setCanceled(true);
            }
            if (Config.feature.qol.qolBlockPlacingItems && item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150438_bZ) && item.func_82833_r().contains("Weird Tuba")) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent event) {
        List<Block> excludedBlocks;
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR && event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (this.mc.field_71439_g != event.entityPlayer) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        if (player == null || !player.func_70093_af() || player.func_70694_bm() == null) {
            return;
        }
        String cleanName = EnumChatFormatting.func_110646_a((String)player.func_70694_bm().func_82833_r());
        if (!cleanName.contains("Aspect of the Void") && !cleanName.contains("Aspect of the End")) {
            return;
        }
        EtherWarpData data = this.getEtherWarpData(player);
        if (!data.hasEther || data.range <= 0) {
            return;
        }
        Vec3 startVec = player.func_174824_e(1.0f);
        Vec3 lookVec = player.func_70676_i(1.0f);
        Vec3 endVec = startVec.func_72441_c(lookVec.field_72450_a * (double)data.range, lookVec.field_72448_b * (double)data.range, lookVec.field_72449_c * (double)data.range);
        BlockPos target = this.raycastBlocks(player.field_70170_p, startVec, endVec, excludedBlocks = Arrays.asList(Blocks.field_150478_aa, Blocks.field_150358_i, Blocks.field_150355_j, Blocks.field_150472_an, Blocks.field_150444_as, Blocks.field_150431_aC, Blocks.field_150398_cm, Blocks.field_150429_aA, Blocks.field_150471_bO, Blocks.field_150430_aB, Blocks.field_150404_cg, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150468_ap, Blocks.field_150356_k, Blocks.field_150353_l));
        if (target == null) {
            return;
        }
        boolean isAirAbove1 = player.field_70170_p.func_175623_d(target.func_177984_a());
        boolean isAirAbove2 = player.field_70170_p.func_175623_d(target.func_177981_b(2));
        if (!isAirAbove1 || !isAirAbove2) {
            return;
        }
        this.teleportTarget = target;
        this.teleportStartTime = System.currentTimeMillis();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.teleportTarget == null) {
            return;
        }
        try {
            EntityPlayerSP player = this.mc.field_71439_g;
            if (player == null) {
                return;
            }
            double targetX = (double)this.teleportTarget.func_177958_n() + 0.5;
            double targetY = this.teleportTarget.func_177956_o() + 1;
            double targetZ = (double)this.teleportTarget.func_177952_p() + 0.5;
            if (System.currentTimeMillis() - this.teleportStartTime > 5000L) {
                this.teleportTarget = null;
                this.landingTime = null;
                return;
            }
            double distance = player.func_70011_f(targetX, targetY, targetZ);
            if (distance < 1.0 && this.landingTime == null) {
                this.landingTime = System.currentTimeMillis();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onPacketRead(PacketReadEvent event) {
        S0EPacketSpawnObject spawnPacket;
        if (event.packet instanceof S0EPacketSpawnObject && (spawnPacket = (S0EPacketSpawnObject)event.packet).func_148993_l() == 70 && Config.feature.qol.qolHideFallingBlocks) {
            event.setCanceled(true);
        }
        if (event.packet instanceof S29PacketSoundEffect) {
            long currentTime;
            long timeDifference;
            S29PacketSoundEffect soundPacket = (S29PacketSoundEffect)event.packet;
            EntityPlayerSP player = this.mc.field_71439_g;
            if (player == null) {
                return;
            }
            if ("mob.endermen.portal".equals(soundPacket.func_149212_c()) && this.landingTime != null && Math.abs(timeDifference = (currentTime = System.currentTimeMillis()) - this.landingTime) <= 1000L) {
                event.setCanceled(true);
                String soundName = this.getConfiguredSound();
                SoundUtils.playSound((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, soundName, 2.0f, 1.0f);
                this.landingTime = null;
                this.teleportTarget = null;
            }
        } else if (event.packet instanceof S08PacketPlayerPosLook && this.teleportTarget != null && System.currentTimeMillis() - this.teleportStartTime <= 5000L) {
            this.landingTime = System.currentTimeMillis();
            this.teleportTarget = null;
        }
    }

    private String getConfiguredSound() {
        switch (Config.feature.qol.qolEtherwarpSound) {
            case 1: {
                return "mob.blaze.hit";
            }
            case 2: {
                return "note.pling";
            }
            case 3: {
                return "random.orb";
            }
            case 4: {
                return "mob.enderdragon.hit";
            }
            case 5: {
                return "mob.cat.meow";
            }
        }
        return "mob.endermen.portal";
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderLivingSpecialsPre(RenderLivingEvent.Specials.Pre<EntityLivingBase> event) {
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (Config.feature.qol.qolHideDyingMobs) {
            EntityLivingBase entity = event.entity;
            String name = entity.func_145748_c_().func_150260_c();
            Pattern pattern1 = Pattern.compile("^\u00a7.\\[\u00a7.Lv\\d+\u00a7.\\] \u00a7.+ (?:\u00a7.)+0\u00a7f/.+\u00a7c\u2764$");
            Pattern pattern2 = Pattern.compile("^.+ (?:\u00a7.)+0\u00a7c\u2764$");
            if (pattern1.matcher(name).matches() || pattern2.matcher(name).matches()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre<EntityLivingBase> event) {
        EntityLivingBase entity;
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (Config.feature.qol.qolHideDyingMobs && ((entity = event.entity).func_110143_aJ() <= 0.0f || entity.field_70128_L)) {
            double playerX = Minecraft.func_71410_x().field_71439_g.field_70165_t;
            double playerZ = Minecraft.func_71410_x().field_71439_g.field_70161_v;
            double teleportY = -64.0;
            entity.func_70634_a(playerX, teleportY, playerZ);
            event.setCanceled(true);
        }
        if (Config.feature.qol.qolHidePlayerArmor && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                if (player.field_71071_by.field_70460_b[i] != null) {
                    this.armour.add(player.field_71071_by.field_70460_b[i].func_77946_l());
                    player.field_71071_by.field_70460_b[i] = null;
                    continue;
                }
                this.armour.add(null);
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingSpecials(RenderLivingEvent.Specials.Pre<EntityLivingBase> event) {
        EntityLivingBase entity;
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (Config.feature.qol.qolHideDyingMobs && ((entity = event.entity).func_110143_aJ() <= 0.0f || entity.field_70128_L)) {
            double playerX = Minecraft.func_71410_x().field_71439_g.field_70165_t;
            double playerZ = Minecraft.func_71410_x().field_71439_g.field_70161_v;
            double teleportY = -64.0;
            entity.func_70634_a(playerX, teleportY, playerZ);
            event.setCanceled(true);
        }
    }

    private BlockPos raycastBlocks(World world, Vec3 start, Vec3 end, List<Block> excludedBlocks) {
        Vec3 direction = end.func_178788_d(start).func_72432_b();
        double maxDistance = start.func_72438_d(end);
        for (double d = 0.0; d <= maxDistance; d += 0.05) {
            Vec3 currentVec = start.func_72441_c(direction.field_72450_a * d, direction.field_72448_b * d, direction.field_72449_c * d);
            BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)currentVec.field_72450_a), MathHelper.func_76128_c((double)currentVec.field_72448_b), MathHelper.func_76128_c((double)currentVec.field_72449_c));
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block == Blocks.field_150350_a || excludedBlocks.contains(block)) continue;
            return pos;
        }
        return null;
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        List<Block> excludedBlocks;
        if (this.mc.field_71439_g == null) {
            return;
        }
        EntityPlayerSP player = this.mc.field_71439_g;
        if (!player.func_70093_af()) {
            return;
        }
        EtherWarpData data = this.getEtherWarpData((EntityPlayer)player);
        if (!data.hasEther || data.range <= 0) {
            return;
        }
        Vec3 startVec = player.func_174824_e(1.0f);
        Vec3 lookVec = player.func_70676_i(1.0f);
        Vec3 endVec = startVec.func_72441_c(lookVec.field_72450_a * (double)data.range, lookVec.field_72448_b * (double)data.range, lookVec.field_72449_c * (double)data.range);
        BlockPos target = this.raycastBlocks((World)this.mc.field_71441_e, startVec, endVec, excludedBlocks = Arrays.asList(Blocks.field_150478_aa, Blocks.field_150358_i, Blocks.field_150355_j, Blocks.field_150472_an, Blocks.field_150444_as, Blocks.field_150431_aC, Blocks.field_150398_cm, Blocks.field_150429_aA, Blocks.field_150471_bO, Blocks.field_150430_aB, Blocks.field_150404_cg, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150468_ap, Blocks.field_150356_k, Blocks.field_150353_l));
        if (target == null) {
            return;
        }
        boolean isAirAbove1 = this.mc.field_71441_e.func_175623_d(target.func_177984_a());
        boolean isAirAbove2 = this.mc.field_71441_e.func_175623_d(target.func_177981_b(2));
        if (isAirAbove1 && isAirAbove2 && Config.feature.qol.qolEtherwarpOverlay) {
            this.renderFilledBoundingBox(target, ColorUtils.getColor(Config.feature.qol.qolEtherwarpOverlayColor));
        }
    }

    private EtherWarpData getEtherWarpData(EntityPlayer player) {
        boolean isCorrectItem;
        ItemStack stack = player.func_70694_bm();
        if (stack == null) {
            return new EtherWarpData(false, 0);
        }
        String displayName = stack.func_82833_r();
        String cleanName = EnumChatFormatting.func_110646_a((String)displayName);
        boolean bl = isCorrectItem = cleanName.contains("Aspect of the Void") || cleanName.contains("Aspect of the End");
        if (!isCorrectItem) {
            return new EtherWarpData(false, 0);
        }
        List loreLines = stack.func_82840_a(player, false);
        boolean hasEther = false;
        int range = 0;
        Pattern rangePattern = Pattern.compile(".*?(\\d+) blocks away.*");
        for (String line : loreLines) {
            Matcher matcher;
            String cleanLine = EnumChatFormatting.func_110646_a((String)line);
            if (cleanLine.contains("Ether")) {
                hasEther = true;
            }
            if (!(matcher = rangePattern.matcher(cleanLine)).matches()) continue;
            try {
                range = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new EtherWarpData(hasEther, range);
    }

    private void renderFilledBoundingBox(BlockPos pos, Color color) {
        double x = (double)pos.func_177958_n() - this.mc.func_175598_ae().field_78730_l;
        double y = (double)pos.func_177956_o() - this.mc.func_175598_ae().field_78731_m;
        double z = (double)pos.func_177952_p() - this.mc.func_175598_ae().field_78728_n;
        AxisAlignedBB box = new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_72314_b(0.002, 0.002, 0.002);
        this.drawFilledBoundingBox(box, color);
    }

    private void drawFilledBoundingBox(AxisAlignedBB box, Color color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179129_p();
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldrenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChatReceived(ClientChatReceivedEvent e) {
        String unformattedText;
        if (e.type == 2) {
            return;
        }
        if (Config.feature.misc.qolCopyChatMsg && !(unformattedText = StringUtils.func_76338_a((String)e.message.func_150260_c())).replace(" ", "").isEmpty()) {
            ChatComponentText copyText = new ChatComponentText(EnumChatFormatting.DARK_GRAY + "\u270d");
            if (Config.feature.misc.copyChatString.equals("[COPY]")) {
                copyText = new ChatComponentText(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + "[COPY]");
            } else if (Config.feature.misc.copyChatString.equals("Legacy Emoji")) {
                copyText = new ChatComponentText(EnumChatFormatting.DARK_GRAY + "\u270d");
            }
            ChatStyle style = new ChatStyle().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + "Copy message"))).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/copytoclipboard " + unformattedText));
            copyText.func_150255_a(style);
            e.message.func_150257_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RESET + " "));
            e.message.func_150257_a((IChatComponent)copyText);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (Config.feature.misc.qolAlwaysSprint) {
            KeyBinding.func_74510_a((int)this.mc.field_71474_y.field_151444_V.func_151463_i(), (boolean)true);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post<EntityLivingBase> event) {
        if (Config.feature.qol.qolHidePlayerArmor && ScoreboardUtils.currentGamemode.isSkyblock() && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                player.field_71071_by.field_70460_b[i] = this.armour.get(i);
            }
            this.armour.clear();
        }
    }

    private static class EtherWarpData {
        public boolean hasEther;
        public int range;

        public EtherWarpData(boolean hasEther, int range) {
            this.hasEther = hasEther;
            this.range = range;
        }
    }
}

